/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.configbackup;

import com.huawei.EncryptedPropertiesHandler;
import com.huawei.FileSignHandler;
import com.huawei.ism.drm.configbackup.AESEncryptor;
import com.huawei.ism.drm.configbackup.AESUtil;
import com.huawei.ism.drm.configbackup.CmdUtil;
import com.huawei.ism.drm.configbackup.ErrHandleTask;
import com.huawei.ism.drm.configbackup.ExceptionUtil;
import com.huawei.ism.drm.configbackup.PortCheckUtil;
import com.huawei.ism.drm.configbackup.Printer;
import com.huawei.ism.drm.configbackup.ZipUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import com.huawei.util.CommonUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GaussDBrestoreImpl {
    private static boolean isSaltFileExist = false;
    private String host = "";
    private String port = "";
    private String userName = "";
    private String userPass = "";
    private String superUserName = "";
    private String superUserPass = "";
    private String dbName = "lego";
    private int[] ports = new int[3];
    private static String exportFile = "";
    private static final String LINUX_RESTORE = "/usr/local/gaussdb/bin/gsql";
    private static final String WINDOWS_RESTORE = "/tools/windows/gsql";
    private static final String WCC_FILE = "wcc.conf";
    private static final int APM_PORT_PARAM_MAX_SZIE = 65535;
    private static final String RUNTIME_FILE = System.getProperties().getProperty("user.dir").substring(0, System.getProperties().getProperty("user.dir").lastIndexOf("Runtime") + "Runtime".length()) + File.separator + "bin" + File.separator + "config" + File.separator + "conf" + File.separator + "config.properties";
    private String installPath = System.getProperties().getProperty("user.dir").substring(0, System.getProperties().getProperty("user.dir").lastIndexOf("Runtime") + "Runtime".length());
    private static String INSTALLED_FILE = "config/system.xml";
    private static final String KMC_PATH = "/Runtime/LegoRuntime/conf/wcc";
    private static final int FOUR = 4;
    private static final int EIGHT = 8;
    private static final String STR_ENG = "^[A-Za-z]+$";
    private static final Log logger = LogFactory.getInstance(GaussDBrestoreImpl.class);
    private static byte[] SALT = new byte[128];
    private static byte[] IV = new byte[16];
    private static String encryptFile = "";
    private static String tmpPath = "";
    private String encryptPassword = null;

    public GaussDBrestoreImpl() throws Exception {
        this.parseConf();
        this.parseXML();
    }

    public static boolean isIsSaltFileExist() {
        return isSaltFileExist;
    }

    public static byte[] getSalt() {
        return SALT;
    }

    public static byte[] getIV() {
        return IV;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importDB(File fileLoc) {
        String encryptFile = this.getEncryptFile(fileLoc);
        try {
            if ("".equals(encryptFile)) {
                Printer.println("Decrypt file failed.");
                logger.error((Object)"get encrypt file failed.", "");
                return;
            }
            this.load(encryptFile);
        }
        catch (Exception e) {
            logger.error((Object)("importDB error." + ExceptionUtil.getErrorMessage(e)));
            Printer.println("ImportDB error.");
        }
        finally {
            File path = new File(tmpPath);
            this.deleteTmpFiles(path);
        }
    }

    private boolean checkSystemRuning() {
        int sysStatus = PortCheckUtil.checkSystemUsing(this.ports);
        if (-1 != sysStatus) {
            Printer.println("The system is in using, please stop the system and retry!");
            return false;
        }
        return true;
    }

    private String getEncryptFile(File zipFile) {
        String zip = "";
        try {
            GaussDBrestoreImpl.getSaltAndIV(zipFile);
        }
        catch (Exception e) {
            File path = new File(tmpPath);
            this.deleteTmpFiles(path);
        }
        File f = new File(encryptFile);
        if (f.exists()) {
            zip = encryptFile;
        }
        return zip;
    }

    private void deleteTmpFiles(File path) {
        if (path.exists() && path.isDirectory()) {
            File[] f;
            for (File tmp : f = path.listFiles()) {
                tmp.delete();
            }
            path.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectionGaussDB() {
        Connection conn = null;
        boolean isValid = false;
        try {
            String url = "jdbc:postgresql://" + this.host + ":" + this.port + "/POSTGRES";
            Class.forName("org.postgresql.Driver");
            conn = DriverManager.getConnection(url, this.superUserName, this.superUserPass);
            isValid = this.clearDB(conn);
        }
        catch (Exception e) {
            logger.error((Object)("Connection database failed." + ExceptionUtil.getErrorMessage(e)), "");
            Printer.println("Connection database failed.");
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e1) {
                    logger.error((Object)("DB Connection Close Error" + ExceptionUtil.getErrorMessage(e1)), "");
                    Printer.println("DB connection Close Error");
                }
            }
        }
        return isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseConf() {
        logger.debug((Object)"Start parseConf", "");
        FileInputStream in = null;
        try {
            File file = new File(RUNTIME_FILE);
            in = new FileInputStream(file);
            Properties p = new Properties();
            p.load(in);
            Object o = p.get("rmi.port");
            if (null != o) {
                this.ports[2] = Integer.valueOf(String.valueOf(o));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Failed parseConf " + ExceptionUtil.getErrorMessage(e)), "");
            Printer.println("Failed parseConf");
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                logger.error((Object)"Failed parseConf", (Throwable)e);
                Printer.println("Failed parseConf");
            }
        }
        logger.debug((Object)"Success parseConf", "");
    }

    private void parseXML() throws Exception {
        logger.debug((Object)"Start parseXML", "");
        try {
            File file = new File(INSTALLED_FILE);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            CommonUtil.setSecurityFeatures((DocumentBuilderFactory)factory);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(file);
            NodeList nl = doc.getElementsByTagName("install");
            int size = nl.getLength();
            for (int i = 0; i < size; ++i) {
                Element bookElement = (Element)nl.item(i);
                NodeList childNodes = bookElement.getChildNodes();
                int sizeChild = childNodes.getLength();
                for (int j = 0; j < sizeChild; ++j) {
                    Node node = childNodes.item(j);
                    this.degradeParseXML(node);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Failed parseXML: " + ExceptionUtil.getErrorMessage(e)), "");
            Printer.println("Failed parseXML");
        }
        this.checkParam();
        logger.debug((Object)"Success parseXML", "");
    }

    private void checkParam() throws Exception {
        if (this.isEmpty(this.userName) || this.isEmpty(this.host) || this.isEmpty(this.userPass) || this.isEmpty(this.port) || this.isEmpty(this.superUserName) || this.isEmpty(this.superUserPass)) {
            logger.info((Object)"check param failed~!", "");
            throw new Exception();
        }
        if (!CmdUtil.checkParam(this.userName, STR_ENG, 4, 8) || !CmdUtil.checkParam(this.superUserName, STR_ENG, 4, 8)) {
            logger.info((Object)"check param failed~!", "");
            throw new Exception();
        }
        if (!this.checkDrmPortParam(this.port) || !this.checkIpParam().booleanValue()) {
            logger.info((Object)"check param failed~!", "");
            throw new Exception();
        }
    }

    private Boolean checkIpParam() throws Exception {
        String matchIp = "(2[2][0-3]|2[0-1]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})";
        return this.checkParam(this.host, matchIp);
    }

    private boolean checkParam(String param, String match) throws Exception {
        if (this.isEmpty(param) || this.isEmpty(match)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Check param is error.");
            sb.append(" regEx :");
            sb.append(match);
            sb.append(" is error.");
            logger.error((Object)sb.toString(), "");
            Printer.println(sb.toString());
            throw new Exception();
        }
        Pattern pat = Pattern.compile(match);
        Matcher mat = pat.matcher(Normalizer.normalize(param, Normalizer.Form.NFKC));
        return mat.matches() && mat.find(0) && 0 <= mat.groupCount();
    }

    private boolean checkDrmPortParam(String portStr) throws Exception {
        int port = 0;
        try {
            port = Integer.valueOf(portStr);
        }
        catch (NumberFormatException e) {
            logger.info((Object)("check port is error . parm:" + portStr), "");
            throw new Exception();
        }
        return port > 0 && 65535 >= port;
    }

    private boolean isEmpty(String string) {
        return null == string || string.trim().isEmpty();
    }

    private void degradeParseXML(Node node) {
        if (node.getNodeType() == 1) {
            if ("database".equals(node.getNodeName())) {
                NamedNodeMap nnm = node.getAttributes();
                this.host = nnm.getNamedItem("dbhost").getNodeValue();
                this.port = nnm.getNamedItem("dbport").getNodeValue();
                this.userName = nnm.getNamedItem("dbuserName").getNodeValue();
                this.userPass = AESEncryptor.wccDecrypt(nnm.getNamedItem("dbpassword").getNodeValue());
                this.superUserName = nnm.getNamedItem("manageruserName").getNodeValue();
                this.superUserPass = AESEncryptor.wccDecrypt(nnm.getNamedItem("managerpassword").getNodeValue());
            } else if ("httport".equals(node.getNodeName())) {
                this.ports[0] = this.parsePort(node.getTextContent());
            } else if ("httpsport".equals(node.getNodeName())) {
                this.ports[1] = Integer.parseInt(node.getTextContent());
            } else {
                logger.warn((Object)("nodeName is not supported.nodeName:" + node.getNodeName()), "");
            }
        }
    }

    private int parsePort(String port) {
        if (port == null || !port.matches("\\s*\\d+\\s*")) {
            return -1;
        }
        return Integer.parseInt(port.trim());
    }

    private void load(String fileLoc) throws Exception {
        File file = this.uncryptFile(fileLoc);
        if (null == file) {
            return;
        }
        if (!file.getName().endsWith(".sql")) {
            Printer.println("Decrypt file failed, please check your password.");
            logger.info((Object)("The file is not correct. fileName=" + file.getName()), "");
            return;
        }
        if (!this.connectionGaussDB()) {
            return;
        }
        String osName = System.getProperty("os.name");
        this.checkParam();
        String filePath = this.installPath.split("Runtime")[0];
        EncryptedPropertiesHandler encryptedPropertiesHandler = new EncryptedPropertiesHandler("", filePath + KMC_PATH);
        encryptedPropertiesHandler.beforeBackup(filePath);
        File wccConf = new File(exportFile);
        AESEncryptor.importWccConfig(wccConf.getCanonicalPath(), this.encryptPassword);
        encryptedPropertiesHandler.afterBackup(filePath);
        if (osName.contains("Windows")) {
            this.loadWindows(file.getCanonicalPath());
        } else {
            this.loadLinux(file.getCanonicalPath());
        }
        new FileSignHandler(filePath + KMC_PATH, filePath);
        try {
            file.delete();
        }
        catch (Exception e) {
            Printer.println("Unsuccessful to delete the temp file: " + ExceptionUtil.getErrorMessage(e));
            logger.info((Object)"Unsuccessful to delete the temp file.", "");
        }
    }

    private static void getSaltAndIV(File zipFile) throws Exception {
        FileInputStream salt = null;
        FileInputStream iv = null;
        File saltF = null;
        File ivF = null;
        try {
            File[] files;
            tmpPath = ZipUtil.getInstallPath() + File.separator + "Runtime" + File.separator + "tmpSql";
            ZipUtil.getInstance().unzipFile(tmpPath, zipFile);
            String saltFile = tmpPath + File.separator + "zip1.tmp";
            String ivFile = tmpPath + File.separator + "zip2.tmp";
            saltF = new File(saltFile);
            if (saltF.exists()) {
                salt = new FileInputStream(saltF);
                ((InputStream)salt).read(SALT);
                isSaltFileExist = true;
            }
            ivF = new File(ivFile);
            iv = new FileInputStream(ivF);
            ((InputStream)iv).read(IV);
            for (File file1 : files = new File(tmpPath).listFiles()) {
                if (file1.getName().endsWith(".zip")) {
                    encryptFile = tmpPath + File.separator + file1.getName();
                }
                if (!WCC_FILE.equals(file1.getName())) continue;
                exportFile = tmpPath + File.separator + WCC_FILE;
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("get salt or iv data failed." + ExceptionUtil.getErrorMessage(e)), "");
                throw e;
            }
            catch (Throwable throwable) {
                GaussDBrestoreImpl.closeStream(salt);
                GaussDBrestoreImpl.closeStream(iv);
                ivF.delete();
                saltF.delete();
                throw throwable;
            }
        }
        GaussDBrestoreImpl.closeStream(salt);
        GaussDBrestoreImpl.closeStream(iv);
        ivF.delete();
        saltF.delete();
    }

    private static void closeStream(InputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"close stream failed.", (Throwable)e, "");
        }
    }

    private File uncryptFile(String fileLoc) {
        File file = new File(fileLoc);
        if (!file.exists()) {
            Printer.println("File is not exist.");
            logger.error((Object)"File is not exist.", "");
            return null;
        }
        String password = this.encryptPassword != null ? this.encryptPassword : this.userPass;
        File zipFile = AESUtil.getInstance().decryptFile(file, ".zip", password);
        File f = null;
        if (zipFile == null) {
            logger.error((Object)"Decrypt file failed, please check your password.", "");
            return f;
        }
        try {
            f = ZipUtil.getInstance().unzipFile(zipFile.getParent(), zipFile);
        }
        catch (Exception e) {
            logger.error((Object)("unzip file error: " + ExceptionUtil.getErrorMessage(e)), "");
        }
        zipFile.delete();
        return f;
    }

    private void loadWindows(String sqlFile) {
        String cmd = "";
        StringBuffer sb = new StringBuffer();
        sb.append("\"");
        sb.append(this.installPath);
        sb.append(WINDOWS_RESTORE);
        sb.append("\"");
        sb.append(" -h" + this.host);
        sb.append(" -U" + this.userName);
        sb.append(" -W" + this.userPass);
        sb.append(" -p " + this.port);
        sb.append(" -d " + this.dbName);
        sb.append(" -f " + sqlFile);
        cmd = sb.toString();
        try {
            logger.info((Object)"start restore db, Please wait a moment. ", "");
            Printer.println("Start restore db, Please wait a moment. ");
            Process process = Runtime.getRuntime().exec(cmd);
            InputStreamReader input = new InputStreamReader(process.getInputStream(), "utf8");
            BufferedReader inputBr = new BufferedReader(input);
            String inputLogPath = this.installPath + "/bin/logs/importDBInput.log";
            ErrHandleTask inputTask = new ErrHandleTask(inputBr, inputLogPath);
            InputStreamReader err = new InputStreamReader(process.getErrorStream(), "utf8");
            BufferedReader errBr = new BufferedReader(err);
            String errLogPath = this.installPath + "/bin/logs/importDBErr.log";
            ErrHandleTask errTask = new ErrHandleTask(errBr, errLogPath);
            Thread inputT = new Thread(inputTask);
            Thread errT = new Thread(errTask);
            inputT.start();
            errT.start();
            process.waitFor();
            logger.info((Object)"restore successfully. Please restart the Server.", "");
            Printer.println("Restore successfully. Please restart the Server.");
        }
        catch (Exception e) {
            logger.error((Object)("loadWindows error: " + ExceptionUtil.getErrorMessage(e)), "");
            Printer.println("LoadWindows error.");
        }
    }

    private void loadLinux(String sqlFile) {
        String cmd = "";
        StringBuffer path = new StringBuffer();
        StringBuffer param = new StringBuffer();
        path.append(LINUX_RESTORE);
        param.append(" -h" + this.host);
        param.append(" -U" + this.userName);
        param.append(" -W").append("'").append(this.userPass).append("'");
        param.append(" -p " + this.port);
        param.append(" " + this.dbName + " <");
        param.append(" " + sqlFile.replace(" ", "\" \""));
        cmd = path.toString();
        try {
            CmdUtil.runShell(cmd, new String[]{param.toString()});
        }
        catch (Exception e) {
            logger.error((Object)("loadLinux error: " + ExceptionUtil.getErrorMessage(e)), "");
            Printer.println("LoadLinux error.");
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            String fileLoc = args[0];
            GaussDBrestoreImpl msdi = new GaussDBrestoreImpl();
            if (!msdi.checkSystemRuning()) {
                return;
            }
            File file = new File(fileLoc);
            if (!file.exists()) {
                Printer.println("File is not exists.");
                return;
            }
            if (args.length > 1 && "TRUE".equals(args[1])) {
                char[] password = System.console().readPassword("Please input old encrypt password:", new Object[0]);
                msdi.encryptPassword = password != null ? new String(password) : null;
            }
            msdi.importDB(file);
        }
    }

    private Boolean clearDB(Connection gaussDBConn) {
        String dropScript = "DROP DATABASE if exists " + this.dbName + ";";
        String createScript = "CREATE DATABASE " + this.dbName + " WITH TEMPLATE = TEMPLATE0 ENCODING 'UTF8';";
        String ownerScript = "ALTER DATABASE " + this.dbName + " OWNER TO " + this.userName;
        String connLimit = "ALTER DATABASE " + this.dbName + " CONNECTION LIMIT=100;";
        ArrayList<String> scripts = new ArrayList<String>();
        scripts.add(dropScript);
        scripts.add(createScript);
        scripts.add(ownerScript);
        scripts.add(connLimit);
        return this.runScripts(scripts, gaussDBConn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runScripts(List<String> sqlScripts, Connection gaussDBConn) {
        Statement stmt = null;
        int size = sqlScripts.size();
        Printer.println("Start to clear the database.");
        try {
            logger.error((Object)"chmod++++++++++++++++++++++", "");
            stmt = gaussDBConn.createStatement();
            for (int index = 0; index < size; ++index) {
                String sql = sqlScripts.get(index);
                stmt.execute(sql);
            }
            Printer.println("Clear the database successfully!");
            boolean sql = true;
            return sql;
        }
        catch (Exception e) {
            logger.error((Object)("create statement failed.run sql failed:" + ExceptionUtil.getErrorMessage(e)), "");
            Printer.println("Fail to clear the database");
            boolean bl = false;
            return bl;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("create statement close failed: " + ExceptionUtil.getErrorMessage(e)));
                }
            }
        }
    }
}

