/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.configbackup;

import com.huawei.ism.drm.configbackup.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import com.huawei.util.CommonUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class ZipUtil {
    private static final ZipUtil instance = new ZipUtil();
    private static final Log logger = LogFactory.getInstance(ZipUtil.class);

    private ZipUtil() {
    }

    public static ZipUtil getInstance() {
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File unzipFile(String directory, File zipFile) throws Exception {
        String name = "";
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));){
            File parent = new File(directory);
            if (!parent.exists() && !parent.mkdirs()) {
                throw new Exception("create the dir \"" + parent.getName() + "\" failed.");
            }
            ZipEntry ze = zis.getNextEntry();
            if (ze == null) {
                File file = new File(directory + File.separator + name);
                return file;
            }
            byte[] buffer = new byte[10240];
            while (ze != null) {
                name = ze.getName();
                FileOutputStream output = new FileOutputStream(new File(parent, name));
                int bytesRead = zis.read(buffer);
                while (bytesRead > 0) {
                    output.write(buffer, 0, bytesRead);
                    bytesRead = zis.read(buffer);
                }
                output.flush();
                output.close();
                ze = zis.getNextEntry();
            }
            return new File(directory + File.separator + name);
        }
        catch (Exception e) {
            logger.error((Object)("Unzip file failed." + ExceptionUtil.getErrorMessage(e)));
            throw e;
        }
    }

    public static String getInstallPath() throws DocumentException, SAXException {
        String installFile = "RDInstalled.xml";
        SAXReader sax = new SAXReader();
        try {
            CommonUtil.setSecurityFeatures((SAXReader)sax);
            Document document = sax.read(new File(installFile));
            Element installElement = (Element)document.selectSingleNode("/install/installpath");
            String installPathStr = installElement.attribute("path").getValue();
            return installPathStr;
        }
        catch (DocumentException | SAXException e) {
            logger.error((Object)"Get install path failed.", "");
            throw e;
        }
    }
}

