/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.monitor.alarm;

import com.huawei.ism.cbb.base.util.AlarmUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import com.huawei.lego.nem.fault.sdk.service.IFaultGenerateService;
import java.util.Locale;

public class AlarmGenerator {
    private static final Log logger = LogFactory.getInstance(AlarmGenerator.class);

    private AlarmGenerator() {
    }

    public static String generateAlarmId(long alarmID) {
        String alarmId = "0x" + Long.toHexString(alarmID).toUpperCase(Locale.US);
        return alarmId;
    }

    private static void sendAlarm(TopoObject to, String sourceId, String sourceType, long alarmID, FaultEnum.AlarmSeverity alarmLevel, String ... alarmParams) {
        IFaultGenerateService alarmService = AlarmGenerator.getAlarmService();
        if (VerifyUtil.isEmpty((Object)alarmService)) {
            logger.error((Object)"alarmService is null", 90160758787071L);
            return;
        }
        LegoAlarm alarm = new LegoAlarm();
        long moID = to.getMoId();
        String alarmId = AlarmGenerator.generateAlarmId(alarmID);
        String id = moID + alarmId + to.getUuid();
        LegoAlarm oldAlarm = AlarmUtil.getAlarm((String)id);
        if (null != oldAlarm && oldAlarm.getClearStatus() == FaultEnum.ClearState.UNCLEARED) {
            logger.info((Object)("The alarm has been existed, There is no need to send," + id), 90160758786816L);
            return;
        }
        logger.info((Object)("Send alarm! the entity of the alarm is " + id), 90160758786816L);
        alarm.setMoId(moID);
        alarm.setMoIP(to.getIpAddress());
        alarm.setMoName(to.getName());
        alarm.setMoUuid(to.getUuid());
        alarm.setEntity(moID + alarmId);
        alarm.setAlarmId(alarmId);
        alarm.setAlarmLevel(alarmLevel);
        alarm.setAlarmParam(alarmParams);
        alarm.setAlarmTime(System.currentTimeMillis());
        alarm.setClearStatus(FaultEnum.ClearState.UNCLEARED);
        alarm.setSourceId(sourceId);
        alarm.setSourceType(sourceType);
        try {
            boolean isSuccessed = alarmService.generateLegoAlarm(alarm);
            if (!isSuccessed) {
                logger.error((Object)"Generate fault alarm failed.see lego logs", 90160758787071L);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Generate fault alarm failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
    }

    private static void restoreAlarm(TopoObject to, long alarmID, String ... alramParams) {
        String alarmId = AlarmGenerator.generateAlarmId(alarmID);
        long moID = to.getMoId();
        String id = moID + alarmId + alramParams[0];
        LegoAlarm oldAlarm = AlarmUtil.getAlarm((String)id);
        IFaultGenerateService alarmService = AlarmGenerator.getAlarmService();
        if (VerifyUtil.isEmpty((Object)alarmService)) {
            logger.error((Object)"AlarmService is null", 90160758787071L);
            return;
        }
        if (null != oldAlarm && oldAlarm.getClearStatus().equals((Object)FaultEnum.ClearState.UNCLEARED)) {
            oldAlarm.setClearStatus(FaultEnum.ClearState.CLEARED);
            oldAlarm.setClearTime(System.currentTimeMillis());
            oldAlarm.setClearUser("system");
            try {
                oldAlarm.setFaultDefine(null);
                boolean isSuccessed = alarmService.generateRestoreAlarm(oldAlarm);
                if (!isSuccessed) {
                    logger.error((Object)"restore fault alarm failed.see lego logs", 90160758787071L);
                }
            }
            catch (LegoCheckedException e) {
                logger.error((Object)"Generate fault alarm failed", (Throwable)e, 90160758787071L);
            }
        }
    }

    public static void generatePGIsInvalidAlarm(TopoObject to, String pgId, String pgName, String vrmID) {
        if (!(VerifyUtil.isEmpty((Object)to) || VerifyUtil.isEmpty((String)pgId) || VerifyUtil.isEmpty((String)pgName))) {
            AlarmGenerator.sendAlarm(to, pgId, FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), 52625421L, FaultEnum.AlarmSeverity.CRITICAL, pgId, pgName, vrmID);
        }
    }

    public static void restorePGIsInvalidAlarm(TopoObject to, String pgID) {
        if (!VerifyUtil.isEmpty((Object)to) && !VerifyUtil.isEmpty((String)pgID)) {
            AlarmGenerator.restoreAlarm(to, 52625421L, pgID);
        }
    }

    public static void generateVMIsDeletedOrMovedAlarm(TopoObject to, String vmUuid, ProtectGroup pg, String poName, String vrmID) {
        if (!(VerifyUtil.isEmpty((Object)to) || VerifyUtil.isEmpty((String)vmUuid) || VerifyUtil.isEmpty((String)poName) || VerifyUtil.isEmpty((String)pg.getName()))) {
            AlarmGenerator.sendAlarm(to, pg.getUuid(), FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), 52625422L, FaultEnum.AlarmSeverity.CRITICAL, vmUuid, pg.getName(), poName, vrmID);
        }
    }

    public static void restoreVMIsDeletedOrMovedAlarm(TopoObject to, String vmUuid) {
        if (!VerifyUtil.isEmpty((Object)to) && !VerifyUtil.isEmpty((String)vmUuid)) {
            AlarmGenerator.restoreAlarm(to, 52625422L, vmUuid);
        }
    }

    public static void generateVMHasNotBeenProtectedAlarm(TopoObject to, String vmUuid, String poName, ProtectGroup pg, String pgId) {
        if (!(VerifyUtil.isEmpty((Object)to) || VerifyUtil.isEmpty((String)vmUuid) || VerifyUtil.isEmpty((String)poName) || VerifyUtil.isEmpty((String)pg.getName()))) {
            AlarmGenerator.sendAlarm(to, pg.getUuid(), FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), 0x3230023L, FaultEnum.AlarmSeverity.CRITICAL, vmUuid, poName, pg.getName(), pgId);
        }
    }

    public static void restoreVMHasNotBeenProtectedAlarm(TopoObject to, String vmUuid) {
        if (!VerifyUtil.isEmpty((Object)to) && !VerifyUtil.isEmpty((String)vmUuid)) {
            AlarmGenerator.restoreAlarm(to, 0x3230023L, vmUuid);
        }
    }

    public static IFaultGenerateService getAlarmService() {
        ServiceContext context = ServiceContext.getInstance();
        IFaultGenerateService service = (IFaultGenerateService)context.lookup("fault/faultGenerateService");
        return service;
    }
}

