/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.monitor.alarm;

import com.huawei.ism.cbb.base.util.AlarmUtil;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.drm.galax.constant.cloudenum.ObserverManagerEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.PgTypeEnum;
import com.huawei.ism.drm.galax.monitor.alarm.AlarmGenerator;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.model.PgAlarmInfo;
import com.huawei.ism.drm.galax.sdk.model.VRM;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.virtualization.observer.ObserverManager;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.base.structure.AbsApplication;
import com.huawei.lego.core.sdk.base.structure.ISystem;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import com.huawei.lego.nem.fault.sdk.service.IAlarmService;
import com.huawei.lego.nem.fault.sdk.service.IFaultGenerateService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;

public class TrapAlarmObserver
implements Observer {
    private static final Log logger = LogFactory.getInstance(TrapAlarmObserver.class);
    private AbsApplication galaxBaseApp;
    private List<LegoAlarm> allLegoAlram;

    public TrapAlarmObserver() {
        ObserverManager.getInstance((String)ObserverManagerEnum.MAINTION_GROUP_MANAGER.name()).addObserver((Observer)this);
    }

    public void setGalaxBaseApp(AbsApplication galaxBaseApp) {
        this.galaxBaseApp = galaxBaseApp;
    }

    @Override
    public void update(Observable paramObservable, Object paramObject) {
        ISystem container;
        logger.info((Object)"Start to maintion alarms after update protect object properties", 90160758786816L);
        AbstractContext context = (AbstractContext)paramObject;
        ArrayList listAlarmModel = (ArrayList)context.getAttribute("maintainExchangedPgs");
        if (VerifyUtil.isEmpty((Collection)listAlarmModel)) {
            logger.info((Object)"There is no update object in the listAlarmModel,", 90160758786816L);
            listAlarmModel = new ArrayList();
        }
        if (null == (container = this.galaxBaseApp.getContainer())) {
            logger.error((Object)"Container is null.");
            return;
        }
        Long sysMoId = container.getSystemMO().getMoId();
        IAlarmService alarmService = (IAlarmService)ServiceContext.getInstance().lookup("fault/alarmService");
        if (VerifyUtil.isEmpty((Object)alarmService)) {
            logger.warn((Object)"AlarmService is null,", 90160758786816L);
            return;
        }
        this.allLegoAlram = alarmService.getAlarmList(sysMoId.longValue());
        logger.info((Object)("The count of the alarm in the table is " + this.allLegoAlram.size()), 90160758786816L);
        VRM vrm = (VRM)context.getAttribute("DRMVRM");
        if (null == vrm) {
            logger.warn((Object)"Vrm is null,", 90160758786816L);
            return;
        }
        String vrmID = this.generateVrmId(vrm.getMoId());
        logger.info((Object)("VrmID and moID are " + vrmID + " " + sysMoId), 90160758786816L);
        String ip = vrm.getIpAddress();
        HashMap<String, String> pgExceptionMap = new HashMap<String, String>();
        for (PgAlarmInfo pgAlarmInfo : listAlarmModel) {
            logger.info((Object)("The pgAlarmInfo  is " + pgAlarmInfo.toString()), 90160758786816L);
            ProtectGroup pg = pgAlarmInfo.getPg();
            if (!pgAlarmInfo.isConnected()) {
                pgExceptionMap.put(pg.getUuid(), null);
                continue;
            }
            this.processPgStatus(sysMoId, vrmID, ip, pgAlarmInfo);
            this.processValidVm(sysMoId, ip, pgAlarmInfo.getListVmValid());
            String pgType = pgAlarmInfo.getType();
            if (pgType.equals(PgTypeEnum.PG_INVILID.toString())) continue;
            ArrayList<ProtectObject> deleteList = new ArrayList<ProtectObject>(pgAlarmInfo.getListDelete());
            deleteList.addAll(pgAlarmInfo.getLeftMovedPoVm());
            this.processDeleteOrMovedAlarm(sysMoId, vrmID, ip, deleteList, pg);
            this.processHasNotProtectAlarm(sysMoId, ip, pgAlarmInfo.getListCannotBeProtectedVm(), pg);
        }
        logger.info((Object)"Start to process rest alarms,", 90160758786816L);
        this.processRestAlarm(vrmID, pgExceptionMap);
    }

    private String generateVrmId(long vrmMoId) {
        String vrmID = "S" + vrmMoId + "S";
        return vrmID;
    }

    private void processPgStatus(Long moID, String vrmID, String ip, PgAlarmInfo pgAlarmInfo) {
        ProtectGroup pg = pgAlarmInfo.getPg();
        String pgID = pg.getUuid();
        String pgName = pg.getName();
        this.reducePgAlarmFromList(moID, pgID);
        TopoObject to = new TopoObject();
        to.setMoId(moID);
        to.setName(pgName);
        to.setUuid(pgID);
        to.setIpAddress(ip);
        String pgType = pgAlarmInfo.getType();
        if (pgType.equals(PgTypeEnum.PG_INVILID.toString())) {
            AlarmGenerator.generatePGIsInvalidAlarm(to, pgID, pgName, vrmID);
        } else {
            AlarmGenerator.restorePGIsInvalidAlarm(to, pgID);
        }
    }

    private void processValidVm(Long moID, String ip, List<GalaxVM> vmValidList) {
        for (GalaxVM galaxVm : vmValidList) {
            String moUuid = galaxVm.getUuid();
            String poName = galaxVm.getName();
            TopoObject to = new TopoObject();
            to.setMoId(moID);
            to.setName(poName);
            to.setUuid(moUuid);
            to.setIpAddress(ip);
            AlarmGenerator.restoreVMHasNotBeenProtectedAlarm(to, moUuid);
        }
    }

    private void processDeleteOrMovedAlarm(Long moID, String vrmID, String ip, List<ProtectObject> deleteList, ProtectGroup pg) {
        for (ProtectObject po : deleteList) {
            String moUuid = vrmID + po.getMoUuid();
            String poName = po.getName();
            TopoObject to = new TopoObject();
            to.setMoId(moID);
            to.setName(poName);
            to.setUuid(moUuid);
            to.setIpAddress(ip);
            AlarmGenerator.restoreVMHasNotBeenProtectedAlarm(to, po.getMoUuid());
            String pgMoUuid = pg.getUuid() + moUuid;
            to.setUuid(pgMoUuid);
            AlarmGenerator.generateVMIsDeletedOrMovedAlarm(to, pgMoUuid, pg, poName, vrmID);
        }
    }

    private void processHasNotProtectAlarm(Long moID, String ip, List<GalaxVM> vmList, ProtectGroup pg) {
        for (GalaxVM galaxVm : vmList) {
            String moUuid = galaxVm.getUuid();
            String poName = galaxVm.getName();
            TopoObject to = new TopoObject();
            to.setMoId(moID);
            to.setName(poName);
            to.setUuid(moUuid);
            to.setIpAddress(ip);
            AlarmGenerator.generateVMHasNotBeenProtectedAlarm(to, moUuid, poName, pg, pg.getUuid());
        }
    }

    private String generateAlarmId(String moId, String alarmId, String uuid) {
        String result = moId + alarmId + uuid;
        return result;
    }

    private void processRestAlarm(String vrmMoId, Map<String, String> pgExceptionMap) {
        if (vrmMoId.isEmpty()) {
            logger.info((Object)"The vrmMoId is null while process the rest alarms,", 90160758786816L);
            return;
        }
        List pgList = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByType(12, Long.valueOf(1L));
        for (LegoAlarm alarm : this.allLegoAlram) {
            if (!this.isAlarmSendedByVrm(alarm, vrmMoId)) {
                logger.info((Object)("The alarm is not in vrm:" + vrmMoId + " " + Arrays.toString(alarm.getAlarmParam())), 90160758786816L);
                continue;
            }
            if (this.isAlarmSendedByExceptioPg(alarm, pgExceptionMap)) {
                logger.info((Object)("Pg has exception, the alarm (" + alarm.getAlarmId() + ") will not be cleared."), 90160758786816L);
                continue;
            }
            String alarmID = alarm.getAlarmId();
            logger.info((Object)("The alarm will be restored is: " + Arrays.toString(alarm.getAlarmParam())), 90160758786816L);
            if (null != alarmID && alarmID.equals(AlarmGenerator.generateAlarmId(52625421L))) {
                this.processRestPGAlarm(pgList, alarm);
                continue;
            }
            if (null == alarmID || !alarmID.equals(AlarmGenerator.generateAlarmId(0x3230023L)) && !alarmID.equals(AlarmGenerator.generateAlarmId(52625422L))) continue;
            this.processRestPOAlarm(pgList, alarm);
        }
    }

    private boolean isAlarmSendedByVrm(LegoAlarm alarm, String vrmMoId) {
        Object[] params = alarm.getAlarmParam();
        if (VerifyUtil.isEmpty((Object[])params)) {
            return false;
        }
        for (Object param : params) {
            if (!((String)param).equals(vrmMoId)) continue;
            return true;
        }
        return false;
    }

    private boolean isAlarmSendedByExceptioPg(LegoAlarm alarm, Map<String, String> pgExceptionMap) {
        Object[] params = alarm.getAlarmParam();
        if (VerifyUtil.isEmpty((Object[])params)) {
            return false;
        }
        ArrayList<String> listPgs = new ArrayList<String>(pgExceptionMap.keySet());
        if (VerifyUtil.isEmpty(listPgs)) {
            return false;
        }
        for (Object param : params) {
            for (String pgId : listPgs) {
                if (!((String)param).contains(pgId)) continue;
                return true;
            }
        }
        return false;
    }

    private void processRestPOAlarm(List<ProtectGroup> pgList, LegoAlarm alarm) {
        String vmUuid = alarm.getAlarmParam()[0];
        if (alarm.getAlarmId().equals(AlarmGenerator.generateAlarmId(52625422L)) && this.pgIsExist(vmUuid, pgList)) {
            logger.info((Object)"The alarm is delete/moved alarm and the pg is exist in process po alarm,", 90160758786816L);
            return;
        }
        this.restoreAlarmBaseAlarm(alarm);
    }

    private void processRestPGAlarm(List<ProtectGroup> pgList, LegoAlarm alarm) {
        String vrmPgID = alarm.getAlarmParam()[0];
        logger.info((Object)("In the processRestPGAlarm the vrmPgID is " + vrmPgID), 90160758786816L);
        if (!this.pgIsExist(vrmPgID, pgList)) {
            this.restoreAlarmBaseAlarm(alarm);
        }
    }

    private boolean pgIsExist(String vrmPgId, List<ProtectGroup> pgList) {
        for (ProtectGroup pg : pgList) {
            if (!vrmPgId.contains(pg.getUuid())) continue;
            logger.info((Object)("The pg is exist," + vrmPgId + " " + pg.getUuid()), 90160758786816L);
            return true;
        }
        return false;
    }

    private void restoreAlarmBaseAlarm(LegoAlarm alarm) {
        IFaultGenerateService alarmService = AlarmGenerator.getAlarmService();
        if (VerifyUtil.isEmpty((Object)alarmService)) {
            logger.error((Object)"AlarmService is null,", 90160758787071L);
            return;
        }
        if (null != alarm && alarm.getClearStatus().equals((Object)FaultEnum.ClearState.UNCLEARED)) {
            alarm.setClearStatus(FaultEnum.ClearState.CLEARED);
            alarm.setClearTime(System.currentTimeMillis());
            alarm.setClearUser("system");
            try {
                alarm.setFaultDefine(null);
                boolean isSuccessed = alarmService.generateRestoreAlarm(alarm);
                if (!isSuccessed) {
                    logger.error((Object)"Restore fault alarm failed.see lego logs", 90160758787071L);
                }
            }
            catch (LegoCheckedException e) {
                logger.error((Object)"Generate fault alarm failed", (Throwable)e, 90160758787071L);
            }
        }
    }

    private void reducePgAlarmFromList(Long moID, String pgId) {
        String alarmId = AlarmGenerator.generateAlarmId(52625421L);
        String id = this.generateAlarmId(String.valueOf(moID), alarmId, pgId);
        this.reduceAlarm(id);
    }

    private void reduceAlarm(String id) {
        LegoAlarm alarm = AlarmUtil.getAlarm((String)id);
        if (VerifyUtil.isEmpty((Object)alarm)) {
            return;
        }
        Iterator<LegoAlarm> it = this.allLegoAlram.iterator();
        String entity = alarm.getEntity();
        while (it.hasNext()) {
            if (!it.next().getEntity().equals(entity)) continue;
            it.remove();
            break;
        }
    }
}

