/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.protection.calculator;

import com.huawei.ism.drm.galax.constant.cloudenum.PoExParamsEnum;
import com.huawei.ism.drm.protection.calculator.BaseRecoveryPointObjectiveCalculator;
import com.huawei.ism.drm.protection.calculator.sdk.model.RPOContext;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.virtualization.util.VirtualizationCommonUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GalaxRecoveryPointObjectiveCalculator
extends BaseRecoveryPointObjectiveCalculator {
    private static final String RPO_STATUS_1 = "1";
    private static final String RPO_STATUS_2 = "2";
    private static final String CONFIG_RPO_OK = "0";

    public List<String> getTypes() {
        return new ArrayList<String>(Arrays.asList(String.valueOf(11)));
    }

    protected Map<String, Object> calcConfiguredRPO(RPOContext context) {
        HashMap<String, Object> galaxRPO = new HashMap<String, Object>();
        Object object = context.getObject("PG_ENTITY");
        if (object == null) {
            return null;
        }
        ProtectGroup protectGroup = (ProtectGroup)object;
        String recoverySiteId = ((ProtectGroupReplica)VirtualizationCommonUtil.getInstance().getElementFromCollection((Collection)protectGroup.getReplicaList())).getRecoverySite();
        galaxRPO.put(recoverySiteId, CONFIG_RPO_OK);
        return galaxRPO;
    }

    protected Map<String, Object> calcActualRPO(RPOContext context) {
        HashMap<String, Object> galaxRPO = new HashMap<String, Object>();
        Object object = context.getObject("PG_ENTITY");
        if (object == null) {
            return null;
        }
        ProtectGroup protectGroup = (ProtectGroup)object;
        String recoverySiteId = ((ProtectGroupReplica)VirtualizationCommonUtil.getInstance().getElementFromCollection((Collection)protectGroup.getReplicaList())).getRecoverySite();
        Set galaxPoList = protectGroup.getPolist();
        if (VerifyUtil.isEmpty((Collection)galaxPoList)) {
            galaxRPO.put(recoverySiteId, -2);
            return galaxRPO;
        }
        int notOkNum = 0;
        int unknownNum = 0;
        for (ProtectObject galaxPo : galaxPoList) {
            String poStatus = (String)galaxPo.getProps().get(PoExParamsEnum.VM_RPO_STATUS.getValue());
            if (RPO_STATUS_2.equals(poStatus)) {
                ++notOkNum;
                continue;
            }
            if (RPO_STATUS_1.equals(poStatus)) continue;
            ++unknownNum;
        }
        this.getRealRPO(notOkNum, unknownNum, recoverySiteId, galaxRPO, protectGroup);
        return galaxRPO;
    }

    private void getRealRPO(int notOkNum, int unknownNum, String recoverySiteId, Map<String, Object> galaxRPO, ProtectGroup pg) {
        if (notOkNum > 0) {
            galaxRPO.put(recoverySiteId, -3);
        } else if (unknownNum > 0) {
            galaxRPO.put(recoverySiteId, -2);
        } else {
            galaxRPO.put(recoverySiteId, -4);
        }
        Set rps = pg.getReplicaList();
        if (VerifyUtil.isEmpty((Collection)rps)) {
            return;
        }
        for (ProtectGroupReplica rp : rps) {
            if (3 != rp.getStatus()) continue;
            galaxRPO.put(recoverySiteId, -3);
            break;
        }
    }
}

