/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.recovery.common;

import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.galax.constant.cloudenum.PoExParamsEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.VmStatusEnum;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ProtectObjectUtils {
    private static final Log logger = LogFactory.getInstance(ProtectObjectUtils.class);

    private ProtectObjectUtils() {
    }

    public static int getPOCountInRecoveryPlan(RecoveryPlan rp) {
        int count = 0;
        Set pgSet = rp.getProtectGroups();
        Iterator pgIterator = pgSet.iterator();
        while (pgIterator.hasNext()) {
            count += ((ProtectGroup)pgIterator.next()).getPoCount();
        }
        return count;
    }

    public static ProtectObject getProtectObjectInRecoveryPlan(RecoveryPlan plan, String poId) {
        Set pgSet = plan.getProtectGroups();
        for (ProtectGroup pg : pgSet) {
            Set pos = pg.getPolist();
            for (ProtectObject po : pos) {
                if (!po.getUuid().equals(poId)) continue;
                return po;
            }
        }
        return null;
    }

    public static void generateVmBaseInfo(List<GalaxVM> vms, ProtectObject po, String providerSn) {
        if (null == po) {
            logger.error((Object)"po is null");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty(vms)) {
            return;
        }
        boolean vmNotExisted = true;
        for (GalaxVM vm : vms) {
            if (!vm.getUuid().equals(po.getMoUuid())) continue;
            vmNotExisted = false;
            po.setMoUuid(vm.getUuid());
            po.setName(vm.getName());
            po.setPoType(12);
            po.setProviderSN(providerSn);
            HashMap<String, String> props = po.getProps();
            if (props == null) {
                props = new HashMap<String, String>();
            }
            String vmId = vm.getUri().split("vms")[1].replace("/", "");
            props.put(PoExParamsEnum.VM_ID.getValue(), vmId);
            props.put(PoExParamsEnum.VM_OS_TYPE.getValue(), vm.getOsType());
            VmStatusEnum statusEnum = VmStatusEnum.findStatusByKey((int)vm.getStatus());
            props.put("VMSTATUS", null == statusEnum ? VmStatusEnum.UNKNOWN.getValue() : statusEnum.getValue());
            po.setProps(props);
            break;
        }
        if (vmNotExisted) {
            logger.error((Object)"vm is not existed.");
            throw new LegoCheckedException(1073947394L);
        }
    }
}

