/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.recovery.process.processtask;

import com.huawei.ism.drm.galax.recovery.process.command.ICmdResponseParser;
import com.huawei.ism.drm.galax.recovery.process.command.IRecoveryCommand;
import com.huawei.ism.drm.galax.sdk.model.CloudPlatformResponse;
import com.huawei.ism.drm.galax.util.common.task.IExecuteTask;
import com.huawei.ism.drm.galax.util.common.task.constants.TaskExecuteStatus;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class RecoveryProcessTask
implements IExecuteTask {
    private static final Log logger = LogFactory.getInstance(RecoveryProcessTask.class);
    private String flag;
    private IRecoveryCommand excuteCmd;
    private IRecoveryCommand queryCmd;
    private ICmdResponseParser parser;
    private long period;

    public RecoveryProcessTask(String flag, IRecoveryCommand excuteCmd, IRecoveryCommand queryCmd, ICmdResponseParser parser) {
        this.flag = flag;
        this.excuteCmd = excuteCmd;
        this.queryCmd = queryCmd;
        this.period = 2L;
        this.parser = parser;
    }

    public void setParser(ICmdResponseParser parser) {
        this.parser = parser;
    }

    public Object excuteCommand() {
        try {
            if (null == this.excuteCmd) {
                return new CloudPlatformResponse(null, null);
            }
            CloudPlatformResponse response = this.excuteCmd.excute(new Object[0]);
            if (!this.parser.parser(response)) {
                this.checkQueryCmd();
                return response;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Failed to execute cmd." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            this.parser.paserException(e);
        }
        return null;
    }

    private void checkQueryCmd() {
        if (null == this.queryCmd) {
            this.period = 0L;
        }
    }

    public TaskExecuteStatus handleCmdResult(Object cmdResponse) {
        if (null == this.excuteCmd && null != this.queryCmd) {
            CloudPlatformResponse response = this.queryCmd.excute(new Object[0]);
            if (null != response) {
                return TaskExecuteStatus.success;
            }
            return TaskExecuteStatus.running;
        }
        if (null == cmdResponse || !(cmdResponse instanceof CloudPlatformResponse) || this.period <= 0L) {
            return TaskExecuteStatus.success;
        }
        CloudPlatformResponse response = (CloudPlatformResponse)cmdResponse;
        try {
            if (null == this.queryCmd) {
                logger.error((Object)"queryCmd is null.", 90160758787071L);
                return TaskExecuteStatus.failed;
            }
            if (this.parser.parser(this.queryCmd.excute(response.getTaskKey()))) {
                return TaskExecuteStatus.success;
            }
            return TaskExecuteStatus.running;
        }
        catch (Exception e) {
            logger.error((Object)("Failed to excute query result cmd." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            this.parser.paserException(e);
            return TaskExecuteStatus.failed;
        }
    }

    public long getInitialDelay() {
        return 0L;
    }

    public long getPeriod() {
        return this.period;
    }

    public String getTaskFlag() {
        return this.flag;
    }

    public IRecoveryCommand getExcuteCmd() {
        return this.excuteCmd;
    }
}

