/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.recovery.provider;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.galax.protection.adapter.GalaxProtectObjectCloudProviderAdapter;
import com.huawei.ism.drm.galax.recovery.process.GalaxExecuteScriptProcessor;
import com.huawei.ism.drm.galax.recovery.service.IRecoveryProcessorService;
import com.huawei.ism.drm.galax.sdk.pg.service.IGalaxProtectObjectCloudProvider;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.framework.provider.BaseRecoveryProcessProvider;
import com.huawei.ism.drm.virtualization.util.VirtualizationCommonUtil;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VmRecoveryProcessProvider
extends BaseRecoveryProcessProvider {
    private Log logger = LogFactory.getInstance(VmRecoveryProcessProvider.class);
    private String trace = "trace";
    private IRecoveryProcessorService recoveryProcessorService;

    public void setRecoveryProcessorService(IRecoveryProcessorService recoveryProcessorService) {
        this.logger.trace((Object)"setRecoveryProcessorService");
        this.recoveryProcessorService = recoveryProcessorService;
    }

    public List<String> getAppType() {
        this.logger.trace((Object)(this.trace + " trace message"));
        ArrayList<String> appTypes = new ArrayList<String>();
        appTypes.add(DrmEnumDefine.APP_TYPE.GALAX_VM.name());
        return appTypes;
    }

    public void resetRecoveryProcessDefinition(RecoveryPlan recoveryPlan, RecoveryProcessDefinition rpDefinition, boolean isNeedSaveToDb) {
        List<Class<? extends RecoveryProcessor>> procClsList;
        this.logger.trace((Object)(this.trace + " trace message"));
        if (null == recoveryPlan || null == rpDefinition) {
            this.logger.error((Object)"recovery plan or rpDefinition is null.");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup pg = recoveryPlan.getProtectGroup();
        List<Integer> openStackArrayReplica = Arrays.asList(21, 22, 34, 37);
        if (12 == pg.getPoType() && openStackArrayReplica.contains(pg.getTemplate().getType()) && !VerifyUtil.isEmpty(procClsList = this.recoveryProcessorService.getUnusedRecoveryProcessor(recoveryPlan, rpDefinition.getProcType()))) {
            this.logger.debug((Object)("Reset Recovery process definition, type: " + rpDefinition.getProcType() + ", size: " + procClsList.size()));
            this.deleteRecoveryProcessors(rpDefinition, procClsList, isNeedSaveToDb);
        }
    }

    public boolean isSuitableProtectGroup(DrmEnumDefine.RECOVERY_PLAN_TYPE_E planType, ProtectGroup protectGroup) {
        this.logger.trace((Object)(this.trace + " trace message"));
        boolean isSuitable = super.isSuitableProtectGroup(planType, protectGroup);
        if (isSuitable) {
            return isSuitable;
        }
        Integer policyTemplateType = protectGroup.getTemplate().getType();
        return DrmEnumDefine.RECOVERY_PLAN_TYPE_E.REMOTE == planType && policyTemplateType == 11;
    }

    public Map<String, Object> getCustomRecoveryProcessorInfos(RecoveryProcessDefinition rpDef, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType, String procId) {
        this.logger.trace((Object)(this.trace + " trace message"));
        if (null == rpDef || VerifyUtil.isEmpty((String)procId) || null == procType) {
            this.logger.error((Object)"params error, reDef\u3001procId or procType is null");
            throw new LegoCheckedException(1073947393L);
        }
        this.logger.debug((Object)"Does not support by openstackvm.");
        return null;
    }

    public String addCustomRecoveryProcessor(RecoveryProcessDefinition rpDefinition, Class<? extends RecoveryProcessor> afterProcCls, Map<String, Object> params, boolean isEnable, boolean isNeedUpdateDb) {
        this.logger.trace((Object)(this.trace + " trace message"));
        this.logger.debug((Object)"Does not support by openstackvm.");
        return null;
    }

    public String addCustomRecoveryProcessor(RecoveryProcessDefinition rpDefinition, RecoveryProcessor afterProcessor, Map<String, Object> params, boolean isEnable, boolean isNeedUpdateDb) {
        this.logger.trace((Object)(this.trace + " trace message"));
        this.logger.debug((Object)"Does not support by openstackvm.");
        return null;
    }

    public void modifyCustomRecoveryProcessor(RecoveryProcessDefinition recoveryProcessDefinition, String procId, Map<String, Object> params) {
        this.logger.trace((Object)(this.trace + " trace message"));
        if (null == recoveryProcessDefinition || VerifyUtil.isEmpty((String)procId) || VerifyUtil.isEmpty(params)) {
            this.logger.error((Object)"params error, recoveryProcessDefinition\u3001procId or params is null");
            throw new LegoCheckedException(1073947393L);
        }
        this.logger.debug((Object)"dont support by openstackvm.");
    }

    public Class<? extends RecoveryProcessor> getCustomRecoveryProcessorClass() {
        this.logger.trace((Object)(this.trace + " trace message"));
        return GalaxExecuteScriptProcessor.class;
    }

    public Map<String, Object> checkRecoveryContext(String planId, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType, Map<String, String> recoveryContext, User operator) {
        IGalaxProtectObjectCloudProvider provider;
        this.logger.trace((Object)(this.trace + " trace message"));
        if (null == recoveryContext || null == procType || null == planId) {
            this.logger.error((Object)"param is null", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan recoveryPlan = ((IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class)).getRecoveryPlan(planId);
        if (null == recoveryPlan) {
            this.logger.error((Object)"failed to get recoveryPlan.", 90160758784001L);
            throw new LegoCheckedException(201L);
        }
        ProtectGroup pg = (ProtectGroup)recoveryPlan.getProtectGroups().iterator().next();
        Set pgrSet = pg.getReplicaList();
        ProtectGroupReplica pgr = (ProtectGroupReplica)pgrSet.iterator().next();
        String reySite = pgr.getRecoverySite();
        if (!VerifyUtil.isEmpty((String)recoveryContext.get("DISASTER_SITE_ID"))) {
            reySite = recoveryContext.get("DISASTER_SITE_ID");
        }
        if ((provider = GalaxProtectObjectCloudProviderAdapter.getInstance().getGalaxPoProviderByProtectGroup(pg)) == null) {
            this.logger.error((Object)("not found provider for pg " + pg.getUuid()));
            throw new LegoCheckedException(1073947393L);
        }
        return provider.checkRecoveryContext(procType, recoveryContext, recoveryPlan, reySite);
    }

    public String getRecoverySiteId(String planId, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType, Map<String, String> recoveryContext) {
        RecoveryPlan plan = ((IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class)).getRecoveryPlan(planId);
        return this.getRecoverySiteId(plan, procType, recoveryContext);
    }

    public String getRecoverySiteId(RecoveryPlan plan, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType, Map<String, String> recoveryContext) {
        ProtectGroup pg = (ProtectGroup)VirtualizationCommonUtil.getInstance().getElementFromCollection((Collection)plan.getProtectGroups());
        int templateType = pg.getTemplate().getType();
        if (this.is2DC(templateType) || this.is3DC(templateType)) {
            String reySite = ((ProtectGroupReplica)VirtualizationCommonUtil.getInstance().getElementFromCollection((Collection)pg.getReplicaList())).getRecoverySite();
            if (!VerifyUtil.isEmpty((String)recoveryContext.get("DISASTER_SITE_ID"))) {
                reySite = recoveryContext.get("DISASTER_SITE_ID");
            } else {
                recoveryContext.put("DISASTER_SITE_ID", reySite);
            }
            return reySite;
        }
        if (this.isOpenStack2DC(templateType) || this.isOpenStack3DC(templateType)) {
            return ((ProtectGroupReplica)VirtualizationCommonUtil.getInstance().getElementFromCollection((Collection)pg.getReplicaList())).getRecoverySite();
        }
        return "";
    }

    private boolean is2DC(int templateType) {
        boolean is2DC1 = 0 == templateType || 1 == templateType;
        is2DC1 = is2DC1 || 33 == templateType;
        boolean is2DC2 = 11 == templateType;
        boolean is2DC3 = 18 == templateType || 20 == templateType || 23 == templateType || 24 == templateType;
        boolean is2DC4 = 26 == templateType || 27 == templateType;
        return is2DC1 || is2DC2 || is2DC3 || is2DC4;
    }

    private boolean isOpenStack2DC(int templateType) {
        return 21 == templateType || 22 == templateType || 25 == templateType;
    }

    private boolean isOpenStack3DC(int templateType) {
        return 34 == templateType || 37 == templateType;
    }

    private boolean is3DC(int templateType) {
        return 3 == templateType || 4 == templateType || 5 == templateType || 6 == templateType;
    }

    private boolean isOpenStackVm(String planId) {
        RecoveryPlan plan = ((IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class)).getRecoveryPlan(planId);
        if (null == plan) {
            this.logger.error((Object)"plan is null");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)plan.getProtectGroups());
        if (null == pg) {
            this.logger.error((Object)"pg is null");
            throw new LegoCheckedException(1073947393L);
        }
        int templateType = pg.getTemplate().getType();
        List<Integer> openStackPolicyTemplate = Arrays.asList(22, 21, 25, 34, 37);
        return openStackPolicyTemplate.contains(templateType);
    }

    public void checkRecoverySettings(List<RecoverySetting> recoverySettingList) {
        RecoverySetting tempSetting = (RecoverySetting)CommonUtil.getFirstElement(recoverySettingList);
        if (null == tempSetting) {
            this.logger.debug((Object)"tempSetting is null");
            return;
        }
        String planId = tempSetting.getRecoveryPlan().getUuid();
        RecoveryPlan plan = ((IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class)).getRecoveryPlan(planId);
        if (null == plan) {
            this.logger.error((Object)"plan is null");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)plan.getProtectGroups());
        if (null == pg) {
            this.logger.error((Object)"pg is null");
            throw new LegoCheckedException(1073947393L);
        }
        IGalaxProtectObjectCloudProvider provider = GalaxProtectObjectCloudProviderAdapter.getInstance().getGalaxPoProviderByProtectGroup(pg);
        if (provider == null) {
            this.logger.error((Object)("not found provider for pg " + pg.getUuid()));
            throw new LegoCheckedException(1073947393L);
        }
        provider.checkRecoverySettings(recoverySettingList);
    }
}

