/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.discovery.msg;

import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.drm.galax.constant.cloudenum.ObserverManagerEnum;
import com.huawei.ism.drm.galax.sdk.dao.IDaoAdapter;
import com.huawei.ism.drm.galax.sdk.model.DataStore;
import com.huawei.ism.drm.galax.sdk.model.DrVrm;
import com.huawei.ism.drm.galax.sdk.model.FusionManager;
import com.huawei.ism.drm.galax.sdk.model.VRG;
import com.huawei.ism.drm.galax.sdk.model.VRM;
import com.huawei.ism.drm.virtualization.observer.ObserverManager;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageRegister;
import com.huawei.lego.comm.internal.jms.MessageTaskManager;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class GalaxMessageSubscriber
extends MessageTaskManager {
    private static final Log LOGGER = LogFactory.getInstance(GalaxMessageSubscriber.class);

    public GalaxMessageSubscriber(IMessageCenter msgCenter) {
        msgCenter.addSubscriberTo((MessageTaskManager)this);
    }

    public MessageRegister[] getTypes() {
        MessageRegister[] mrs = MessageRegister.getMessageRegisters((int)2);
        mrs[0].setMessageTopic(MessageTopic.DATA);
        mrs[0].addMessageCode(103L);
        mrs[0].addMessageCode(107L);
        mrs[0].addMessageCode(105L);
        mrs[1].setMessageTopic(MessageTopic.COMMAND);
        mrs[1].addMessageCode(7005L);
        return mrs;
    }

    public void onMessage(MessageUnit mu) {
        long msgType = mu.getCmdcode();
        if (103L != msgType && 107L != msgType && 7005L != msgType && 105L != msgType) {
            LOGGER.error((Object)("Message was not subscribed, msgType: " + msgType), 90160758786876L);
            return;
        }
        try {
            Thread.currentThread();
            Thread.sleep(1500L);
        }
        catch (InterruptedException e1) {
            LOGGER.error((Object)"InterruptedException error", (Throwable)e1);
        }
        this.processMessage(mu);
    }

    private void processMessage(MessageUnit mu) {
        long msgType = mu.getCmdcode();
        Object msg = mu.getObj();
        if (!(msg instanceof Map)) {
            return;
        }
        Map objs = (Map)msg;
        for (Object obj : objs.values()) {
            if (7005L == msgType) {
                this.processNetworkEntityInfoChanged(obj);
            }
            if (!(obj instanceof VRM)) continue;
            this.processVrmMsg(msgType, obj);
        }
    }

    private void processNetworkEntityInfoChanged(Object obj) {
        if (obj instanceof FusionManager) {
            this.processFmInfoChanged(obj);
        }
        if (obj instanceof VRM) {
            this.processVRMInfoChanged(obj);
        }
        if (obj instanceof VRG) {
            this.processVRGInfoChanged(obj);
        }
    }

    private void processVRGInfoChanged(Object obj) {
        AbstractContext context = new AbstractContext();
        context.setAttribute("GALAX_KEY_FLAG", (Object)"DRMVRG");
        context.setAttribute("DRMVRG", obj);
        ObserverManager.getInstance((String)ObserverManagerEnum.FM_DISCOVER_MANAGER.name()).syncNotifyAllObservers((Object)context);
    }

    private void processVRMInfoChanged(Object obj) {
        AbstractContext context = new AbstractContext();
        context.setAttribute("GALAX_KEY_FLAG", (Object)"DRMVRM");
        VRM vrm = (VRM)obj;
        HashSet moset = new HashSet();
        vrm.setChildMos(moset);
        context.setAttribute("DRMVRM", (Object)vrm);
        ObserverManager.getInstance((String)ObserverManagerEnum.FM_DISCOVER_MANAGER.name()).syncNotifyAllObservers((Object)context);
    }

    private void processFmInfoChanged(Object obj) {
        AbstractContext context = new AbstractContext();
        context.setAttribute("GALAX_KEY_FLAG", (Object)"DRMFM");
        FusionManager fm = (FusionManager)obj;
        HashSet moset = new HashSet();
        fm.setChildMos(moset);
        context.setAttribute("DRMFM", (Object)fm);
        ObserverManager.getInstance((String)ObserverManagerEnum.FM_DISCOVER_MANAGER.name()).syncNotifyAllObservers((Object)context);
    }

    private void processVrmMsg(long msgType, Object obj) {
        VRM vrm = (VRM)obj;
        if (105L == msgType) {
            this.deleteRelationMo(vrm);
        }
    }

    private void deleteRelationMo(VRM vrm) {
        if (null == vrm || null == vrm.getMoId()) {
            return;
        }
        ArrayList<String> sns = new ArrayList<String>();
        sns.add(vrm.getSn());
        List listDrVrm = ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).getResourceList(sns, DrVrm.class, "deviceSn");
        if (null != listDrVrm) {
            for (DrVrm drVrm : listDrVrm) {
                ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).deleteResouce((Object)drVrm);
            }
        }
        ArrayList<String> dsSns = new ArrayList<String>();
        dsSns.add(vrm.getUuid());
        List listDs = ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).getResourceList(dsSns, DataStore.class, "vrmUuid");
        if (null != listDs) {
            for (DataStore ds : listDs) {
                ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).deleteMoById(ds.getMoId());
            }
        }
    }
}

