/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.discovery.service;

import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.drm.galax.protection.adapter.GalaxProtectObjectCloudProviderAdapter;
import com.huawei.ism.drm.galax.resource.discovery.service.CloudServiceUtil;
import com.huawei.ism.drm.galax.sdk.dao.IDaoAdapter;
import com.huawei.ism.drm.galax.sdk.model.CloudInfo;
import com.huawei.ism.drm.galax.sdk.model.ICloudResource;
import com.huawei.ism.drm.galax.sdk.pg.service.IGalaxProtectObjectCloudProvider;
import com.huawei.ism.drm.galax.sdk.service.ICloudService;
import com.huawei.ism.drm.galax.util.cloud.FmUtils;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.util.SiteResourceManagerUtil;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Service(Name="com.huawei.ism.drm.galax.sdk.service.ICloudService", Desc="", Interface=ICloudService.class)
public class CloudServiceImpl
extends BaseService
implements ICloudService {
    private static Log logger = LogFactory.getInstance(CloudServiceImpl.class);
    private INeMgrProtocolExtendService neMgr;
    private String debug = "debug";

    public INeMgrProtocolExtendService getNeMgr() {
        return this.neMgr;
    }

    public void setNeMgr(INeMgrProtocolExtendService neMgr) {
        this.neMgr = neMgr;
    }

    public void refreshCloud(String cloudSn, String userName) {
        this.refreshCloud(cloudSn, null, userName, true);
    }

    private String getCloudType(String cloudSn) {
        try {
            String hql = "from DrResource as dh where dh.deviceSn = ? ";
            Object[] condition = new String[]{cloudSn};
            List resources = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(hql, condition);
            if (resources == null || resources.isEmpty()) {
                logger.error((Object)"resources is null or empty.");
                throw new LegoCheckedException(1073947393L);
            }
            DrResource resource = (DrResource)resources.get(0);
            if (resource instanceof ICloudResource) {
                return resource.getClass().getSimpleName();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to refreshCloud because param is invalid");
        }
        return null;
    }

    private void refreshCloud(String cloudSn, String type, String userName, boolean cascade) {
        type = type != null ? type : this.getCloudType(cloudSn);
        logger.info((Object)new StringBuilder().append("refreshCloud enter. cloudSn=").append(cloudSn).append(",type=").append(type).append(",userName=").append(userName), 90160758786816L);
        IGalaxProtectObjectCloudProvider provider = GalaxProtectObjectCloudProviderAdapter.getInstance().getGalaxPoProviderByCloud(type);
        if (provider == null) {
            logger.error((Object)"Failed to refreshCloud because type is invalid", 90160758786816L);
            throw new LegoCheckedException(1073947393L);
        }
        provider.refreshCloud(cloudSn, userName, cascade);
    }

    public Page pageQueryRegistedCloudsBySiteId(String siteId, String orderBy, int pageNo, int pageSize, boolean isAsc, Long userId) {
        logger.debug((Object)(this.debug + "pageQueryRegistedCloudsBySiteId enter"), 90160758786816L);
        if (VerifyUtil.isEmpty((Object)userId)) {
            logger.error((Object)"UserId is empty,", 90160758787071L);
            return new Page();
        }
        Site site = CloudServiceImpl.getSiteByIdObjectNotExist(siteId);
        List<Object> registedCloud = null;
        List<DrResource> drVrms = CloudServiceUtil.findDrResources(DrResource.class, site.getSiteId(), null, orderBy, isAsc);
        if (drVrms != null) {
            registedCloud = this.fillRegistedCloudInfos(userId, site, drVrms);
        }
        if (null == registedCloud) {
            registedCloud = Collections.emptyList();
        }
        return Page.createPage((int)pageNo, (int)pageSize, registedCloud);
    }

    public static Site getSiteByIdObjectNotExist(String siteId) {
        Site site = SiteResourceManagerUtil.isSiteExisted((String)siteId);
        if (null == site) {
            logger.error((Object)"unable to get site,obj is not existed.", 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        return site;
    }

    private List<CloudInfo> fillRegistedCloudInfos(Long userId, Site site, List<? extends DrResource> registedClouds) {
        logger.debug((Object)(this.debug + "fillRegistedCloudInfos enter"), 90160758786816L);
        List<CloudInfo> registedCloud = this.filterRegistedCloudsByUser(userId, site, registedClouds);
        return registedCloud;
    }

    private List<CloudInfo> filterRegistedCloudsByUser(Long userId, Site site, List<? extends DrResource> registedClouds) {
        logger.debug((Object)(this.debug + "fillRegistedCloudInfos enter"), 90160758786816L);
        ArrayList<CloudInfo> registedCloud = new ArrayList<CloudInfo>();
        List sns = new ArrayList<String>();
        for (DrResource drResource : registedClouds) {
            sns.add(drResource.getDeviceSn());
        }
        if (0 == site.getSiteType()) {
            sns = ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).filterDrResourceSN(sns, userId);
        }
        for (DrResource drResource : registedClouds) {
            if (!sns.contains(drResource.getDeviceSn()) || !(drResource instanceof ICloudResource)) continue;
            CloudInfo cinfo = FmUtils.translateCloudInfo((DrResource)drResource, null);
            registedCloud.add(cinfo);
        }
        return registedCloud;
    }
}

