/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.discovery.service;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.DiscParamValidator;
import com.huawei.ism.drm.galax.sdk.dao.IDaoAdapter;
import com.huawei.ism.drm.galax.sdk.model.DrFm;
import com.huawei.ism.drm.galax.sdk.model.DrVrm;
import com.huawei.ism.drm.galax.sdk.model.VrmCommInfo;
import com.huawei.ism.drm.galax.util.GalaxValidator;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;

public class CloudServiceUtil {
    private static Log logger = LogFactory.getInstance(CloudServiceUtil.class);
    private static String debug = "debug";

    private CloudServiceUtil() {
    }

    public static List<DrFm> findDrFms(String siteId, String fmSn) {
        logger.debug((Object)(debug + "findDrFms enter"), 90160758786816L);
        return CloudServiceUtil.findDrResources(DrFm.class, siteId, fmSn, "", false);
    }

    public static List<DrVrm> findDrVrms(String siteId, String vrmSn) {
        logger.debug((Object)(debug + "findDrVrms enter"), 90160758786816L);
        return CloudServiceUtil.findDrResources(DrVrm.class, siteId, vrmSn, null, false);
    }

    static <T extends DrResource> List<T> findDrResources(Class<T> classType, String siteId, String resSn, String orderBy, boolean isAsc) {
        String[] conditions;
        logger.debug((Object)(debug + "findDrResources enter"), 90160758786816L);
        StringBuilder siteSql = new StringBuilder();
        siteSql.append("from ");
        siteSql.append(classType.getSimpleName());
        if (null == siteId && null == resSn) {
            conditions = new String[]{};
        } else if (null == siteId) {
            siteSql.append(" as dh where dh.deviceSn = ?");
            conditions = new String[]{resSn};
        } else if (null == resSn) {
            siteSql.append(" as dh where dh.siteId = ?");
            conditions = new String[]{siteId};
        } else {
            siteSql.append(" as dh where dh.deviceSn = ? and dh.siteId = ?");
            conditions = new String[]{resSn, siteId};
        }
        GalaxValidator.canOrderBy((String)orderBy);
        if (!VerifyUtil.isEmpty((String)orderBy) && orderBy.indexOf(" ") == -1) {
            siteSql.append(" order by ").append(orderBy).append(isAsc ? " ASC" : " DESC");
        }
        return CloudServiceUtil.queryDrResourceFromDB(siteSql.toString(), conditions);
    }

    private static <T> List<T> queryDrResourceFromDB(String siteSql, String[] conditions) {
        List vrms;
        logger.debug((Object)(debug + "queryDrResourceFromDB enter"), 90160758786816L);
        try {
            vrms = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(siteSql, (Object[])conditions);
        }
        catch (DataAccessException ex) {
            logger.error((Object)"unable to get vrm by vrmSn:", (Throwable)ex, 90160758787071L);
            throw new LegoCheckedException(-1L, (Throwable)ex);
        }
        return vrms;
    }

    static void checkCloudPlatformIsUsed(String siteId, String sn) {
        logger.debug((Object)(debug + "checkCloudPlatformIsUsed enter"), 90160758786816L);
        if (CloudServiceUtil.isInLocalProtectGroup(sn)) {
            logger.error((Object)("the DrVrm has been used in protectGroup:" + sn), 90160758787071L);
            throw new LegoCheckedException(1073947664L);
        }
    }

    static boolean isInLocalProtectGroup(String sn) {
        logger.debug((Object)(debug + "isInLocalProtectGroup enter"), 90160758786816L);
        List listPg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByType(12, Long.valueOf(1L));
        if (null == listPg || listPg.isEmpty()) {
            return false;
        }
        for (ProtectGroup pg : listPg) {
            if (!sn.equals(pg.getPoProviderSN())) continue;
            return true;
        }
        return false;
    }

    static void updateNetworkEntity(VrmCommInfo commInfo, String fmUri, NetworkEntity cloudPlatform) {
        logger.debug((Object)(debug + "updateNetworkEntity enter"), 90160758786816L);
        cloudPlatform.setLinkIp(commInfo.getIp());
        cloudPlatform.setIpAddress(commInfo.getIp());
        cloudPlatform.setUuid(fmUri);
        cloudPlatform.setSn(cloudPlatform.getUuid());
        logger.info((Object)("Cloud Platform(" + cloudPlatform.getSn() + ") load ok."), 90160758786816L);
        ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).saveOrUpdate((Object)cloudPlatform);
        logger.info((Object)("Cloud Platform(" + cloudPlatform.getSn() + ") has been update."), 90160758786816L);
    }

    static <T extends DrResource> void updateRegistedCloud(VrmCommInfo commInfo, NetworkEntity cloudPlatform, Class<T> classType) {
        logger.debug((Object)(debug + "updateRegistedCloud enter"), 90160758786816L);
        List<T> list = CloudServiceUtil.findDrResources(classType, null, cloudPlatform.getSn(), null, false);
        if (!VerifyUtil.isEmpty(list)) {
            DrResource drFm = (DrResource)list.get(0);
            drFm.setIpAddress(commInfo.getIp());
            if (drFm instanceof DrFm) {
                ((DrFm)drFm).setPort(commInfo.getPort());
            } else if (drFm instanceof DrVrm) {
                ((DrVrm)drFm).setPort(commInfo.getPort());
            }
            drFm.setDeviceSn(cloudPlatform.getSn());
            ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).saveOrUpdate((Object)drFm);
            logger.info((Object)("sucess to save drfm(" + cloudPlatform.getSn() + ")."), 90160758786816L);
        }
    }

    static <T extends ManagedObject> List<T> getAllLocalMos(Class<T> classType) {
        List fms;
        logger.debug((Object)(debug + "getAllLocalMos enter"), 90160758786816L);
        try {
            fms = CommonDAOLocator.getMoDao().getAllMo(classType);
        }
        catch (DataAccessException ex) {
            logger.error((Object)"failed to get all local Mos:", (Throwable)ex, 90160758787071L);
            throw new LegoCheckedException(-1L, (Throwable)ex);
        }
        return fms;
    }

    static <T extends NetworkEntity, F extends DrResource> List<F> getUnregisteredDrResource(List<T> clouds, List<F> listRegisted, List<String> sns) {
        logger.debug((Object)(debug + "getUnregisteredDrResource enter"), 90160758786816L);
        ArrayList unregisterd = new ArrayList();
        return unregisterd;
    }

    static <T extends DrResource> boolean isCloudRegisted(NetworkEntity fm, List<T> listRegisted) {
        logger.debug((Object)(debug + "isCloudRegisted enter"), 90160758786816L);
        if (listRegisted == null) {
            return false;
        }
        for (DrResource existed : listRegisted) {
            if (!existed.getDeviceSn().equals(fm.getSn())) continue;
            return true;
        }
        return false;
    }

    public static void checkParamIsValid(Map<String, String> paramMap) {
        logger.debug((Object)(debug + "checkParamIsValid enter"), 90160758786816L);
        if (VerifyUtil.isEmpty(paramMap)) {
            logger.error((Object)"parameter paramMap is null.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        String userName = paramMap.get("username");
        String userInfo = paramMap.get("password");
        if (VerifyUtil.isEmpty((String)userName) || userName.length() > 20 || VerifyUtil.isEmpty((String)userInfo)) {
            logger.error((Object)"@@username or pssword is null,and discovering cloud is failed.", 90160758787071L);
            throw new LegoCheckedException(1073948931L);
        }
        String port = paramMap.get("port");
        String deviceType = paramMap.get("devicetype");
        if ("FusionManager".equalsIgnoreCase(deviceType)) {
            CloudServiceUtil.checkCloudPort(port);
        } else if ("FusionCompute".equalsIgnoreCase(deviceType)) {
            CloudServiceUtil.checkCloudPort(port);
        } else {
            logger.error((Object)("Does't support devicetype : " + deviceType), 90160758786880L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private static void checkCloudPort(String port) {
        int intPort;
        logger.debug((Object)(debug + "checkCloudPort enter"), 90160758786816L);
        if (VerifyUtil.isEmpty((String)port)) {
            logger.error((Object)"param: port is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        try {
            intPort = Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            logger.error((Object)("The parameter of Cloud Port is error, port=" + port), 90160758787071L);
            throw new LegoCheckedException(1073947393L, (Throwable)e);
        }
        if (!DiscParamValidator.isPort((int)intPort)) {
            logger.error((Object)("The parameter of Cloud Port is invalid, intPort=" + intPort), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
    }
}

