/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.manager.common;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.galax.sdk.dao.IDaoAdapter;
import com.huawei.ism.drm.galax.sdk.service.IResScopeService;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.dao.DataAccessException;

@Service(Name="com.huawei.ism.drm.galax.sdk.service.IResScopeService", Desc="", Interface=IResScopeService.class)
public class ResScopeServiceImpl
extends BaseService
implements IResScopeService {
    private static final Log LOGGER = LogFactory.getInstance(ResScopeServiceImpl.class);
    private IDaoAdapter daoAdapter;

    public String getPoNameByPoId(String poId) {
        List nameList;
        String hql = "select name from ProtectObject where poId = ?";
        try {
            nameList = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(hql, new Object[]{poId});
        }
        catch (DataAccessException e) {
            LOGGER.error((Object)("failed to find poName, poId:" + poId), (Throwable)e, 90160758787071L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        if (!VerifyUtil.isEmpty((Collection)nameList)) {
            return (String)nameList.get(0);
        }
        return null;
    }

    public <T extends ManagedObject> T getMo(Class<T> cl, String type, Object value) {
        return (T)this.daoAdapter.getMo(cl, type, value);
    }

    public <T> List<T> getResources(Class<T> clazz, String propertyName, List<String> values) {
        return this.daoAdapter.getResources(clazz, propertyName, values);
    }

    public List<String> filterResource(List<String> snList, Long userId) {
        if (VerifyUtil.isEmpty(snList)) {
            return new ArrayList<String>();
        }
        return ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).filterDrResourceSN(snList, userId);
    }

    public void checkResourceAuthority(String sn, Long userId) {
        if (VerifyUtil.isEmpty((String)sn)) {
            LOGGER.error((Object)"sn is empty or null.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<String> snList = new ArrayList<String>(1);
        snList.add(sn);
        this.checkNetworkEntityExist(snList);
        this.checkResourceAuthority(snList, userId);
    }

    private void checkNetworkEntityExist(List<String> snList) {
        QueryCondition condition = new QueryCondition("sn", (Object)snList.toArray());
        ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
        conditions.add(condition);
        List entities = CommonDAOLocator.getMoDao().findMoBy(NetworkEntity.class, conditions);
        if (VerifyUtil.isEmpty((Collection)entities)) {
            LOGGER.error((Object)("object is not exist. snList=" + snList), 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
    }

    private void checkResourceAuthority(List<String> snList, Long userId) {
        List<String> resList = this.filterResource(snList, userId);
        if (VerifyUtil.isEmpty(resList)) {
            LOGGER.error((Object)("This user does not have enough right. snList=" + snList), 90160758787071L);
            throw new LegoCheckedException(1073947400L);
        }
    }

    public void setDaoAdapter(IDaoAdapter daoAdapter) {
        this.daoAdapter = daoAdapter;
    }

    public IDaoAdapter getDaoAdapter() {
        return this.daoAdapter;
    }
}

