/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.provider.protectgroup;

import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.CommonComparator;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.galax.constant.cloudenum.PgExParamsEnum;
import com.huawei.ism.drm.galax.protection.adapter.GalaxProtectGroupProviderAdapter;
import com.huawei.ism.drm.galax.protection.adapter.GalaxProtectObjectCloudProviderAdapter;
import com.huawei.ism.drm.galax.resource.checker.ProtectObjectCountChecker;
import com.huawei.ism.drm.galax.sdk.pg.service.IGalaxProtectObjectCloudProvider;
import com.huawei.ism.drm.galax.sdk.pg.service.IGalaxProtectObjectProvider;
import com.huawei.ism.drm.protection.framework.service.provider.AbstractProtectObjectProvider;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager;
import com.huawei.ism.drm.util.Base64;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.base.thread.MemeryContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class GalaxVirtualMachineProvider
extends AbstractProtectObjectProvider {
    private static final String CODE_UTF_8 = "UTF-8";
    private static final Log logger = LogFactory.getInstance(GalaxVirtualMachineProvider.class);
    private static final List<Integer> ULTRAVR_EXCLUDE_POLICYTEMPLATETYPES = Collections.unmodifiableList(Arrays.asList(19, 23, 24, 3, 4, 5, 6));
    private String trace = "trace";
    private IPolicyTemplateManager policyTemplateManager;

    public IPolicyTemplateManager getPolicyTemplateManager() {
        logger.trace((Object)(" enter  getPolicyTemplateManager" + this.trace));
        return this.policyTemplateManager;
    }

    public void setPolicyTemplateManager(IPolicyTemplateManager policyTemplateManager) {
        logger.trace((Object)(" enter  setPolicyTemplateManager" + this.trace));
        this.policyTemplateManager = policyTemplateManager;
    }

    public List<ProtectObject> getSupportProtectObjectTypes() {
        logger.trace((Object)(this.trace + " trace message"));
        ArrayList<ProtectObject> poList = new ArrayList<ProtectObject>();
        ProtectObject po = new ProtectObject();
        po.setPoType(12);
        po.setName("Huawei Virtual Machine");
        poList.add(po);
        return poList;
    }

    public int getProviderByType() {
        logger.trace((Object)(this.trace + " trace message"));
        return 12;
    }

    public void buildProtectObjects(ProtectGroup protectGroup) {
        logger.trace((Object)(this.trace + " trace message"));
        String cloudSn = protectGroup.getPoProviderSN();
        String protectType = (String)protectGroup.getProps().get(PgExParamsEnum.PG_PROTECT_TYPE.getValue());
        IGalaxProtectObjectCloudProvider poProvider = this.getProtectObjectProvider(cloudSn);
        if (null == poProvider) {
            return;
        }
        Map pgProps = protectGroup.getProps();
        pgProps.put("PROVIDER_TYPE", poProvider.getProviderType());
        if (VerifyUtil.isEmpty((Collection)protectGroup.getPolist())) {
            return;
        }
        for (ProtectObject po : protectGroup.getPolist()) {
            po.setProtectGroup(protectGroup);
            Map props = po.getProps();
            props.put(PgExParamsEnum.PG_PROTECT_TYPE.getValue(), protectType);
        }
        poProvider.buildProtectObjects(protectGroup);
    }

    private void checkMaxPoCount(ProtectGroup protectGroup) {
        logger.trace((Object)(this.trace + " trace message"));
        ProtectObjectCountChecker.checkPoCountInPg(protectGroup.getPoCount());
        ProtectObjectCountChecker.checkPoCountInSystem(protectGroup.getPoCount(), protectGroup.getUuid());
    }

    public List<ProtectObject> getAvailableProtectObject(String poProviderSn, Map<String, Object> extendCondition) {
        logger.trace((Object)(this.trace + " trace message"));
        IGalaxProtectObjectCloudProvider poProvider = this.getProtectObjectProvider(poProviderSn);
        if (null == poProvider) {
            return null;
        }
        List result = poProvider.getAvailableProtectObject(poProviderSn, extendCondition);
        this.pageQueryPO(extendCondition, result);
        return result;
    }

    private void pageQueryPO(Map<String, Object> extendCondition, List<ProtectObject> poList) {
        logger.trace((Object)(this.trace + " trace message"));
        if (!VerifyUtil.isEmpty(poList)) {
            String orderBy = (String)extendCondition.get("orderBy");
            Integer pageSize = (Integer)extendCondition.get("pageSize");
            Integer startPage = (Integer)extendCondition.get("pageIndex");
            String orderType = (String)extendCondition.get("orderType");
            String nameValue = (String)extendCondition.get("name");
            String osTypeValue = (String)extendCondition.get("osType");
            String filterName = null;
            String filterValue = null;
            if (!VerifyUtil.isEmpty((String)osTypeValue)) {
                filterName = "osTypeValue";
                filterValue = osTypeValue;
            }
            if (!VerifyUtil.isEmpty((String)nameValue) && ParamChecker.checkNameQuery((String)nameValue)) {
                filterName = "name";
                filterValue = nameValue;
            }
            this.filterPO(filterName, filterValue, poList);
            this.pageQuery("name", poList, orderBy, orderType, startPage, pageSize);
        }
    }

    private void filterPO(String filterName, String filterValue, List<ProtectObject> poList) {
        logger.trace((Object)(this.trace + " trace message"));
        if (VerifyUtil.isEmpty((String)filterName) || VerifyUtil.isEmpty((String)filterValue) || VerifyUtil.isEmpty(poList)) {
            return;
        }
        Iterator<ProtectObject> iterator = poList.iterator();
        while (iterator.hasNext()) {
            ProtectObject po = iterator.next();
            if (!"name".equals(filterName) || po.getName().toUpperCase(Locale.getDefault()).contains(filterValue.toUpperCase(Locale.getDefault()))) continue;
            iterator.remove();
        }
    }

    private <T> void pageQuery(String defaultSortField, List<T> viewList, String orderBy, String orderType, int startPage, int pageSize) {
        Page page;
        String sortField;
        logger.trace((Object)(" enter  pageQuery" + this.trace));
        if (VerifyUtil.isEmpty(viewList)) {
            return;
        }
        String string = sortField = !VerifyUtil.isEmpty((String)orderBy) && CommonUtil.isValidDbColumn((String)orderBy) ? orderBy : defaultSortField;
        if (!VerifyUtil.isEmpty((String)sortField)) {
            boolean orderByAscend = VerifyUtil.isEmpty((String)orderType) || "asc".equalsIgnoreCase(orderType);
            viewList.sort((Comparator<T>)new CommonComparator(sortField, orderByAscend, false));
        }
        if (null != (page = Page.createPage((int)(startPage = Math.max(startPage, 0)), (int)(pageSize = Math.max(pageSize, 10)), viewList))) {
            viewList.clear();
            viewList.addAll(page.getResult());
        }
    }

    public List<ProtectObjectStorageInfo> getProtectObjectStorageInfo(ProtectObject po) {
        logger.trace((Object)(this.trace + " trace message"));
        return null;
    }

    public List<PolicyTemplate> getSupportPolicyTemplate(List<ProtectObject> protectObjectList) {
        logger.trace((Object)(this.trace + " trace message"));
        if (VerifyUtil.isEmpty(protectObjectList)) {
            return Collections.emptyList();
        }
        IGalaxProtectObjectCloudProvider poProvider = this.getProtectObjectProvider(protectObjectList.get(0));
        if (poProvider == null) {
            return Collections.emptyList();
        }
        return poProvider.getSupportPolicyTemplate(protectObjectList);
    }

    public List<ProtectObject> getAddAvailableProtectObject(String poProviderSn, String pgId, Map<String, Object> extParamInQueryParam) {
        logger.trace((Object)(this.trace + " trace message"));
        IGalaxProtectObjectCloudProvider poProvider = this.getProtectObjectProvider(poProviderSn);
        if (null == poProvider) {
            return null;
        }
        List result = poProvider.getAvailableProtectObject(poProviderSn, extParamInQueryParam);
        this.pageQueryPO(extParamInQueryParam, result);
        return result;
    }

    public void refreshProtectObjectProperties(List<ProtectObject> protectObjectList) {
        logger.trace((Object)(this.trace + " trace message"));
        if (VerifyUtil.isEmpty(protectObjectList)) {
            return;
        }
        ProtectObject po = protectObjectList.get(0);
        ProtectGroup pg = po.getProtectGroup();
        if (VerifyUtil.isEmpty((Object)pg)) {
            return;
        }
        IGalaxProtectObjectCloudProvider poProvider = this.getProtectObjectProvider(protectObjectList.get(0));
        if (VerifyUtil.isEmpty((Object)poProvider)) {
            return;
        }
        poProvider.refreshProtectObjectProperties(pg);
    }

    public void checkProtectObjectsInProtectGroup(ProtectGroup protectGroup) {
        if (!PolicyTemplateType.OPENSTACK_POLICYTEMPLATE.contains(protectGroup.getTemplate().getType())) {
            this.checkMaxPoCount(protectGroup);
        }
    }

    public void loadProtectObjectStorageInfo(List<ProtectObject> protectObjectList) {
        logger.trace((Object)(this.trace + " trace message"));
        if (null == protectObjectList || protectObjectList.isEmpty()) {
            logger.warn((Object)"protectObjectList is empty", 90160758786816L);
            return;
        }
        IGalaxProtectObjectCloudProvider poProvider = this.getProtectObjectProvider(protectObjectList.get(0));
        if (null == poProvider) {
            return;
        }
        poProvider.loadProtectObjectStorageInfo(protectObjectList, new Object());
    }

    public List<PolicyTemplate> getSupportPolicyTemplate(List<ProtectObject> protectObjectList, int replicationType) {
        logger.trace((Object)(this.trace + " trace message"));
        if (null == protectObjectList) {
            return new ArrayList<PolicyTemplate>();
        }
        IGalaxProtectObjectCloudProvider poProvider = this.getProtectObjectProvider(protectObjectList.get(0));
        if (poProvider == null) {
            return new ArrayList<PolicyTemplate>();
        }
        return poProvider.getSupportPolicyTemplate(protectObjectList, replicationType);
    }

    public static boolean isUltraVRExclude(PolicyTemplate policy) {
        return GalaxVirtualMachineProvider.isUltraVR() && ULTRAVR_EXCLUDE_POLICYTEMPLATETYPES.contains(policy.getType());
    }

    public static boolean isUltraVR() {
        String sql = "select count(*) from pg_class where relname = 'T_VR'";
        boolean flag = false;
        try {
            List list = CommonDAOLocator.getBaseDao().executeNativeSql(sql, new Object[0]);
            if (list != null && !list.isEmpty()) {
                Object item = list.get(0);
                if (item instanceof BigInteger) {
                    if (((BigInteger)item).intValue() > 0) {
                        flag = true;
                    }
                } else {
                    logger.error((Object)"getSoftwareInfo list.get(0) not BigInteger.", 90160758786816L);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"getSoftwareInfo productModel Failed.", 90160758786816L);
        }
        return flag;
    }

    public Map<String, Object> pretreatmentParams(Map<String, Object> params) {
        logger.trace((Object)(this.trace + " trace message"));
        if (VerifyUtil.isEmpty(params)) {
            return params;
        }
        String deviceSn = (String)params.get("deviceSn");
        if (VerifyUtil.isEmpty((String)deviceSn)) {
            return params;
        }
        try {
            String newDeviceSn = new String(Base64.base64ToByteArray((String)deviceSn), CODE_UTF_8);
            params.put("deviceSn", newDeviceSn);
        }
        catch (UnsupportedEncodingException e) {
            logger.info((Object)("uft-8 not support:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            throw new LegoCheckedException(102410L, (Throwable)e);
        }
        return params;
    }

    private IGalaxProtectObjectCloudProvider getProtectObjectProvider(ProtectObject po) {
        logger.trace((Object)(" enter  getProtectObjectProvider " + this.trace));
        String poProviderSn = po.getProviderSN();
        if (VerifyUtil.isEmpty((String)poProviderSn)) {
            ManagedObject mo = CommonDAOLocator.getMoDao().getMoByUuid(po.getMoUuid(), Boolean.valueOf(true));
            poProviderSn = null == mo ? GalaxVirtualMachineProvider.getOpenstackUuidFromStr(po.getMoUuid()) : mo.getTopMoUuid();
        }
        return this.getProtectObjectProvider(poProviderSn);
    }

    private static String getOpenstackUuidFromStr(String uuid) {
        String ret = "";
        if (VerifyUtil.isEmpty((String)uuid)) {
            return "";
        }
        if (uuid.contains(":")) {
            ret = uuid.split(":")[0];
        }
        return ret;
    }

    private IGalaxProtectObjectCloudProvider getProtectObjectProvider(String poProviderSn) {
        logger.trace((Object)(" enter  getProtectObjectProvider " + this.trace));
        List resources = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrResource where deviceSn=?", new Object[]{poProviderSn});
        if (VerifyUtil.isEmpty((Collection)resources)) {
            logger.error((Object)("resources get from DrResource where deviceSn= " + poProviderSn + "is null"), 90160758787071L);
            return null;
        }
        Object s1 = resources.get(0);
        String providerType = s1.getClass().getSimpleName();
        IGalaxProtectObjectCloudProvider poProvider = GalaxProtectObjectCloudProviderAdapter.getInstance().getGalaxPoProviderByCloud(providerType);
        return poProvider;
    }

    public void encryptProperties(ProtectGroup protectGroup) {
        IGalaxProtectObjectProvider iGalaxProtectObjectProvider;
        logger.trace((Object)(" enter  encryptProperties " + this.trace));
        String protectType = (String)protectGroup.getProps().get(PgExParamsEnum.PG_PROTECT_TYPE.getValue());
        if (null != protectType && null != (iGalaxProtectObjectProvider = GalaxProtectGroupProviderAdapter.getInstance().getGalaxPoProvider(protectType))) {
            iGalaxProtectObjectProvider.encryptProperties(protectGroup);
        }
    }

    public void decryptPropreties(ProtectGroup protectGroup) {
        logger.trace((Object)(" enter  decryptPropreties " + this.trace));
        String protectType = (String)protectGroup.getProps().get(PgExParamsEnum.PG_PROTECT_TYPE.getValue());
        IGalaxProtectObjectProvider galaxProtectObjectProvider = GalaxProtectGroupProviderAdapter.getInstance().getGalaxPoProvider(protectType);
        if (null != galaxProtectObjectProvider) {
            galaxProtectObjectProvider.decryptPropreties(protectGroup);
        }
    }

    public void refreshProtectGroup(ProtectGroup protectGroup) {
        String cloudSn = protectGroup.getPoProviderSN();
        if (VerifyUtil.isEmpty((String)protectGroup.getPoProviderSN())) {
            logger.error((Object)("cloudSn is empty,pgName=" + protectGroup.getName()));
            return;
        }
        IGalaxProtectObjectCloudProvider poProvider = this.getProtectObjectProvider(cloudSn);
        if (null == poProvider) {
            logger.error((Object)("can't get poprovider,cloudsn=" + cloudSn));
            return;
        }
        MemeryContext.with((Object)protectGroup.getUuid(), (Object)protectGroup, () -> poProvider.refreshProtectGroup(protectGroup));
    }
}

