/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.support.dao;

import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.galax.sdk.dao.IDaoAdapter;
import com.huawei.ism.drm.galax.sdk.model.DataStore;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.site.util.SiteResourceManagerUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;

public class DaoAdapter
implements IDaoAdapter {
    private static final Log LOGGER = LogFactory.getInstance(DaoAdapter.class);

    public void saveOrUpdate(Object obj) {
        try {
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate(obj);
        }
        catch (DataAccessException ex) {
            LOGGER.error((Object)"failed to save or update obj", 90160758787071L);
            this.savrOrUpdateMerge(obj);
        }
    }

    private void savrOrUpdateMerge(Object obj) {
        try {
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate(CommonDAOLocator.getBaseDao().getHibernateTemplate().merge(obj));
        }
        catch (DataAccessException ex) {
            LOGGER.error((Object)"failed to save or update obj(merge)", (Throwable)ex, 90160758787071L);
            throw new LegoCheckedException(-1L, (Throwable)ex);
        }
    }

    public void update(Object obj) {
        try {
            CommonDAOLocator.getBaseDao().getHibernateTemplate().update(obj);
        }
        catch (DataAccessException e) {
            LOGGER.error((Object)"failed to update obj", (Throwable)e, 90160758787071L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    public List<String> filterDrResourceSN(List<String> sns, Long userId) {
        try {
            sns = SiteResourceManagerUtil.filterDrResourceSN(sns, (Long)userId);
        }
        catch (DataAccessException ex) {
            LOGGER.error((Object)("failed to get sn:" + sns), (Throwable)ex, 90160758787071L);
            throw new LegoCheckedException(-1L, (Throwable)ex);
        }
        return sns;
    }

    public <T extends ManagedObject> T getMo(Class<T> cl, String type, Object value) {
        ManagedObject obj;
        try {
            obj = CommonDAOLocator.getMoDao().getMo(cl, type, value);
        }
        catch (DataAccessException ex) {
            LOGGER.error((Object)("unable to get mo by type:" + type), (Throwable)ex, 90160758787071L);
            throw new LegoCheckedException(-1L, (Throwable)ex);
        }
        return (T)obj;
    }

    public List<? extends ManagedObject> getListMo(Class<? extends ManagedObject> cl, String type, Object value) {
        List listMo;
        try {
            listMo = CommonDAOLocator.getMoDao().getMoList(cl, type, value);
        }
        catch (DataAccessException ex) {
            LOGGER.error((Object)("unable to get mo by type:" + type), (Throwable)ex, 90160758787071L);
            throw new LegoCheckedException(-1L, (Throwable)ex);
        }
        return listMo;
    }

    public List<? extends ManagedObject> getSubListMo(Class<? extends ManagedObject> cl, Long parrentMoid, List<QueryCondition> listCondition) {
        List listMo;
        try {
            listMo = CommonDAOLocator.getMoDao().findSubMoBy(parrentMoid.longValue(), cl, listCondition);
        }
        catch (DataAccessException ex) {
            LOGGER.error((Object)("unable to get sub mo by moid:" + parrentMoid), (Throwable)ex, 90160758787071L);
            throw new LegoCheckedException(-1L, (Throwable)ex);
        }
        return listMo;
    }

    public void deleteMoById(Long moid) {
        try {
            CommonDAOLocator.getMoDao().deleteMo(moid);
        }
        catch (DataAccessException ex) {
            LOGGER.error((Object)("failed to delete VRG moid:" + moid), (Throwable)ex, 90160758787071L);
            throw new LegoCheckedException(-1L, (Throwable)ex);
        }
    }

    public <T extends Serializable> List<T> getResourceList(List<String> sns, Class<T> clazz, String snKey) {
        List list;
        if (null == sns) {
            return null;
        }
        ArrayList<QueryCondition> queryCondition = new ArrayList<QueryCondition>();
        QueryCondition condition = new QueryCondition(snKey, (Object)sns.toArray());
        condition.setWholeWorld(true);
        queryCondition.add(condition);
        try {
            List criterionList = CommonDAOLocator.getBaseDao().translatePropsToCriterions(queryCondition);
            list = CommonDAOLocator.getBaseDao().createCriteria(clazz, criterionList.toArray(new Criterion[criterionList.size()]));
        }
        catch (DataAccessException ex) {
            LOGGER.error((Object)("failed to get resource sns:" + sns.toString()), (Throwable)ex, 90160758787071L);
            throw new LegoCheckedException(-1L, (Throwable)ex);
        }
        return list;
    }

    public void deleteResouce(Object res) {
        try {
            CommonDAOLocator.getBaseDao().getHibernateTemplate().delete(res);
        }
        catch (DataAccessException ex) {
            LOGGER.error((Object)"failed to delete resource", (Throwable)ex, 90160758787071L);
            throw new LegoCheckedException(-1L, (Throwable)ex);
        }
    }

    public ResourceMapping getResourceMappingByProductResourceId(String sn) {
        return this.getResourceMappingByProductRes("productResourceId", sn);
    }

    public ResourceMapping getResourceMappingByProductRes(String key, String value) {
        List<ResourceMapping> rmList = this.getResourceMappingList(key, value);
        return rmList.get(0);
    }

    public List<ResourceMapping> getResourceMappingList(String key, String value) {
        this.checkRMParamKey(key);
        String queryString = "from ResourceMapping as rm where rm." + key + " = ? ";
        List rmList = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(queryString, new Object[]{value});
        queryString = key.startsWith("product") ? queryString.replace(".product", ".recovery") : queryString.replace(".recovery", ".product");
        List rmList2 = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(queryString, new Object[]{value});
        if (!VerifyUtil.isEmpty((Collection)rmList2)) {
            ArrayList<ResourceMapping> copyList = new ArrayList<ResourceMapping>();
            for (ResourceMapping rm : rmList2) {
                copyList.add(rm.getSwapResourceMapping());
            }
            if (null != rmList && !rmList.isEmpty()) {
                copyList.addAll(rmList);
            }
            return copyList;
        }
        if (!VerifyUtil.isEmpty((Collection)rmList)) {
            return rmList;
        }
        LOGGER.error((Object)"rmList is empty.");
        throw new LegoCheckedException(1073947394L);
    }

    public List<ResourceMapping> getResourceMappingByType(Integer resType) {
        if (null == resType) {
            LOGGER.error((Object)"resType is null.");
            throw new LegoCheckedException(1073947393L);
        }
        String queryString = "from ResourceMapping as rm where rm.resourceType = ? ";
        return CommonDAOLocator.getBaseDao().getHibernateTemplate().find(queryString, new Object[]{resType});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> getResources(Class<T> clazz, String propertyName, List<String> values) {
        if (VerifyUtil.isEmpty(values)) {
            return new ArrayList();
        }
        Session session = null;
        try {
            List listRes;
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria crit = session.createCriteria(clazz);
            crit.add(Restrictions.in((String)propertyName, values));
            List list = listRes = crit.list();
            return list;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"get resources failed.", (long)-1L, null, (Log)LOGGER);
        }
        finally {
            this.closeSession(session);
        }
        return new ArrayList();
    }

    private void closeSession(Session session) {
        DBOperationUtil.closeSession((Session)session);
    }

    private void checkRMParamKey(String key) {
        Field[] fields;
        boolean isExist = false;
        for (Field field : fields = ResourceMapping.class.getDeclaredFields()) {
            if (null == field || !field.getName().equals(key)) continue;
            isExist = true;
            break;
        }
        if (!isExist) {
            LOGGER.error((Object)("key:" + key + "is not exist in ResourceMapping."), 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    public List<GalaxVM> queryGalaxVMByVmUuids(Set<String> vmUuids) {
        QueryCondition qc = new QueryCondition("uuid", (Object)vmUuids.toArray(), 8);
        ArrayList<QueryCondition> qcList = new ArrayList<QueryCondition>();
        qcList.add(qc);
        List vmList = CommonDAOLocator.getMoDao().findMoBy(GalaxVM.class, qcList);
        return vmList;
    }

    public List<DataStore> getDataStoresByVmUuids(Set<String> vmUuids) {
        List<GalaxVM> vmList = this.queryGalaxVMByVmUuids(vmUuids);
        if (VerifyUtil.isEmpty(vmList)) {
            LOGGER.error((Object)("query vm failed, vmUuids=" + vmUuids), 90160758787071L);
            return null;
        }
        HashSet<String> dsUrns = new HashSet<String>();
        for (GalaxVM vm : vmList) {
            if (VerifyUtil.isEmpty((String)vm.getDataStoreUrns())) continue;
            dsUrns.addAll(Arrays.asList(vm.getDataStoreUrns().split(",")));
        }
        QueryCondition dsQc = new QueryCondition("urn", (Object)dsUrns.toArray(), 8);
        ArrayList<QueryCondition> dsQcList = new ArrayList<QueryCondition>();
        dsQcList.add(dsQc);
        return CommonDAOLocator.getMoDao().findMoBy(DataStore.class, "name", true, dsQcList);
    }
}

