/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.resource.sdk.model;

import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.io.Serializable;
import java.util.Map;

public class TopoObjectQueryCondition
implements Serializable {
    private static final long serialVersionUID = -1297564004890579604L;
    private String appendixCondition = null;
    private String deviceName = null;
    private String devIpAddress = null;
    private int devState = 0;
    private String groupId = null;
    private int hCode = Integer.MIN_VALUE;
    private String mainDevTypeName = null;
    private String subDevTypeName = null;
    private String userId = null;
    private Boolean isManaged = null;
    private String deviceNameLikeQuery;
    private String devIpAddressLikeQuery;
    private String[] selectedMoIds;

    public TopoObjectQueryCondition() {
    }

    public TopoObjectQueryCondition(String groupId) {
        this.groupId = groupId;
        this.hCode = Integer.MIN_VALUE;
    }

    public Boolean getIsManaged() {
        return this.isManaged;
    }

    public void setIsManaged(Boolean isManaged) {
        this.isManaged = isManaged;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (!(obj instanceof TopoObjectQueryCondition)) {
            return false;
        }
        TopoObjectQueryCondition topObjectQuery = (TopoObjectQueryCondition)obj;
        if (null == this.getGroupId() || null == topObjectQuery.getGroupId()) {
            return false;
        }
        return this.getGroupId().equals(topObjectQuery.getGroupId());
    }

    public String getAppendixCondition() {
        return this.appendixCondition;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getDevIpAddress() {
        return this.devIpAddress;
    }

    public int getDevState() {
        return this.devState;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getMainDevTypeName() {
        return this.mainDevTypeName;
    }

    protected String getQuerySqlBase(Map<Integer, String> param) {
        String query = "";
        if (this.mainDevTypeName != null) {
            query = query + "d.mainType = ? ";
            param.put(param.size(), this.mainDevTypeName);
        }
        if (this.deviceName != null) {
            if (!query.isEmpty()) {
                query = query + " and ";
            }
            query = query + "d.name = ? ";
            param.put(param.size(), this.deviceName);
        }
        if (this.subDevTypeName != null) {
            if (!query.isEmpty()) {
                query = query + " and ";
            }
            query = query + "d.subType = ? ";
            param.put(param.size(), this.subDevTypeName);
        }
        query = this.appendAddressAndManaged(param, query);
        return query;
    }

    private String appendAddressAndManaged(Map<Integer, String> param, String query) {
        if (this.devIpAddress != null) {
            if (!query.isEmpty()) {
                query = query + " and ";
            }
            query = query + "d.ipAddress = ? ";
            param.put(param.size(), this.devIpAddress);
        }
        if (this.isManaged != null) {
            if (!query.isEmpty()) {
                query = query + " and ";
            }
            query = query + "d.managed = " + this.isManaged.toString();
        }
        return query;
    }

    protected String builderSelectedCondition(String query) {
        String ids;
        StringBuffer buffer = new StringBuffer();
        if (null != this.selectedMoIds && this.selectedMoIds.length > 0) {
            for (int i = 0; i < this.selectedMoIds.length; ++i) {
                buffer = this.construtcContion(buffer, i);
            }
        }
        if ((ids = buffer.toString()).endsWith(",")) {
            ids = ids.substring(0, ids.length() - 1);
        }
        if (null != ids && !"".endsWith(ids)) {
            if (!query.isEmpty()) {
                query = query + " and ";
            }
            query = query + "d.moId not in ( " + ids + ")";
        }
        return query;
    }

    private StringBuffer construtcContion(StringBuffer buffer, int i) {
        if (null != this.selectedMoIds[i] && !"".equals(this.selectedMoIds[i])) {
            try {
                NumberUtil.convertToLong(this.selectedMoIds[i]);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException(e, null, 250L, null);
            }
            buffer.append('\'');
            buffer.append(this.selectedMoIds[i]);
            buffer.append("',");
        }
        return buffer;
    }

    public String getQuerySql(Map<Integer, String> param) {
        String query = this.getQuerySqlBase(param);
        if (null != this.deviceNameLikeQuery) {
            if (!query.isEmpty()) {
                query = query + " and ";
            }
            query = query + "lower(d.name) like lower(?)";
            param.put(param.size(), this.deviceNameLikeQuery);
        }
        if (null != this.devIpAddressLikeQuery) {
            if (!query.isEmpty()) {
                query = query + " and ";
            }
            query = query + "d.ipAddress like ?";
            param.put(param.size(), this.devIpAddressLikeQuery);
        }
        query = this.builderSelectedCondition(query);
        if (this.appendixCondition != null) {
            if (!query.isEmpty()) {
                query = query + " and ";
            }
            query = query + this.appendixCondition;
        }
        return query;
    }

    public String getRawQuerySql() {
        String query = "";
        if (this.mainDevTypeName != null) {
            query = query + " MAINTYPE = '" + this.mainDevTypeName + "'";
        }
        if (this.deviceName != null) {
            if (!query.isEmpty()) {
                query = query + " and ";
            }
            query = query + " NAME = '" + this.deviceName + "'";
        }
        if (this.subDevTypeName != null) {
            if (!query.isEmpty()) {
                query = query + " and ";
            }
            query = query + " SUBTYPE = '" + this.subDevTypeName + "'";
        }
        query = this.appendAddressAndCondition(query);
        return query;
    }

    private String appendAddressAndCondition(String query) {
        if (this.devIpAddress != null) {
            if (!query.isEmpty()) {
                query = query + " and ";
            }
            query = query + " IPADDRESS = '" + this.devIpAddress + "'";
        }
        if (this.appendixCondition != null) {
            if (!query.isEmpty()) {
                query = query + " and ";
            }
            query = query + this.appendixCondition;
        }
        return query;
    }

    public String getSubDevTypeName() {
        return this.subDevTypeName;
    }

    public String getUserId() {
        return this.userId;
    }

    public int hashCode() {
        if (Integer.MIN_VALUE == this.hCode) {
            if (null == this.getGroupId()) {
                return super.hashCode();
            }
            String hashStr = this.getClass().getName() + ":" + this.getGroupId().hashCode();
            this.hCode = hashStr.hashCode();
        }
        return this.hCode;
    }

    public void setAppendixCondition(String appendixCondition) {
        this.appendixCondition = appendixCondition;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public void setDevIpAddress(String devIpAddress) {
        this.devIpAddress = devIpAddress;
    }

    public void setDevState(int devState) {
        this.devState = devState;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
        this.hCode = Integer.MIN_VALUE;
    }

    public void setMainDevTypeName(String mainDevTypeName) {
        this.mainDevTypeName = mainDevTypeName;
    }

    public void setSubDevTypeName(String subDevTypeName) {
        this.subDevTypeName = subDevTypeName;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getDeviceNameLikeQuery() {
        return this.deviceNameLikeQuery;
    }

    public void setDeviceNameLikeQuery(String deviceNameLikeQuery) {
        this.deviceNameLikeQuery = deviceNameLikeQuery;
    }

    public String getDevIpAddressLikeQuery() {
        return this.devIpAddressLikeQuery;
    }

    public void setDevIpAddressLikeQuery(String devIpAddressLikeQuery) {
        this.devIpAddressLikeQuery = devIpAddressLikeQuery;
    }

    public String[] getSelectedMoIds() {
        return this.selectedMoIds;
    }

    public void setSelectedMoIds(String[] selectedMoIds) {
        this.selectedMoIds = selectedMoIds;
    }

    public String toString() {
        return super.toString();
    }
}

