/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.resource.sdk.util;

import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import java.util.Collection;

public final class ManagedObjectUtil {
    private ManagedObjectUtil() {
    }

    public static void associate(Collection<? extends ManagedObject> children, ManagedObject parent) {
        ManagedObjectUtil.associate(children, parent, parent.getTopMoUuid(), true);
    }

    public static void associate(Collection<? extends ManagedObject> children, ManagedObject parent, boolean addChild) {
        ManagedObjectUtil.associate(children, parent, parent.getTopMoUuid(), addChild);
    }

    public static void associate(Collection<? extends ManagedObject> children, ManagedObject parent, String topMoUuid, boolean addChild) {
        if (null == children || children.isEmpty() || null == parent) {
            return;
        }
        for (ManagedObject managedObject : children) {
            ManagedObjectUtil.associate(managedObject, parent, topMoUuid, addChild);
        }
    }

    public static void associate(ManagedObject child, ManagedObject parent, String topMoUuid) {
        ManagedObjectUtil.associate(child, parent, topMoUuid, true);
    }

    public static void associate(ManagedObject child, ManagedObject parent, String topMoUuid, boolean addChild) {
        if (null == child) {
            return;
        }
        child.setParentMo(parent);
        child.setTopMoUuid(topMoUuid);
        if (addChild && null != parent) {
            parent.addChildMo(child);
        }
    }

    public static void associate(ManagedObject child, ManagedObject parent) {
        ManagedObjectUtil.associate(child, parent, parent.getTopMoUuid());
    }
}

