/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.com.south.snmp;

import com.huawei.lego.com.south.sdk.model.LegoSnmpOID;
import com.huawei.lego.com.south.sdk.model.LegoSnmpVar;
import com.huawei.lego.com.south.sdk.model.LegoSnmpVarBind;
import com.huawei.lego.com.south.sdk.model.SnmpEnum;
import com.huawei.lego.com.south.snmp.SnmpTarget;
import com.huawei.lego.com.south.snmp.abs.AbstractSnmpAPI;
import com.huawei.lego.com.south.snmp.abs.IResponse;
import com.huawei.lego.com.south.snmp.abs.ISnmpResponse;
import com.huawei.lego.com.south.snmp.abs.ISnmpTableResponse;
import com.huawei.lego.com.south.snmp.abs.Property;
import com.huawei.lego.com.south.snmp.abs.SnmpProtocolParam;
import com.huawei.lego.com.south.snmp.abs.VBPro;
import com.huawei.lego.com.south.snmp.api.Snmp4jAPIImpl;
import com.huawei.lego.com.south.snmp.api.TableResponse;
import com.huawei.lego.com.south.snmp.exception.SnmpException;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SnmpAPI
extends AbstractSnmpAPI {
    private static final long serialVersionUID = -6503561166038034536L;
    private Log logger = LogFactory.getInstance(this);
    private Snmp4jAPIImpl snmp = new Snmp4jAPIImpl();

    public SnmpAPI(SnmpEnum.SnmpVersion version) {
        this.setSnmpVersion(version);
    }

    public SnmpAPI(String host, int port, SnmpEnum.SnmpVersion version) {
        this.setTargetHost(host);
        this.setTargetPort(port);
        this.setSnmpVersion(version);
    }

    public LegoSnmpVarBind snmpGet(String snmpoid) {
        this.init();
        ISnmpResponse snmpRsp = this.snmp.snmpGet(snmpoid);
        snmpRsp.setInvokeName("snmpGet");
        if (!this.handleErrorStatus(snmpRsp, this.getSnmpTarget()) || this.checkRspVBS(snmpRsp)) {
            return null;
        }
        LegoSnmpOID legoOid = new LegoSnmpOID(SnmpEnum.SnmpType.STRING, snmpoid);
        LegoSnmpVar legoVar = new LegoSnmpVar(SnmpEnum.SnmpType.getSnmpType(snmpRsp.getVB().get(0).getType()), snmpRsp.getVB().get(0).getValue().trim());
        LegoSnmpVarBind legoVB = new LegoSnmpVarBind(legoOid, legoVar);
        return legoVB;
    }

    private boolean checkRspVBS(ISnmpResponse snmpRsp) {
        return snmpRsp.getVB().size() == 0;
    }

    private boolean handleErrorStatus(IResponse snmpRsp, SnmpTarget snmpTarget) {
        this.debugInfo(snmpRsp, snmpTarget);
        this.setErrorCode(snmpRsp.getStatusCode());
        if (snmpRsp.getStatusCode() == SnmpEnum.SnmpErrorStatus.NO_ERROR.getValue()) {
            return true;
        }
        this.logger.error((Object)("handleError: " + snmpRsp.getReasonPhrase() + ",errorCode: " + snmpRsp.getStatusCode() + ", host:" + snmpTarget.getTargetHost() + ", invoke:" + snmpRsp.getInvokeName() + ",oid:" + snmpRsp.getOidList()), 200L);
        return false;
    }

    private void debugInfo(IResponse snmpRsp, SnmpTarget snmpTarget) {
        if (!this.logger.isDebugEnabled()) {
            return;
        }
        this.logger.info((Object)("Rsp debug: " + snmpRsp.getReasonPhrase() + ",errorCode: " + snmpRsp.getStatusCode() + ", host:" + snmpTarget.getTargetHost() + ", invoke:" + snmpRsp.getInvokeName() + ",oids:" + snmpRsp.getOidList()), 200L);
    }

    public LegoSnmpVarBind[] snmpGetList(String[] snmpoids) {
        this.init();
        ISnmpResponse snmpRsp = this.snmp.snmpGet(snmpoids);
        snmpRsp.setInvokeName("snmpGetList");
        if (!this.handleErrorStatus(snmpRsp, this.getSnmpTarget())) {
            return new LegoSnmpVarBind[0];
        }
        List<Property> pros = snmpRsp.getVB().getVbs();
        if (null != pros && !pros.isEmpty()) {
            ArrayList<LegoSnmpVarBind> vbs = new ArrayList<LegoSnmpVarBind>();
            for (Property pro : pros) {
                LegoSnmpOID legoOid = new LegoSnmpOID(SnmpEnum.SnmpType.STRING, pro.getName());
                LegoSnmpVar legoVar = new LegoSnmpVar(SnmpEnum.SnmpType.getSnmpType(pro.getType()), pro.getValue().trim());
                LegoSnmpVarBind legoVB = new LegoSnmpVarBind(legoOid, legoVar);
                vbs.add(legoVB);
            }
            LegoSnmpVarBind[] result = vbs.toArray(new LegoSnmpVarBind[vbs.size()]);
            return result;
        }
        return new LegoSnmpVarBind[0];
    }

    public List<String> snmpGetVarList(String[] snmpoids) {
        this.init();
        ISnmpResponse snmpRsp = this.snmp.snmpGet(snmpoids);
        snmpRsp.setInvokeName("snmpGetVarList");
        if (!this.handleErrorStatus(snmpRsp, this.getSnmpTarget())) {
            return new ArrayList<String>(0);
        }
        List<Property> pros = snmpRsp.getVB().getVbs();
        if (null != pros && !pros.isEmpty()) {
            ArrayList<String> vbs = new ArrayList<String>();
            for (Property pro : pros) {
                String var = pro.getValue();
                vbs.add(var.trim());
            }
            return vbs;
        }
        return new ArrayList<String>(0);
    }

    public LegoSnmpVarBind snmpGetNext(String snmpoid) {
        this.init();
        ISnmpResponse snmpRsp = this.snmp.snmpGetNext(snmpoid);
        snmpRsp.setInvokeName("snmpGetNext");
        if (!this.handleErrorStatus(snmpRsp, this.getSnmpTarget()) || this.checkRspVBS(snmpRsp)) {
            return null;
        }
        LegoSnmpOID legoOid = new LegoSnmpOID(SnmpEnum.SnmpType.STRING, snmpoid);
        LegoSnmpVar legoVar = new LegoSnmpVar(SnmpEnum.SnmpType.getSnmpType(snmpRsp.getVB().get(0).getType()), snmpRsp.getVB().get(0).getValue().trim());
        LegoSnmpVarBind legoVB = new LegoSnmpVarBind(legoOid, legoVar);
        return legoVB;
    }

    public LegoSnmpVarBind[] snmpGetNextList(String[] snmpoids) {
        this.init();
        ISnmpResponse snmpRspd = this.snmp.snmpGetNext(snmpoids);
        snmpRspd.setInvokeName("snmpGetNextList");
        if (!this.handleErrorStatus(snmpRspd, this.getSnmpTarget())) {
            return new LegoSnmpVarBind[0];
        }
        List<Property> prosx = snmpRspd.getVB().getVbs();
        if (null != prosx && !prosx.isEmpty()) {
            ArrayList<LegoSnmpVarBind> vbs = new ArrayList<LegoSnmpVarBind>();
            for (Property pro : prosx) {
                LegoSnmpOID legoOidb = new LegoSnmpOID(SnmpEnum.SnmpType.STRING, pro.getName());
                LegoSnmpVar legoVar = new LegoSnmpVar(SnmpEnum.SnmpType.getSnmpType(pro.getType()), pro.getValue().trim());
                LegoSnmpVarBind legoVBs = new LegoSnmpVarBind(legoOidb, legoVar);
                vbs.add(legoVBs);
            }
            LegoSnmpVarBind[] result = vbs.toArray(new LegoSnmpVarBind[vbs.size()]);
            return result;
        }
        return new LegoSnmpVarBind[0];
    }

    public LegoSnmpVarBind[][] snmpGetTableByGetNext(String[] snmpoids) {
        this.init();
        ISnmpTableResponse resp = this.snmp.getTableByGetNext(snmpoids);
        return this.generateTableArray(resp);
    }

    public LegoSnmpVarBind[][] snmpGetTable(String[] snmpoids) {
        this.init();
        ISnmpTableResponse resp = this.snmp.getTable(snmpoids);
        return this.generateTableArray(resp);
    }

    public LegoSnmpVarBind[][] snmpGetTable(int timeout, String[] snmpoids) {
        this.init();
        ISnmpTableResponse resp = this.snmp.getTable(timeout, snmpoids);
        return this.generateTableArray(resp);
    }

    private LegoSnmpVarBind[][] generateTableArray(ISnmpTableResponse resp) {
        if (resp == null) {
            return new LegoSnmpVarBind[0][];
        }
        resp.setInvokeName("snmpGetTable");
        if (!this.handleErrorStatus(resp, this.getSnmpTarget())) {
            return new LegoSnmpVarBind[0][];
        }
        List<List<Property>> rawData = resp.getRawData();
        if (null != rawData && !rawData.isEmpty()) {
            LegoSnmpVarBind[][] result = new LegoSnmpVarBind[rawData.size()][];
            this.fetchRawData(rawData, result);
            return result;
        }
        return new LegoSnmpVarBind[0][0];
    }

    private void fetchRawData(List<List<Property>> rawData, LegoSnmpVarBind[][] result) {
        int i = 0;
        for (List<Property> list : rawData) {
            if (list == null || list.isEmpty()) continue;
            LegoSnmpVarBind[] tmpres = new LegoSnmpVarBind[list.size()];
            int j = 0;
            for (Property property : list) {
                LegoSnmpVarBind legoVB;
                LegoSnmpOID legoOid = new LegoSnmpOID(SnmpEnum.SnmpType.STRING, property.getName());
                LegoSnmpVar legoVar = new LegoSnmpVar(SnmpEnum.SnmpType.getSnmpType(property.getType()), property.getValue());
                tmpres[j] = legoVB = new LegoSnmpVarBind(legoOid, legoVar);
                ++j;
            }
            result[i] = tmpres;
            ++i;
        }
    }

    public List<List<String>> snmpGetTableList(String[] snmpoids) {
        this.init();
        ISnmpTableResponse resp = this.snmp.getTable(snmpoids);
        if (resp == null) {
            return new ArrayList<List<String>>(0);
        }
        resp.setInvokeName("snmpGetTableList");
        if (!this.handleErrorStatus(resp, this.getSnmpTarget())) {
            return new ArrayList<List<String>>(0);
        }
        return resp.getTableData();
    }

    public List<List<String>> snmpGetTableListForSDM(String[] snmpoids) {
        this.init();
        ISnmpTableResponse resp = this.snmp.getTable(snmpoids);
        if (resp == null) {
            return new ArrayList<List<String>>();
        }
        resp.setInvokeName("snmpGetTableListForSDM");
        List<List<Property>> raws = resp.getRawData();
        if (raws == null || raws.isEmpty() || raws.size() == 1) {
            return resp.getTableData();
        }
        List<String> oidLists = resp.getOidList();
        String[] oidA = new String[oidLists.size()];
        HashMap<String, Integer> oOidMap = new HashMap<String, Integer>();
        this.setOidMaps(oidLists, oidA, oOidMap);
        HashMap<String, Property> noTableNode = new HashMap<String, Property>();
        ArrayList<List<Property>> tmpResultList = new ArrayList<List<Property>>();
        HashSet<Integer> nullColNum = new HashSet<Integer>();
        this.traversalTable(raws, oidLists, oOidMap, tmpResultList);
        boolean isCompositeQuery = false;
        isCompositeQuery = this.isCompositeQuery(tmpResultList, nullColNum, noTableNode);
        if (isCompositeQuery && raws.size() != 1) {
            resp.getRawData().clear();
            ArrayList<List<String>> results = new ArrayList<List<String>>();
            for (int i = 1; i < tmpResultList.size(); ++i) {
                List tmpRow = (List)tmpResultList.get(i);
                this.addResultRows(resp, oidA, noTableNode, nullColNum, results, tmpRow);
            }
            resp.setTableData(results);
        }
        if (!this.handleErrorStatus(resp, this.getSnmpTarget())) {
            return new ArrayList<List<String>>(0);
        }
        return resp.getTableData();
    }

    private void setOidMaps(List<String> oidLists, String[] oidA, Map<String, Integer> oOidMap) {
        int index = 0;
        Iterator<String> iterator = oidLists.iterator();
        while (iterator.hasNext()) {
            String string;
            String oid = string = iterator.next();
            if (string.startsWith(".")) {
                oid = oid.substring(string.indexOf(".") + 1);
                oOidMap.put(oid, index);
            }
            oidA[index] = oid;
            ++index;
        }
    }

    private void addResultRows(ISnmpTableResponse resp, String[] oidA, Map<String, Property> noTableNode, Set<Integer> nullColNum, List<List<String>> results, List<Property> tmpRow) {
        ArrayList<String> row = new ArrayList<String>();
        ArrayList<Property> rawRow = new ArrayList<Property>();
        int col = 0;
        for (Property pro : tmpRow) {
            if (null == pro && !nullColNum.contains(col) && noTableNode.get(oidA[col]) != null) {
                row.add(noTableNode.get(oidA[col]).getValue());
                noTableNode.get(oidA[col]).setName(noTableNode.get(oidA[col]).getName() + "." + noTableNode.get(oidA[col]).getIndex());
                rawRow.add(noTableNode.get(oidA[col]));
            } else if (nullColNum.contains(col)) {
                row.add("");
            } else if (null != pro) {
                row.add(pro.getValue());
                pro.setName(pro.getName() + "." + pro.getIndex());
                rawRow.add(pro);
            }
            ++col;
        }
        results.add(row);
        ((TableResponse)resp).addRawRow(rawRow);
    }

    private void traversalTable(List<List<Property>> raws, List<String> oidLists, Map<String, Integer> oOidMap, List<List<Property>> tmpResultList) {
        for (List<Property> list : raws) {
            Property[] rows = new Property[oidLists.size()];
            for (Property property : list) {
                if (this.setRows(property, oOidMap, rows)) continue;
            }
            tmpResultList.add(Arrays.asList(rows));
        }
    }

    private boolean setRows(Property property, Map<String, Integer> oOidMap, Property[] rows) {
        if (null == property) {
            return false;
        }
        String oid = property.getName();
        String var = property.getValue();
        String oidIndex = property.getIndex();
        if (oid == null) {
            return false;
        }
        if (oid.startsWith(".")) {
            oid = oid.substring(oid.indexOf(".") + 1);
        }
        if (oid.indexOf(oidIndex) != -1) {
            oid = oid.substring(0, oid.lastIndexOf(oidIndex) - 1);
        }
        Property pro = new Property(oid, var, property.getType(), oidIndex);
        if (oOidMap.containsKey(oid)) {
            rows[oOidMap.get((Object)oid).intValue()] = pro;
        }
        return true;
    }

    private boolean isCompositeQuery(List<List<Property>> tmpResultList, Set<Integer> nullColNum, Map<String, Property> noTableNode) {
        int i;
        boolean isCompositeQuery = false;
        this.recordNullColumn(tmpResultList, nullColNum);
        block0: for (i = 0; i < tmpResultList.get(0).size(); ++i) {
            for (int j = 0; j < tmpResultList.size(); ++j) {
                if (tmpResultList.get(j).get(i) != null || nullColNum.contains(i)) continue;
                isCompositeQuery = true;
                continue block0;
            }
        }
        if (isCompositeQuery) {
            for (i = 0; i < tmpResultList.get(0).size(); ++i) {
                if (tmpResultList.get(0).get(i) == null) continue;
                String oid = tmpResultList.get(0).get(i).getName();
                noTableNode.put(oid, tmpResultList.get(0).get(i));
            }
        }
        return isCompositeQuery;
    }

    private void recordNullColumn(List<List<Property>> tmpResultList, Set<Integer> nullColNum) {
        for (int i = 0; i < tmpResultList.get(0).size(); ++i) {
            boolean isNullCol = true;
            for (int j = 0; j < tmpResultList.size(); ++j) {
                if (tmpResultList.get(j).get(i) == null) continue;
                isNullCol = false;
                break;
            }
            if (!isNullCol) continue;
            nullColNum.add(i);
        }
    }

    public boolean snmpSet(String snmpoid, String snmpvar, SnmpEnum.SnmpType snmpType) {
        this.init();
        ISnmpResponse res = this.snmp.set(snmpoid, snmpvar, snmpType.getValue());
        res.setInvokeName("snmpSet");
        return this.handleErrorStatus(res, this.getSnmpTarget());
    }

    public boolean snmpSetList(String[] snmpoids, String[] snmpvars, SnmpEnum.SnmpType[] snmpTypes) {
        boolean check = this.checkParams(snmpoids, snmpvars, snmpTypes);
        if (!check) {
            return false;
        }
        this.init();
        int index = 0;
        for (String oid : snmpoids) {
            if (oid == null) {
                this.logger.error((Object)"OID is null", 200L);
                continue;
            }
            try {
                if (!this.snmpSet(oid, snmpvars[index], snmpTypes[index])) {
                    return false;
                }
            }
            catch (Exception ex) {
                this.logger.error((Object)("snmpSetList error,oid:" + oid + ExceptionUtil.getErrorMessage(ex)), 200L);
                return false;
            }
            ++index;
        }
        return true;
    }

    private boolean checkParams(String[] snmpoids, String[] snmpvars, SnmpEnum.SnmpType[] snmpTypes) {
        if (null == snmpoids || null == snmpvars || null == snmpTypes) {
            this.logger.error((Object)"snmpSetList error the param is null", 200L);
            return false;
        }
        if (snmpoids.length != snmpvars.length || snmpvars.length != snmpTypes.length) {
            this.logger.error((Object)"snmpSetList error the param is empty", 200L);
            return false;
        }
        return true;
    }

    public boolean snmpSetBatchList(String[] snmpoids, String[] snmpvars, SnmpEnum.SnmpType[] snmpTypes) {
        boolean check = this.checkParams(snmpoids, snmpvars, snmpTypes);
        if (!check) {
            return false;
        }
        this.init();
        int index = 0;
        VBPro vbp = new VBPro();
        for (String oid : snmpoids) {
            if (oid == null) {
                this.logger.error((Object)"OID is null", 200L);
                continue;
            }
            vbp.add(oid, snmpvars[index], snmpTypes[index].getValue());
            ++index;
        }
        try {
            ISnmpResponse res = this.snmp.set(vbp);
            res.setInvokeName("snmpSet");
            if (!this.handleErrorStatus(res, this.getSnmpTarget())) {
                return false;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("snmpSetBatchList error,oid:" + Arrays.asList(snmpoids) + ExceptionUtil.getErrorMessage(ex)), 200L);
            return false;
        }
        return true;
    }

    public void snmpSetBatchListOfException(String[] snmpoids, String[] snmpvars, SnmpEnum.SnmpType[] snmpTypes) {
        if (null == snmpoids || null == snmpvars || null == snmpTypes) {
            this.logger.error((Object)"snmpSetList error the param is null", 200L);
            throw new LegoCheckedException(132431L);
        }
        if (snmpoids.length != snmpvars.length || snmpvars.length != snmpTypes.length) {
            this.logger.error((Object)"snmpSetList error the param is empty", 200L);
            throw new LegoCheckedException(132431L);
        }
        this.init();
        int index = 0;
        VBPro vbp = new VBPro();
        for (String oid : snmpoids) {
            if (oid == null) {
                this.logger.error((Object)"OID is null", 200L);
                continue;
            }
            vbp.add(oid, snmpvars[index], snmpTypes[index].getValue());
            ++index;
        }
        ISnmpResponse res = this.snmp.set(vbp);
        res.setInvokeName("snmpSet");
        if (!this.handleErrorStatus(res, this.getSnmpTarget())) {
            this.logger.error((Object)("snmp operation failed, ErrorCode: " + this.getErrorCode()), 200L);
            throw new SnmpException((long)this.getErrorCode(), "snmp operation failed, ErrorCode: " + this.getErrorCode());
        }
    }

    public List<List<Property>> snmpGetRawTable(String[] oids) {
        this.init();
        ISnmpTableResponse resp = this.snmp.getTable(oids);
        if (resp != null) {
            resp.setInvokeName("snmpGetRawTable");
            if (!this.handleErrorStatus(resp, this.getSnmpTarget())) {
                return new ArrayList<List<Property>>(0);
            }
            return resp.getRawData();
        }
        return new ArrayList<List<Property>>(0);
    }

    public void snmpSendTrap(String trapIp, int trapPort, long sysUptime, String trapOid, String[] snmpoids, String[] values) {
        try {
            this.snmp.sendSnmpV2Trap(trapIp, trapPort, sysUptime, trapOid, snmpoids, values);
        }
        catch (Exception e) {
            throw new SnmpException("Send SNMP v2c&v3 Trap error.", (Throwable)e);
        }
    }

    public void snmpSendV3Trap(String trapIp, int trapPort, long sysUptime, String trapOid, String[] snmpoids, String[] values) {
        if (this.getSnmpVersion() != SnmpEnum.SnmpVersion.VERSION3) {
            throw new SnmpException("Send SNMP v3 Trap error, the version is not v3.");
        }
        this.initV3Trap();
        try {
            this.snmp.sendSnmpV3Trap(trapIp, trapPort, sysUptime, trapOid, snmpoids, values);
        }
        catch (Exception e) {
            throw new SnmpException("Send SNMP v2c&v3 Trap error.", (Throwable)e);
        }
    }

    private void initV3Trap() {
        this.snmp.set(this.getTimeout(), this.getRetries());
        if (this.getSnmpVersion() != SnmpEnum.SnmpVersion.VERSION3) {
            this.logger.error((Object)"version is error ,now reset the version!", 200L);
            this.setSnmpVersion(SnmpEnum.SnmpVersion.VERSION3);
        }
        SnmpTarget target = this.getSnmpTarget();
        String engineID = null;
        if (target.getEngineID() != null) {
            engineID = new String(target.getEngineID(), Charset.defaultCharset());
        }
        SnmpProtocolParam param = new SnmpProtocolParam();
        param.setAuthProtocol(target.getAuthProtocol());
        param.setAuthPasshrase(target.getAuthPassword());
        param.setPrivProtocol(target.getPrivProtocol());
        param.setPrivPassphrase(target.getPrivPassword());
        this.snmp.initSnmp4jTarget(target.getTargetHost(), target.getTargetPort(), new String[]{target.getPrincipal(), target.getContextName(), engineID}, param);
    }

    public void releaseResources() {
        this.snmp.releaseResources();
    }

    public void checkSnmpErrorCode() {
        if (47L == (long)this.getErrorCode()) {
            this.logger.error((Object)("snmp time out:" + this.getTargetHost() + 47L), 200L);
            throw new LegoCheckedException(47L);
        }
        if (0 != this.getErrorCode()) {
            this.logger.error((Object)("snmp error:" + this.getTargetHost() + ", errorCode:" + this.getErrorCode()), 200L);
            throw new LegoCheckedException(132431L);
        }
    }

    private void init() {
        if (this.snmp.isConnected()) {
            return;
        }
        this.snmp.set(this.getTimeout(), this.getRetries());
        if (this.getSnmpVersion() == SnmpEnum.SnmpVersion.VERSION3) {
            this.createV3Table();
            return;
        }
        this.createV2();
    }

    public int createV3Table() {
        SnmpTarget target = this.getSnmpTarget();
        SnmpProtocolParam param = new SnmpProtocolParam();
        param.setAuthProtocol(target.getAuthProtocol());
        param.setAuthPasshrase(target.getAuthPassword());
        param.setPrivProtocol(target.getPrivProtocol());
        param.setPrivPassphrase(target.getPrivPassword());
        this.snmp.open(target.getTargetHost(), target.getTargetPort(), new String[]{target.getPrincipal(), target.getContextName(), null}, param);
        return 0;
    }

    private void createV2() {
        SnmpTarget target = this.getSnmpTarget();
        this.snmp.open(target.getTargetHost(), target.getTargetPort(), target.getCommunity(), target.getWriteCommunity(), target.getSnmpVersion());
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    public void removeUsmUser(String userName, String engineID) {
        if (userName == null || engineID == null) {
            throw new LegoCheckedException("Wrong params");
        }
        int num = this.snmp.removeUsmUser(userName, engineID);
        this.logger.debug((Object)("removeUsmUser rm num is " + num), 200L);
    }
}

