/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.com.south.snmp.api;

import com.huawei.lego.com.south.snmp.abs.Interpreter;
import com.huawei.lego.com.south.snmp.api.interps.IfAdminStatusInterpreter;
import com.huawei.lego.com.south.snmp.api.interps.IfOperStatusInterpreter;
import com.huawei.lego.com.south.snmp.api.interps.IfTypeInterpreter;
import java.util.HashMap;
import java.util.Map;
import org.snmp4j.smi.OID;

public final class InterpreterSystem {
    private static InterpreterSystem instance = new InterpreterSystem();
    private static Map<OID, Interpreter> interps = new HashMap<OID, Interpreter>();

    private InterpreterSystem() {
    }

    public static InterpreterSystem getInstance() {
        return instance;
    }

    public synchronized boolean contains(OID oid) {
        return interps.containsKey(oid);
    }

    public synchronized Interpreter get(OID oid) {
        return interps.get(oid);
    }

    public synchronized void regist(String oid, Interpreter interp) {
        this.regist(new OID(oid), interp);
    }

    public synchronized void regist(OID oid, Interpreter interp) {
        if (!interps.containsKey(oid)) {
            interps.put(oid, interp);
            return;
        }
    }

    public void unregist(String oid) {
    }

    static {
        IfTypeInterpreter iftype = new IfTypeInterpreter();
        instance.regist(iftype.getId(), (Interpreter)iftype);
        IfAdminStatusInterpreter admins = new IfAdminStatusInterpreter();
        instance.regist(admins.getId(), (Interpreter)admins);
        IfOperStatusInterpreter opers = new IfOperStatusInterpreter();
        instance.regist(opers.getId(), (Interpreter)opers);
    }
}

