/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.base;

import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.base.Registry;
import com.huawei.lego.core.sdk.base.event.EventTrigger;
import com.huawei.lego.core.sdk.base.event.ServiceStatusChangedListener;
import com.huawei.lego.core.sdk.base.event.StatusChangedListener;
import com.huawei.lego.core.sdk.base.model.ServiceInfo;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.base.structure.AbsApplication;
import com.huawei.lego.core.sdk.base.structure.IApplication;
import com.huawei.lego.core.sdk.base.structure.ICallback;
import com.huawei.lego.core.sdk.base.structure.ILifecycle;
import com.huawei.lego.core.sdk.base.structure.IService;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;

public abstract class BaseService
implements IService,
InitializingBean,
ILifecycle {
    private IApplication container;
    private ServiceInfo srvInfor;
    private Log log = LogFactory.getInstance(BaseService.class);
    private User user;
    private Locale locale;
    private Map ctxInfor;
    private List<StatusChangedListener> listeners = new ArrayList<StatusChangedListener>();
    private Status status;
    private List<Registry> registries;

    public boolean isLegal(User userParam) {
        this.user = userParam;
        return true;
    }

    public void setRegistries(List<Registry> registries) {
        this.registries = registries;
    }

    public List<Registry> getRegistries() {
        return this.registries;
    }

    public void setContext(Map context) {
        this.ctxInfor = context;
        Object obj = this.ctxInfor.get("key.context.user");
        if (obj != null) {
            this.user = (User)obj;
        }
        if ((obj = this.ctxInfor.get("key.context.localize")) != null) {
            this.locale = (Locale)obj;
        }
    }

    public Map getContext() {
        return this.ctxInfor;
    }

    @Override
    public IApplication getContainer() {
        return this.container;
    }

    @Override
    public ServiceInfo getInfor() {
        return this.srvInfor;
    }

    @Override
    public void setContainer(IApplication container) {
        this.container = container;
    }

    @Override
    public void setServiceInfor(ServiceInfo srvInforParam) {
        this.srvInfor = srvInforParam;
    }

    public void afterPropertiesSet() {
    }

    public void bindToApplication() {
        if (this.container != null) {
            ((AbsApplication)this.container).addService(this);
        } else {
            this.log.error((Object)(this.getClass().getName() + " does not set the application container,check the spring dm configuration!"), (Throwable)null, 0L);
        }
    }

    @Override
    public void addStatusChangeListener(EventListener listener) {
        if (listener instanceof ServiceStatusChangedListener) {
            this.listeners.add((ServiceStatusChangedListener)listener);
        } else {
            this.log.error("listener is not the instance of ServiceStatusChangedListener!");
        }
    }

    @Override
    public Status getCurrentStatus() {
        return this.status;
    }

    @Override
    public List<?> getStatusChangeLiserners() {
        return this.listeners;
    }

    @Override
    public void remStatusChangeListener(EventListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setCurrentStatus(Status statu) {
        this.status = statu;
    }

    @Override
    @Deprecated
    public void initialize(ICallback[] callback) {
        for (ICallback call : callback) {
            call.invoke(this);
        }
        EventTrigger.fireEventListener(this, this.listeners, Status.STATUS_INIT);
    }

    @Override
    public void start(List<ICallback> callback) {
        for (ICallback call : callback) {
            call.invoke(this);
        }
        EventTrigger.fireEventListener(this, this.listeners, Status.STATUS_STARTED);
    }

    @Override
    @Deprecated
    public void stop(ICallback[] callback) {
        for (ICallback call : callback) {
            call.invoke(this);
        }
        EventTrigger.fireEventListener(this, this.listeners, Status.STATUS_STOPED);
    }

    @Override
    public void initialize(List<ICallback> callback) {
        for (ICallback call : callback) {
            call.invoke(this);
        }
        EventTrigger.fireEventListener(this, this.listeners, Status.STATUS_INIT);
    }

    @Override
    @Deprecated
    public void start(ICallback[] callback) {
        for (ICallback call : callback) {
            call.invoke(this);
        }
        EventTrigger.fireEventListener(this, this.listeners, Status.STATUS_STARTED);
    }

    @Override
    public void stop(List<ICallback> callback) {
        for (ICallback call : callback) {
            call.invoke(this);
        }
        EventTrigger.fireEventListener(this, this.listeners, Status.STATUS_STOPED);
    }

    public User getUser() {
        return this.user;
    }

    public Locale getLocale() {
        return this.locale;
    }
}

