/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.file.util;

import com.huawei.lego.core.sdk.file.util.FileUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellType;

public class ExcelFileUtil
extends FileUtil {
    public static final int DATA_START_ROW = 3;
    private static final int NUM_2 = 2;
    private static final int COLUMNWIDTH = 8000;
    private Log log = LogFactory.getInstance(ExcelFileUtil.class);
    private HSSFWorkbook workbook = new HSSFWorkbook();
    private FileOutputStream writeFileOut;

    public ExcelFileUtil() {
        this.setStrExtend("xls");
    }

    @Override
    public void writeFile(List<List<String>> dataLst) {
        if (this.getWriteFileName() == null) {
            return;
        }
        try {
            this.writeFileOut = new FileOutputStream(this.getWriteFileName());
        }
        catch (FileNotFoundException e) {
            this.log.error((Object)("file not found" + ExceptionUtil.getErrorMessage(e)), 1L);
            return;
        }
        int num = this.getColTitle().size();
        int rowNum = 0;
        HSSFSheet sheet = this.workbook.createSheet();
        if (null != this.getTitle() && !"".equals(this.getTitle())) {
            HSSFRow rowTitle = sheet.createRow(rowNum);
            HSSFCell cellTitle = rowTitle.createCell((int)((short)(num / 2)));
            cellTitle.setCellType(CellType.STRING);
            cellTitle.setCellValue(this.getTitle());
            ++rowNum;
        }
        HSSFRow rowColUsr = sheet.createRow(rowNum);
        HSSFCell cellUsr = rowColUsr.createCell(0);
        cellUsr.setCellValue(this.getStrUsrName());
        HSSFCell cellTime = rowColUsr.createCell(1);
        cellTime.setCellValue(ExcelFileUtil.getNowTime());
        HSSFRow rowColTitle = sheet.createRow(++rowNum);
        for (int i = 0; i < num; i = (int)((short)(i + 1))) {
            HSSFCell cellColTitle = rowColTitle.createCell(i);
            cellColTitle.setCellType(CellType.STRING);
            cellColTitle.setCellValue(this.getColTitle().get(i));
        }
        HSSFCellStyle styleRed = this.workbook.createCellStyle();
        HSSFCellStyle styleGreen = this.workbook.createCellStyle();
        HSSFFont fontRed = this.workbook.createFont();
        fontRed.setColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
        HSSFFont fontGreen = this.workbook.createFont();
        fontGreen.setColor(HSSFColor.HSSFColorPredefined.GREEN.getIndex());
        styleRed.setFont(fontRed);
        styleGreen.setFont(fontGreen);
        int rowNumOfSheet = ++rowNum;
        for (List<String> lstStr : dataLst) {
            HSSFRow row = sheet.createRow(rowNumOfSheet);
            this.processCell(lstStr, row, sheet);
            ++rowNumOfSheet;
        }
    }

    private void processCell(List<String> lstStr, HSSFRow row, HSSFSheet sheet) {
        for (int cellNumOfRow = 0; cellNumOfRow < lstStr.size(); cellNumOfRow = (int)((short)(cellNumOfRow + 1))) {
            HSSFCell cell = row.createCell(cellNumOfRow);
            cell.setCellType(CellType.STRING);
            sheet.setColumnWidth(cellNumOfRow, 8000);
            if (null != lstStr.get(cellNumOfRow)) {
                cell.setCellValue(lstStr.get(cellNumOfRow));
                continue;
            }
            cell.setCellValue("");
        }
    }

    @Override
    public void closeFile() throws IOException {
        this.workbook.write((OutputStream)this.getWriteFileOut());
        this.getWriteFileOut().flush();
        this.getWriteFileOut().close();
    }

    public FileOutputStream getWriteFileOut() {
        return this.writeFileOut;
    }

    public void setWriteFileOut(FileOutputStream writeFileOut) {
        this.writeFileOut = writeFileOut;
    }

    @Override
    public void writeFile(List<List<String>> dataLst, String detailPath) {
        if (this.getWriteFileName() == null) {
            return;
        }
        try {
            this.writeFileOut = new FileOutputStream(this.getWriteFileName());
        }
        catch (FileNotFoundException e) {
            this.log.error((Object)("file not found" + ExceptionUtil.getErrorMessage(e)), 1L);
            return;
        }
        int num = this.getColTitle().size();
        HSSFSheet sheet = this.workbook.createSheet();
        HSSFRow rowTitle = sheet.createRow(0);
        HSSFCell cellTitle = rowTitle.createCell((int)((short)(num / 2)));
        cellTitle.setCellType(CellType.STRING);
        cellTitle.setCellValue(this.getTitle());
        HSSFRow rowColUsr = sheet.createRow(1);
        HSSFCell cellUsr = rowColUsr.createCell(0);
        cellUsr.setCellValue(this.getStrUsrName());
        HSSFCell cellTime = rowColUsr.createCell(1);
        cellTime.setCellValue(ExcelFileUtil.getNowTime());
        HSSFRow rowColTitle = sheet.createRow(2);
        for (int i = 0; i < num; i = (int)((short)(i + 1))) {
            HSSFCell cellColTitlet = rowColTitle.createCell(i);
            cellColTitlet.setCellType(CellType.STRING);
            cellColTitlet.setCellValue(this.getColTitle().get(i));
        }
        HSSFCellStyle styleReda = this.workbook.createCellStyle();
        HSSFCellStyle styleGreena = this.workbook.createCellStyle();
        HSSFFont fontReds = this.workbook.createFont();
        fontReds.setColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
        HSSFFont fontGreen = this.workbook.createFont();
        fontGreen.setColor(HSSFColor.HSSFColorPredefined.GREEN.getIndex());
        styleReda.setFont(fontReds);
        styleGreena.setFont(fontGreen);
        int rowNumOfSheet = 3;
        for (List<String> lstStrs : dataLst) {
            HSSFRow row = sheet.createRow(rowNumOfSheet);
            this.processCell1(lstStrs, row, sheet, detailPath);
            ++rowNumOfSheet;
        }
    }

    private void processCell1(List<String> lstStrs, HSSFRow row, HSSFSheet sheet, String detailPath) {
        for (int cellNumOfRow = 0; cellNumOfRow < lstStrs.size(); cellNumOfRow = (int)((short)(cellNumOfRow + 1))) {
            HSSFCell cell = row.createCell(cellNumOfRow);
            cell.setCellType(CellType.STRING);
            sheet.setColumnWidth(cellNumOfRow, 8000);
            if (null != lstStrs.get(cellNumOfRow)) {
                cell.setCellValue(lstStrs.get(cellNumOfRow));
            } else {
                cell.setCellValue("");
            }
            String logId = lstStrs.get(lstStrs.size() - 1);
            if (logId == null || cellNumOfRow != lstStrs.size() - 1) continue;
            HSSFCellStyle linkStyle = this.workbook.createCellStyle();
            HSSFFont font = this.workbook.createFont();
            font.setFontName("Arial");
            font.setUnderline((byte)1);
            font.setColor(HSSFColor.HSSFColorPredefined.BLUE.getIndex());
            linkStyle.setFont(font);
            String strVal = "";
            if (null != lstStrs.get(cellNumOfRow)) {
                strVal = lstStrs.get(cellNumOfRow);
            }
            cell.setCellStyle(linkStyle);
            cell.setCellFormula("HYPERLINK(\"" + detailPath + logId + ".txt\",\"" + strVal + "\")");
        }
    }
}

