/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.file.util;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileZip {
    private static Log logger = LogFactory.getInstance(FileZip.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void zip(String inputFilePath, String zipFilePath, String baseName) {
        ZipOutputStream zOut = null;
        try {
            zOut = new ZipOutputStream(new FileOutputStream(new String(zipFilePath.getBytes("gb2312"), "gb2312")));
            logger.debug((Object)"zip-->begin", 200L);
            FileZip.zip(zOut, new File(inputFilePath), baseName);
            logger.debug((Object)"zip-->end", 200L);
            CommonUtil.close(zOut);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"code String with gb2312 failed.", e);
        }
        catch (Exception e2) {
            logger.error((Object)("Exception" + ExceptionUtil.getErrorMessage(e2)), 200L);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            CommonUtil.close(zOut);
        }
        finally {
            CommonUtil.close(zOut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zip(ZipOutputStream zOut, File file, String base) {
        FileInputStream in = null;
        try {
            logger.debug((Object)("zip file-->" + file.getName()), 200L);
            if (file.isDirectory()) {
                File[] listFiles = file.listFiles();
                if (listFiles != null) {
                    zOut.putNextEntry(new ZipEntry(base + "/"));
                    if (base.length() != 0) {
                        base = base + "/";
                    }
                    for (File listFile : listFiles) {
                        FileZip.zip(zOut, listFile, base + listFile.getName());
                    }
                }
            } else {
                int len;
                if ("".equals(base)) {
                    base = file.getName();
                }
                zOut.putNextEntry(new ZipEntry(base));
                in = new FileInputStream(file);
                while ((len = in.read()) != -1) {
                    zOut.write(len);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception" + ExceptionUtil.getErrorMessage(e)), 200L);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)("Exception" + ExceptionUtil.getErrorMessage(e)), 200L);
            }
        }
    }

    public static void deleteFile(File file) {
        if (file.exists()) {
            File[] files;
            if (file.isFile()) {
                Boolean result = file.delete();
                if (!result.booleanValue()) {
                    logger.error((Object)"delete file error", 200L);
                }
            } else if (file.isDirectory() && (files = file.listFiles()) != null) {
                for (int i = 0; i < files.length; ++i) {
                    FileZip.deleteFile(files[i]);
                }
                Boolean result = file.delete();
                if (!result.booleanValue()) {
                    logger.error((Object)"delete file error", 200L);
                }
            }
        } else {
            logger.error((Object)"file is not exist", 200L);
        }
    }
}

