/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.log;

import com.huawei.lego.core.sdk.log.LogUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AsyncAppender;
import org.apache.logging.log4j.core.appender.RollingRandomAccessFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.action.Action;
import org.apache.logging.log4j.core.appender.rolling.action.DeleteAction;
import org.apache.logging.log4j.core.appender.rolling.action.IfAccumulatedFileCount;
import org.apache.logging.log4j.core.appender.rolling.action.IfFileName;
import org.apache.logging.log4j.core.appender.rolling.action.PathCondition;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;

public class DefaultLogConfiguratorParent {
    public static void configurator(String product) {
        String logName = "com.huawei.lego." + product;
        DefaultLogConfiguratorParent.configuratorLogger(product, logName);
    }

    public static void configuratorLogger(String fileName, String logName) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        if (!config.getLoggers().containsKey(logName)) {
            RollingRandomAccessFileAppender appender = DefaultLogConfiguratorParent.getDefaultRollingAppender(fileName, logName, config);
            config.addAppender((Appender)appender);
            AppenderRef ref = AppenderRef.createAppenderRef((String)logName, null, null);
            AppenderRef[] refs = new AppenderRef[]{ref};
            AsyncAppender asyncAppender = AsyncAppender.newBuilder().setAppenderRefs(refs).setName("Async" + logName).setConfiguration(config).build();
            asyncAppender.start();
            LoggerConfig loggerConfig = LoggerConfig.createLogger((boolean)false, (Level)Level.INFO, (String)logName, (String)"true", (AppenderRef[])refs, null, (Configuration)config, null);
            loggerConfig.addAppender((Appender)asyncAppender, Level.DEBUG, null);
            config.addLogger(logName, loggerConfig);
            ctx.updateLoggers();
        }
    }

    private static RollingRandomAccessFileAppender getDefaultRollingAppender(String fileName, String logName, Configuration config) {
        SizeBasedTriggeringPolicy policy = SizeBasedTriggeringPolicy.createPolicy((String)"20M");
        PathCondition[] pathConditions = new PathCondition[]{IfFileName.createNameCondition((String)(LogUtil.getLogFileName(fileName) + "_[0-9]*.log.zip"), null, (PathCondition[])new PathCondition[0]), IfAccumulatedFileCount.createFileCountCondition((int)20, (PathCondition[])new PathCondition[0])};
        DeleteAction action = DeleteAction.createDeleteAction((String)LogUtil.getLogPath(fileName), (boolean)false, (int)1, (boolean)false, null, (PathCondition[])pathConditions, null, (Configuration)config);
        DefaultRolloverStrategy strategy = DefaultRolloverStrategy.newBuilder().withCustomActions(new Action[]{action}).build();
        RollingRandomAccessFileAppender appender = ((RollingRandomAccessFileAppender.Builder)((RollingRandomAccessFileAppender.Builder)((RollingRandomAccessFileAppender.Builder)RollingRandomAccessFileAppender.newBuilder().withName(logName)).withImmediateFlush(false)).withFileName(LogUtil.getLogFile(fileName) + ".log").withFilePattern(LogUtil.getLogFile(fileName) + "_%d{yyyyMMddHHmmss}.log.zip").withStrategy((RolloverStrategy)strategy).withLayout(LogUtil.getDefaultLayout())).withPolicy((TriggeringPolicy)policy).withFilePermissions("rw-r-----").withAdvertise(false).withAppend(LogUtil.isAppend()).build();
        appender.start();
        return appender;
    }
}

