/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.mediation.synchronize.snmp.util;

import com.huawei.lego.com.south.sdk.model.LegoSnmpVar;
import com.huawei.lego.com.south.sdk.model.LegoSnmpVarBind;
import com.huawei.lego.com.south.sdk.model.SnmpEnum;
import com.huawei.lego.com.south.sdk.model.SnmpPara;
import com.huawei.lego.com.south.snmp.SnmpAPI;
import com.huawei.lego.com.south.snmp.abs.SnmpTimeoutPolicy;
import com.huawei.lego.core.sdk.common.ServiceProvider;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.mediation.synchronize.snmp.model.SnmpSynchronizeParameter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class SnmpSynchronizeUtil {
    public static final SnmpTimeoutPolicy TIME_OUT_POLICY = new SnmpTimeoutPolicy();
    public static final String SNMP_ERROR_PREFIX = "snmp request failed. oid is : ";
    private static final Log LOGGER = LogFactory.getInstance(SnmpSynchronizeUtil.class);

    public static SnmpAPI createSnmpTarget(String deviceIp, SnmpPara snmpPara) {
        SnmpAPI snmpAPI = new SnmpAPI(SnmpEnum.SnmpVersion.getSnmpVersion(snmpPara.getVersion()));
        snmpAPI.setTargetHost(deviceIp);
        snmpAPI.setTargetPort(snmpPara.getPort());
        snmpAPI.setTimeout(snmpPara.getTimeout());
        snmpAPI.setRetries(snmpPara.getRetries());
        snmpAPI.setSnmpVersion(SnmpEnum.SnmpVersion.getSnmpVersion(snmpPara.getVersion()));
        if (snmpPara.getVersion() != SnmpEnum.SnmpVersion.VERSION3.getValue()) {
            snmpAPI.setCommunity(snmpPara.getReadComm());
            snmpAPI.setWriteCommunity(snmpPara.getWriteComm());
        } else {
            snmpAPI.setAuthPassword(snmpPara.getAuthPwd());
            snmpAPI.setAuthProtocol(SnmpEnum.AuthProtocol.getAuthProtocol(snmpPara.getAuthProtocolNum()));
            snmpAPI.setPrivPassword(snmpPara.getEncryptPwd());
            snmpAPI.setPrivProtocol(SnmpEnum.PrivProtocol.getPrivProtocol(snmpPara.getEncryptProtocolNum()));
            snmpAPI.setSecurityName(snmpPara.getSecurityName());
            snmpAPI.setContextName(snmpPara.getContextName());
            if (snmpPara.getContextEngineId() != null) {
                snmpAPI.setEngineID(snmpPara.getContextEngineId().getBytes(Charset.defaultCharset()));
            }
        }
        return snmpAPI;
    }

    public static List<String[]> getMibValueFromAgent(List<String> targetOidList, SnmpSynchronizeParameter snmpSynchronizeParameter) {
        LOGGER.info((Object)("input targetOidList is : " + targetOidList), 200L);
        SnmpPara snmpPara = snmpSynchronizeParameter.getSnmpPara();
        if (snmpPara.getVersion() == 3) {
            SnmpPara clonedSnmpPara = snmpPara.clone();
            clonedSnmpPara.setRetries(0);
            clonedSnmpPara.setTimeout(1);
            ServiceProvider.getResourceService().testSnmpPingReachable(snmpSynchronizeParameter.getDeviceIp(), clonedSnmpPara);
        }
        SnmpAPI snmpApi = SnmpSynchronizeUtil.createSnmpTarget(snmpSynchronizeParameter.getDeviceIp(), snmpSynchronizeParameter.getSnmpPara());
        LegoSnmpVarBind[][] snmpGetResult = snmpApi.snmpGetTable(targetOidList.toArray(new String[targetOidList.size()]));
        LinkedList<String[]> snmpResult = new LinkedList<String[]>();
        if (snmpGetResult != null && snmpGetResult.length != 0) {
            for (LegoSnmpVarBind[] line : snmpGetResult) {
                String[] vbs = new String[line.length];
                int index = 0;
                for (LegoSnmpVarBind lsvb : line) {
                    vbs[index] = SnmpSynchronizeUtil.snmpVarToString(lsvb);
                    ++index;
                }
                snmpResult.add(vbs);
            }
        } else {
            LOGGER.warn((Object)("snmpResult is null, targetOidList is : " + targetOidList + ", snmpSynchronizeParameter is : " + snmpSynchronizeParameter), 200L);
        }
        SnmpSynchronizeUtil.buildRow(snmpResult);
        return snmpResult;
    }

    private static void buildRow(List<String[]> snmpResult) {
        for (String[] resultRow : snmpResult) {
            if (resultRow.length < 2) {
                throw new IllegalArgumentException("invalid resultRow length.");
            }
            if (!resultRow[1].startsWith(".")) {
                resultRow[1] = "." + resultRow[1];
            }
            LOGGER.info((Object)("resultRow is : " + Arrays.asList(resultRow)), 200L);
        }
    }

    public static String snmpVarToString(LegoSnmpVarBind varBind) {
        LegoSnmpVar var = varBind.getSnmpvar();
        String val = var.getSnmpval();
        SnmpEnum.SnmpType valType = var.getValtype();
        if (null == val || SnmpEnum.SnmpType.UNKNOWN.equals((Object)valType)) {
            return null;
        }
        return val;
    }
}

