/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.util;

import com.huawei.ism.drm.wcc.util.kmc.KmcInstance;
import com.huawei.kmc.common.AppException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.SHA256Encryptor;
import org.apache.commons.lang3.StringUtils;

public class KmcCompatible {
    private static final Log LOGGER = LogFactory.getInstance(KmcCompatible.class);

    public static boolean isDataSame(String data, String salt, String hashData) {
        if (StringUtils.isNotEmpty((CharSequence)salt)) {
            return StringUtils.equals((CharSequence)hashData, (CharSequence)SHA256Encryptor.encryptWithSalt(data, salt));
        }
        return KmcInstance.verifyPwdEx((String)data, (String)hashData) || KmcInstance.hmacVerify((String)data, (String)hashData);
    }

    public static String getHashData(String data, String salt) {
        if (StringUtils.isNotEmpty((CharSequence)salt)) {
            return SHA256Encryptor.encryptWithSalt(data, salt);
        }
        return KmcInstance.protectPwdEx((String)data);
    }

    public static String decrypt(String cipherData) {
        String result = "";
        try {
            result = KmcInstance.decrypt((String)cipherData);
        }
        catch (AppException e) {
            LOGGER.error("Decrypt failed. Exception:" + e.getMessage());
        }
        return result;
    }
}

