/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.util;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class LegoProperties {
    public static final String KEY_APPMANAGER_SERVER = "base.appmanager_server";
    public static final String KEY_RUNTIME_PATH = "Runtime.path";
    private static final String DEFAULT_PROPERTIES = "default.properties";
    private static final Properties PROPS = new Properties();
    private static Log log = LogFactory.getInstance(LegoProperties.class);

    private static void getConfigFromFile() {
        InputStream is = null;
        try {
            ClassLoader clazzLoader = LegoProperties.class.getClassLoader();
            if (null != clazzLoader) {
                is = clazzLoader.getResourceAsStream(DEFAULT_PROPERTIES);
            }
            if (null != is) {
                PROPS.load(is);
            }
        }
        catch (IOException e) {
            log.error((Object)"read default.properties fail.", (Throwable)e, 0L);
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error((Object)"Close the input stream about default.propertieserror is:", (Throwable)e, 0L);
                }
            }
        }
        Properties sysProps = System.getProperties();
        sysProps.putAll((Map<?, ?>)PROPS);
        System.setProperties(sysProps);
    }

    public static String getProperty(String key, String defaultValue) {
        String value = PROPS.getProperty(key);
        if (null == value || value.length() <= 0) {
            value = defaultValue;
        }
        return value;
    }

    public static int getInt(String key) {
        String value = PROPS.getProperty(key);
        if (null == value || value.length() <= 0) {
            return 0;
        }
        return NumberUtil.convertToInteger(value);
    }

    public static int getPort() {
        return LegoProperties.getInt("base.rmi_port");
    }

    public static int getTrapPort() {
        return LegoProperties.getInt("base.trap_port");
    }

    public static int getTrapListenPort() {
        String osName = System.getProperty("os.name");
        if (null != osName && osName.contains("Windows")) {
            return LegoProperties.getInt("base.windows.trap_listen_port");
        }
        return LegoProperties.getInt("base.trap_listen_port");
    }

    public static String getIPAddress() {
        return PROPS.getProperty(KEY_APPMANAGER_SERVER);
    }

    public static String getHuaweiProxyPassword() {
        return PROPS.getProperty("huaweiCloud.proxy.password");
    }

    public static String getHuaweiProxyUserName() {
        return PROPS.getProperty("huaweiCloud.proxy.userName");
    }

    public static int getRemoteNotifyTrapPort() {
        String osName = System.getProperty("os.name");
        if (null != osName && osName.contains("Windows")) {
            return LegoProperties.getInt("trapport.windows.remoteNotify");
        }
        return LegoProperties.getInt("trapport.remoteNotify");
    }

    public static boolean isInstalledIntegrated() {
        String isInIntegrated = LegoProperties.getProperty("is.integrated.in.iemp", "false");
        return Boolean.valueOf(isInIntegrated);
    }

    public static int getSendAlarmTrapPort() {
        return LegoProperties.getInt("trapport.sendAlarm");
    }

    public static String getStorageFilePath() {
        File storageFilePath;
        File currentfile = new File(".");
        String path = "";
        try {
            path = currentfile.getCanonicalPath();
        }
        catch (IOException e) {
            log.error((Object)"getStorageFilePath getCanonicalPath() error!", 102L);
        }
        String defaultPath = path + File.separator;
        String value = "";
        String osName = System.getProperty("os.name");
        if (null == osName) {
            return defaultPath;
        }
        String os = osName.toLowerCase(Locale.getDefault());
        if (os.startsWith("win")) {
            value = PROPS.getProperty("storage.file.windows.path");
            if (null == value || value.length() <= 0) {
                return defaultPath;
            }
            String replace = "\\" + File.separator;
            value = value.replaceAll("/", replace);
        } else if (os.startsWith("linux") && (null == (value = PROPS.getProperty("storage.file.linux.path")) || value.length() <= 0)) {
            return defaultPath;
        }
        if (!value.endsWith(File.separator)) {
            value = value + File.separator;
        }
        if (!(storageFilePath = new File(value)).exists()) {
            return defaultPath;
        }
        return value;
    }

    static {
        LegoProperties.getConfigFromFile();
    }
}

