/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.util;

import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class SHA256Encryptor {
    private static final int SALT_BYTE_SIZE = 16;
    private static final int HASH_BYTE_SIZE = 256;
    private static final int ITERATIONS = 50000;
    private static final String PBKDF2_ALGORITHM = "PBKDF2WithHmacSHA256";
    private static final Log log = LogFactory.getInstance(SHA256Encryptor.class);

    public static String getSalt() {
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            byte[] salt = new byte[16];
            random.nextBytes(salt);
            return Arrays.toString(salt);
        }
        catch (Exception e) {
            log.error("get salt failed");
            throw new LegoUncheckedException(e);
        }
    }

    public static String encryptWithSalt(String password, String salt) {
        String enCode = "";
        if (VerifyUtil.isEmpty(salt)) {
            log.error("the salt is null, encrypt failed.");
            return enCode;
        }
        try {
            enCode = SHA256Encryptor.getHashCode(password.toCharArray(), salt.getBytes(Charset.defaultCharset()));
        }
        catch (Exception e) {
            log.error("encryptWithSalt failed: " + ExceptionUtil.getErrorMessage(e));
        }
        return enCode;
    }

    private static String getHashCode(char[] password, byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PBEKeySpec spec = new PBEKeySpec(password, salt, 50000, 256);
        SecretKeyFactory skf = SecretKeyFactory.getInstance(PBKDF2_ALGORITHM);
        byte[] hash = skf.generateSecret(spec).getEncoded();
        return Arrays.toString(hash);
    }
}

