/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.util;

import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.file.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextEditor {
    private String pattern;
    private String replace;
    private TextEditor before;
    private Object care;
    private String[] template = null;

    private TextEditor(String[] template) {
        this.template = template;
    }

    private TextEditor(String pattern, String replace) {
        this.pattern = pattern;
        this.replace = replace;
    }

    private TextEditor(String pattern, String replace, TextEditor before) {
        this(TextEditor.format(before, 0, pattern), TextEditor.format(before, 1, replace));
        this.before = before;
        if (before != null) {
            this.template = before.template;
        }
    }

    private static String format(TextEditor editor, int index, String value) {
        if (editor == null) {
            return value;
        }
        String[] formats = editor.template;
        if (formats == null) {
            return value;
        }
        return String.format(formats[index], value);
    }

    public String edit(String text) {
        if (text == null) {
            return null;
        }
        if (this.before != null) {
            text = this.before.edit(text);
        }
        if (this.pattern == null) {
            return text;
        }
        Matcher matcher = Pattern.compile(this.pattern).matcher(text);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(buffer, this.replace);
        }
        return matcher.appendTail(buffer).toString();
    }

    public boolean edit(File file) {
        String text;
        try {
            text = FileUtil.readText(file);
        }
        catch (LegoCheckedException ignore) {
            return false;
        }
        String result = this.edit(text);
        return FileUtil.writeText(file, result);
    }

    public TextEditor care(Object group) {
        if (this.before != null && this.before.care == null) {
            this.before.care(group);
        }
        this.care = group;
        return this;
    }

    public Map<String, String> takeOne(String text, Function<String, String> ... trimmers) {
        Map<String, List<String>> data = this.take(text, trimmers);
        data.entrySet().removeIf(entry -> ((List)entry.getValue()).isEmpty());
        HashMap<String, String> result = new HashMap<String, String>();
        data.forEach((key, value) -> {
            String cfr_ignored_0 = (String)result.put((String)key, (String)value.get(0));
        });
        return result;
    }

    public Map<String, List<String>> take(String text, Function<String, String> ... trimmers) {
        if (this.care == null) {
            return this.take(text, 0, trimmers);
        }
        if (this.care instanceof Number) {
            return this.take(text, ((Number)this.care).intValue(), trimmers);
        }
        return this.take(text, this.care.toString(), trimmers);
    }

    public Map<String, List<String>> take(String text, int group, Function<String, String> ... trimmers) {
        return this.take(text, Matcher::group, group, trimmers);
    }

    public Map<String, List<String>> take(String text, String group, Function<String, String> ... trimmers) {
        return this.take(text, Matcher::group, group, trimmers);
    }

    private <T> Map<String, List<String>> take(String text, BiFunction<Matcher, T, String> getter, T group, Function<String, String> ... trimmers) {
        if (text == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> data = this.before != null ? new HashMap<String, List<String>>(this.before.take(text, getter, group, trimmers)) : new HashMap<String, List<String>>();
        if (this.pattern == null) {
            return data;
        }
        Matcher matcher = Pattern.compile(this.pattern).matcher(text);
        String key = this.pattern;
        for (Function<String, String> trimmer : trimmers) {
            if (trimmer == null) continue;
            key = trimmer.apply(key);
        }
        while (matcher.find()) {
            List items = data.getOrDefault(key, new ArrayList());
            data.put(key, items);
            items.add(getter.apply(matcher, (Matcher)group));
        }
        return data;
    }

    public TextEditor then(String regexp, String replacement) {
        return new TextEditor(regexp, replacement, this);
    }

    public TextEditor then(String regexp, String fmt, String ... args) {
        return this.then(regexp, String.format(fmt, args));
    }

    public static TextEditor use(String pattern, Object replace) {
        return new TextEditor(pattern, replace.toString());
    }

    public static TextEditor use(String pattern, Object fmt, Object ... args) {
        return new TextEditor(pattern, String.format(fmt.toString(), args));
    }

    public static TextEditor template(String pattern, String replace) {
        return new TextEditor(new String[]{pattern, replace});
    }
}

