/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.alarm.auth;

import com.huawei.common.FileUtil;
import com.huawei.dbtool.DataBaseInfo;
import com.huawei.dbtool.WccTool;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.KmcCompatible;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;

public class ChangeAuth {
    private static final String HACONFIG = "/ha/local/conf/ha.properties";
    private static final String USERKEY = "alarm.user";
    private static final String USERPWD = "alarm.password";
    private static final String DBNAME = "LEGO";
    private static final int PASSWORD_ERROR = 2;
    private static final Log logger = LogFactory.getInstance(ChangeAuth.class);

    public static void main(String[] stringArray) {
        try {
            ChangeAuth.checkParam(stringArray);
            Map<String, String> map = System.getenv();
            String string = map.get("ENV_AUTH_PWD");
            ChangeAuth.checkAuthInfo(string);
            ChangeAuth.changeHaAuthInfo(string);
            logger.info((Object)("action: " + stringArray[0] + " exec successful."), "");
            System.exit(0);
        }
        catch (LegoCheckedException legoCheckedException) {
            logger.error((Object)legoCheckedException, "AlarmAction failed.");
            if (legoCheckedException.getErrorCode() == 2L) {
                System.exit(2);
            }
        }
        catch (Exception exception) {
            logger.error((Object)("action: " + stringArray[0] + " exec failed: " + ExceptionUtil.getErrorMessage((Throwable)exception)), "");
        }
        System.exit(1);
    }

    private static void changeHaAuthInfo(String string) {
        String string2 = WccTool.getInstance().encrypt(string);
        FileUtil.modifyConfigFile(ChangeAuth.getHAConfigFile(), USERPWD, string2);
    }

    private static String getHaAlarmAuthUser() {
        File file = new File(ChangeAuth.getHAConfigFile());
        if (!file.exists()) {
            throw new LegoCheckedException("getHaAlarmAuthUser failed.");
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            String string = properties.getProperty(USERKEY);
            return string;
        }
        catch (IOException iOException) {
            logger.error((Object)iOException, "getHaAlarmAuthUser failed.");
            throw new LegoCheckedException("getHaAlarmAuthUser failed.");
        }
        finally {
            if (null != fileInputStream) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    logger.error((Object)iOException, "close fip failed.");
                }
            }
        }
    }

    private static String getHAConfigFile() {
        try {
            String string = new File("../").getCanonicalPath();
            String string2 = string + HACONFIG;
            File file = new File(string2);
            if (!file.exists()) {
                throw new FileNotFoundException("ha config file not found.");
            }
            return string2;
        }
        catch (IOException iOException) {
            throw new LegoCheckedException("getAuthUser failed.", (Throwable)iOException);
        }
    }

    private static void checkParam(String[] stringArray) {
        if (stringArray.length < 2) {
            throw new LegoCheckedException("checkParam failed, len=" + stringArray.length);
        }
        if (!"change".equals(stringArray[0])) {
            throw new LegoCheckedException("checkParam failed, args[0]=" + stringArray[0]);
        }
    }

    private static void checkAuthInfo(String string) {
        User user = new User();
        user.setUserName(ChangeAuth.getHaAlarmAuthUser());
        if (!user.isSyncAdmin()) {
            throw new LegoCheckedException("the user not supported, user: " + user.getUserName());
        }
        Connection connection = ChangeAuth.connectGaussDB(new DataBaseInfo(true), DBNAME);
        String string2 = "select USER_PWD,USER_PWD_SALT from t_user where USER_NAME='" + user.getUserName() + "';";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = ChangeAuth.executeSQLQuery(connection, string2);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string3 = resultSet.getString(1);
                String string4 = resultSet.getString(2);
                if (KmcCompatible.isDataSame((String)string, (String)string4, (String)string3)) continue;
                throw new LegoCheckedException(2L, "new auth is error.");
            }
        }
        catch (LegoCheckedException legoCheckedException) {
            throw legoCheckedException;
        }
        catch (Exception exception) {
            throw new LegoCheckedException("checkAuthInfo failed: " + ExceptionUtil.getErrorMessage((Throwable)exception));
        }
        finally {
            if (null != resultSet) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    logger.error((Object)("close ResultSet failed: " + ExceptionUtil.getErrorMessage((Throwable)sQLException)), "");
                }
            }
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {
                    logger.error((Object)("close PreparedStatement failed: " + ExceptionUtil.getErrorMessage((Throwable)sQLException)), "");
                }
            }
            if (null != connection) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    logger.error((Object)("close Connection failed: " + ExceptionUtil.getErrorMessage((Throwable)sQLException)), "");
                }
            }
        }
    }

    private static Connection connectGaussDB(DataBaseInfo dataBaseInfo, String string) {
        Connection connection = null;
        try {
            String string2 = dataBaseInfo.getDbHost();
            int n = Integer.parseInt(dataBaseInfo.getDbPort());
            String string3 = dataBaseInfo.getDbaUser();
            String string4 = dataBaseInfo.getDbaPwd();
            String string5 = "jdbc:postgresql://" + string2 + ":" + n + "/" + string;
            Class.forName("org.postgresql.Driver");
            connection = DriverManager.getConnection(string5, string3, string4);
        }
        catch (Exception exception) {
            throw new LegoCheckedException("connectGaussDB failed: " + ExceptionUtil.getErrorMessage((Throwable)exception));
        }
        return connection;
    }

    private static PreparedStatement executeSQLQuery(Connection connection, String string) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(string);
        }
        catch (SQLException sQLException) {
            throw new LegoCheckedException("executeQuery failed: " + ExceptionUtil.getErrorMessage((Throwable)sQLException));
        }
        return preparedStatement;
    }
}

