/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.common;

import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;

public class FileUtil {
    private static final Log logger = LogFactory.getInstance(FileUtil.class);

    public static void modifyConfigFile(String string, String string2, String string3) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(string2, string3);
        FileUtil.modifyConfigFile(string, hashMap);
    }

    public static void modifyConfigFile(String string, Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        OutputStreamWriter outputStreamWriter = null;
        InputStreamReader inputStreamReader = null;
        FileOutputStream fileOutputStream = null;
        FileInputStream fileInputStream = null;
        try {
            String string2;
            File file = new File(string);
            if (!file.exists()) {
                throw new FileNotFoundException("can't find the file: " + file.getName());
            }
            fileInputStream = new FileInputStream(string);
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((string2 = FileUtil.getLineFromFile(bufferedReader)) != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    if (!string2.startsWith(entry.getKey())) continue;
                    string2 = entry.getKey() + "=" + entry.getValue();
                }
                stringBuilder.append(string2);
                stringBuilder.append(System.getProperty("line.separator"));
            }
            fileOutputStream = new FileOutputStream(string);
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            bufferedWriter = new BufferedWriter(outputStreamWriter);
            bufferedWriter.write(stringBuilder.toString());
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            try {
                throw new LegoCheckedException("modifyConfigFile failed:" + ExceptionUtil.getErrorMessage((Throwable)iOException));
            }
            catch (Throwable throwable) {
                FileUtil.releaseStream(bufferedReader);
                FileUtil.releaseStream(inputStreamReader);
                FileUtil.releaseStream(fileInputStream);
                FileUtil.releaseStream(bufferedWriter);
                FileUtil.releaseStream(outputStreamWriter);
                FileUtil.releaseStream(fileOutputStream);
                throw throwable;
            }
        }
        FileUtil.releaseStream(bufferedReader);
        FileUtil.releaseStream(inputStreamReader);
        FileUtil.releaseStream(fileInputStream);
        FileUtil.releaseStream(bufferedWriter);
        FileUtil.releaseStream(outputStreamWriter);
        FileUtil.releaseStream(fileOutputStream);
    }

    private static void releaseStream(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                logger.error((Object)"Release Stream is Error:", iOException.getMessage());
            }
        }
    }

    private static String getLineFromFile(BufferedReader bufferedReader) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = bufferedReader.read()) != -1) {
            if (stringBuffer.length() >= 20000) {
                throw new IOException("input too long");
            }
            if (n == 13) {
                n = bufferedReader.read();
                if (n == 10) {
                    return stringBuffer.toString();
                }
                stringBuffer.append('\r');
            }
            if ((char)n != '\n' && (char)n != '\r') {
                stringBuffer.append((char)n);
                continue;
            }
            return stringBuffer.toString();
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString();
        }
        return null;
    }
}

