/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dbtool;

import com.huawei.common.CmdUtil;
import com.huawei.dbtool.ConfigFailoverMode;
import com.huawei.dbtool.DataBaseInfo;
import com.huawei.lego.common.util.SysConfigDataUtil;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class DBTool {
    private static final int EXIT_FAILED = 1;
    private static final int ARGSLEN = 1;
    private static final String GS_CTL = "/usr/local/gaussdb/bin/gs_ctl";
    private static Log logger = LogFactory.getInstance(DBTool.class);

    public static void main(String[] stringArray) {
        int n = 1;
        try {
            Object object;
            if ("configAutoFailover".equals(stringArray[0])) {
                object = new ConfigFailoverMode();
                ((ConfigFailoverMode)object).configAutoFailover(stringArray[1], stringArray[2]);
            }
            if ("backup".equals(stringArray[0])) {
                object = new DataBaseInfo(true);
                SysConfigDataUtil.backupSystemData((String)stringArray[1], (String)((DataBaseInfo)object).getDbaPwd(), (boolean)true);
                System.exit(0);
            }
            if ("queryAutoFailover".equals(stringArray[0])) {
                object = new ConfigFailoverMode();
                ((ConfigFailoverMode)object).queryAutoFailover(stringArray[1]);
                SystemExitUtil.exitOK();
            }
            DBTool.checkParameter(stringArray);
            n = DBTool.operation(new DataBaseInfo(false), stringArray[0]);
        }
        catch (Exception exception) {
            logger.error((Object)("exec cmd failed: " + ExceptionUtil.getErrorMessage((Throwable)exception)), "");
        }
        System.exit(n);
    }

    private static void checkParameter(String[] stringArray) throws IOException {
        File file = new File(GS_CTL);
        if (!file.exists()) {
            throw new FileNotFoundException("Can't find the gs_ctl.");
        }
        if (stringArray.length != 1 || !"query".equals(stringArray[0]) && !"switchover".equals(stringArray[0]) && !"failover".equals(stringArray[0])) {
            logger.error((Object)"parameter error, a operation type is need.", "");
            throw new IOException("checkParameter failed.");
        }
    }

    private static int operation(DataBaseInfo dataBaseInfo, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("sudo -u GaussDB -S ");
        stringBuffer.append(GS_CTL);
        stringBuffer.append(" " + string + " ");
        stringBuffer.append(" -u ");
        stringBuffer.append(dataBaseInfo.getManagerUser());
        stringBuffer.append(" -D ");
        stringBuffer.append(dataBaseInfo.getDbDataPath());
        return CmdUtil.exec(stringBuffer.toString());
    }
}

