/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dbtool;

import com.huawei.dbtool.WccTool;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.File;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class DataBaseInfo {
    private String managerUser;
    private String managerPwd;
    private String dbaUser;
    private String dbaPwd;
    private String dbDataPath;
    private String dbPort;
    private String dbHost;

    public DataBaseInfo(boolean bl) {
        this.getDataBaseInfo(bl);
    }

    private void getDataBaseInfo(boolean bl) {
        String string = "config/system.xml";
        File file = new File(string);
        if (!file.exists()) {
            throw new LegoCheckedException("system.xml not exists.");
        }
        SAXReader sAXReader = new SAXReader();
        try {
            sAXReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            sAXReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            sAXReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            sAXReader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Document document = sAXReader.read(file);
            Element element = (Element)document.selectSingleNode("/install/database");
            if (null != element) {
                this.setDbHost(element.attributeValue("dbhost"));
                this.setDbaUser(element.attributeValue("dbuserName"));
                this.setDbPort(element.attributeValue("dbport"));
                this.setDbDataPath(element.attributeValue("dbfilepath"));
                this.setManagerUser(element.attributeValue("manageruserName"));
                if (bl) {
                    this.setDbaPwd(WccTool.getInstance().decrypt(element.attributeValue("dbpassword")));
                    this.setManagerPwd(WccTool.getInstance().decrypt(element.attributeValue("managerpassword")));
                }
            }
        }
        catch (Exception exception) {
            throw new LegoCheckedException("getDataBaseInfo failed: " + ExceptionUtil.getErrorMessage((Throwable)exception));
        }
    }

    public String getDbHost() {
        return this.dbHost;
    }

    public void setDbHost(String string) {
        this.dbHost = string;
    }

    public String getDbaUser() {
        return this.dbaUser;
    }

    public String getDbaPwd() {
        return this.dbaPwd;
    }

    public void setDbaUser(String string) {
        this.dbaUser = string;
    }

    public void setDbaPwd(String string) {
        this.dbaPwd = string;
    }

    public String getDbPort() {
        return this.dbPort;
    }

    public void setDbPort(String string) {
        this.dbPort = string;
    }

    public String getManagerUser() {
        return this.managerUser;
    }

    public String getManagerPwd() {
        return this.managerPwd;
    }

    public String getDbDataPath() {
        return this.dbDataPath;
    }

    public void setManagerUser(String string) {
        this.managerUser = string;
    }

    public void setManagerPwd(String string) {
        this.managerPwd = string;
    }

    public void setDbDataPath(String string) {
        this.dbDataPath = string;
    }
}

