/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dbtool;

import com.huawei.common.CmdUtil;
import com.huawei.dbtool.WccTool;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;

public class SecurityTool {
    private static final int EXIT_FAILED = 1;
    private static final int EXIT_SUCCESS = 0;
    private static final int ARGS_ENC_LEN = 2;
    private static final int ARGS_CERT_LEN = 3;
    private static final String CMD_ENC_PASSWORD = "enc_pass";
    private static final String CMD_PUB_CERT = "pub_cert";
    private static final Log logger = LogFactory.getInstance(SecurityTool.class);
    private static String installPath = "";

    public static void main(String[] stringArray) {
        int n = 1;
        try {
            SecurityTool.initInstallPath();
            SecurityTool.checkParameter(stringArray);
            if (stringArray[0].equals(CMD_ENC_PASSWORD)) {
                Map<String, String> map = System.getenv();
                n = SecurityTool.encPassword(map.get("ENV_PWD"));
            } else {
                n = SecurityTool.publicDeviceCert(stringArray[1], stringArray[2]);
            }
        }
        catch (Exception exception) {
            logger.error((Object)("exec cmd failed: " + ExceptionUtil.getErrorMessage((Throwable)exception)), "");
        }
        System.exit(n);
    }

    private static void initInstallPath() throws IOException {
        try {
            installPath = new File("../").getCanonicalPath();
        }
        catch (IOException iOException) {
            logger.error((Object)("initInstallPath failed: " + ExceptionUtil.getErrorMessage((Throwable)iOException)), "");
            throw new IOException("initInstallPath failed");
        }
    }

    private static void checkParameter(String[] stringArray) throws IOException {
        if (stringArray.length == 0) {
            logger.error((Object)"parameter error, number of args is zero.", "");
            throw new IOException("checkParameter failed.");
        }
        if (!CMD_ENC_PASSWORD.equals(stringArray[0]) && !CMD_PUB_CERT.equals(stringArray[0])) {
            logger.error((Object)"parameter error, a operation type is need.", "");
            throw new IOException("checkParameter failed.");
        }
        if (CMD_ENC_PASSWORD.equals(stringArray[0]) && stringArray.length != 2 || CMD_PUB_CERT.equals(stringArray[0]) && stringArray.length != 3) {
            logger.error((Object)"parameter error, number of parameter is error.", "");
            throw new IOException("checkParameter failed.");
        }
    }

    private static int encPassword(String string) throws IOException {
        String string2 = WccTool.getInstance().encrypt(string);
        System.out.print(string2);
        return 0;
    }

    private static int publicDeviceCert(String string, String string2) throws IOException {
        boolean bl;
        String string3 = installPath + "/ha/module/hacom/tools/openssl";
        String string4 = installPath + "/tmp/" + string + ".req";
        String string5 = installPath + "/tmp/" + string + ".cert";
        String string6 = installPath + "/LegoRuntime/certs/cacert/cacert.pem";
        String string7 = installPath + "/LegoRuntime/certs/cacert/cakey.pem";
        String string8 = installPath + "/LegoRuntime/certs/cacert/openssl.cnf";
        String string9 = installPath + "/LegoRuntime/certs/cacert/cacert.key";
        boolean bl2 = bl = SecurityTool.checkFileExist(string3) && SecurityTool.checkFileExist(string4) && SecurityTool.checkFileExist(string6) && SecurityTool.checkFileExist(string7) && SecurityTool.checkFileExist(string8) && SecurityTool.checkFileExist(string9);
        if (!bl) {
            return 1;
        }
        String string10 = SecurityTool.readFileContent(string9);
        if (string10 == null) {
            logger.error((Object)"readFileContent failed.", "");
            return 1;
        }
        String string11 = WccTool.getInstance().decrypt(string10);
        if (string11 == null || string11.isEmpty()) {
            logger.error((Object)"decrypt failed.", "");
            return 1;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string3);
        stringBuffer.append(" x509 -req -in ");
        stringBuffer.append(string4);
        stringBuffer.append(" -sha256 -days 3650 -CA ");
        stringBuffer.append(string6);
        stringBuffer.append(" -CAkey ");
        stringBuffer.append(string7);
        stringBuffer.append(" -passin pass:");
        stringBuffer.append(string11);
        stringBuffer.append(" -set_serial ");
        stringBuffer.append(string2);
        stringBuffer.append(" -extensions usr_cert -extfile ");
        stringBuffer.append(string8);
        stringBuffer.append(" -out ");
        stringBuffer.append(string5);
        return CmdUtil.exec(stringBuffer.toString());
    }

    private static boolean checkFileExist(String string) {
        try {
            File file = new File(string);
            if (!file.exists()) {
                logger.error((Object)("file " + string + " not exist."), "");
                return false;
            }
        }
        catch (Exception exception) {
            logger.error((Object)("checkFileExist failed," + ExceptionUtil.getErrorMessage((Throwable)exception)), "");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFileContent(String string) {
        String string2 = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            File file = new File(string);
            if (!file.exists()) {
                logger.error((Object)("file " + string + " not exist."), "");
                String string3 = null;
                return string3;
            }
            inputStreamReader = new InputStreamReader(new FileInputStream(file));
            bufferedReader = new BufferedReader(inputStreamReader);
            string2 = bufferedReader.readLine();
            inputStreamReader.close();
            bufferedReader.close();
        }
        catch (Exception exception) {
            logger.error((Object)("readFileContent failed," + ExceptionUtil.getErrorMessage((Throwable)exception)), "");
            String string4 = null;
            return string4;
        }
        finally {
            if (null != inputStreamReader) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {
                    logger.error((Object)("close reader failed," + ExceptionUtil.getErrorMessage((Throwable)iOException)), "");
                }
            }
            if (null != bufferedReader) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    logger.error((Object)("close reader failed," + ExceptionUtil.getErrorMessage((Throwable)iOException)), "");
                }
            }
        }
        return string2;
    }
}

