/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.ssl;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.LinkedList;
import java.util.Properties;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.postgresql.core.Logger;
import org.postgresql.core.PGStream;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class MakeSSL {
    public static void convert(PGStream stream, Properties info, Logger logger) throws IOException, PSQLException {
        SSLSocketFactory factory;
        logger.debug("converting regular socket connection to ssl");
        String classname = info.getProperty("sslfactory");
        if (classname == null) {
            factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        } else {
            Object[] args = new Object[]{info.getProperty("sslfactoryarg")};
            try {
                Constructor<?> ctor;
                Class<?> factoryClass = Class.forName(classname);
                try {
                    ctor = factoryClass.getConstructor(String.class);
                }
                catch (NoSuchMethodException nsme) {
                    ctor = factoryClass.getConstructor(null);
                    args = null;
                }
                factory = (SSLSocketFactory)ctor.newInstance(args);
            }
            catch (Exception e) {
                throw new PSQLException(GT.tr("The SSLSocketFactory class provided {0} could not be instantiated.", classname), PSQLState.CONNECTION_FAILURE, (Throwable)e);
            }
        }
        SSLSocket newConnection = (SSLSocket)factory.createSocket(stream.getSocket(), stream.getHostSpec().getHost(), stream.getHostSpec().getPort(), true);
        String[] strArray = new String[]{"TLSv1.2"};
        String[] dbSupportedCipher = new String[]{"TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256"};
        String[] jdkSupportedCipher = newConnection.getSupportedCipherSuites();
        String[] ciphersList = MakeSSL.intersect(jdkSupportedCipher, dbSupportedCipher);
        newConnection.setEnabledCipherSuites(ciphersList);
        newConnection.setEnabledProtocols(strArray);
        stream.changeSocket(newConnection);
    }

    public static String[] intersect(String[] arr1, String[] arr2) {
        LinkedList<String> list = new LinkedList<String>();
        String[] result = new String[]{};
        block0: for (int i = 0; i < arr1.length; ++i) {
            for (int j = 0; j < arr2.length; ++j) {
                if (!arr1[i].equals(arr2[j])) continue;
                list.add(arr1[i]);
                continue block0;
            }
        }
        return list.toArray(result);
    }
}

