/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.array;

import com.huawei.ism.array.sdk.model.Controller;
import com.huawei.ism.array.sdk.model.XveLun;
import com.huawei.ism.base.port.sdk.model.ManagementPort;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ArrayDiscoverUtil {
    private static Log logger = LogFactory.getInstance(ArrayDiscoverUtil.class);

    public static void setControllerIp(Map<String, List<ManagementPort>> managePortsMap, Map<String, Controller> controllersIDMap, boolean isIpv4) {
        Set<Map.Entry<String, List<ManagementPort>>> entrys = managePortsMap.entrySet();
        for (Map.Entry<String, List<ManagementPort>> entry : entrys) {
            Controller controller = controllersIDMap.get(entry.getKey());
            List<ManagementPort> ports = entry.getValue();
            if (VerifyUtil.isEmpty(ports) || null == controller) {
                logger.debug((Object)("ports:" + ports));
                continue;
            }
            StringBuilder ipsBuffer = new StringBuilder();
            for (ManagementPort port : ports) {
                String ip = isIpv4 ? port.getIpAddress() : port.getIpv6Address();
                if (ip == null || ip.length() < 1) continue;
                ipsBuffer.append(ip).append(",");
            }
            String ips = "";
            if (ipsBuffer.length() > 0) {
                ips = ipsBuffer.substring(0, ipsBuffer.length() - 1);
            }
            if (isIpv4) {
                controller.setManageIpAddrs(ips);
                continue;
            }
            controller.setIpv6Address(ips);
        }
    }

    public static double getMappedLunCap(List<XveLun> xveLuns) {
        double mappedCap = 0.0;
        if (VerifyUtil.isEmpty(xveLuns)) {
            logger.debug((Object)"xveLuns is null");
            return mappedCap;
        }
        for (XveLun lun : xveLuns) {
            if (!lun.getMapped().booleanValue()) continue;
            mappedCap += lun.getTotalCapacity().doubleValue();
        }
        return mappedCap;
    }

    public static double getTotalLunCap(List<XveLun> xveLuns) {
        double totalCap = 0.0;
        if (VerifyUtil.isEmpty(xveLuns)) {
            logger.debug((Object)"xveLuns is null.");
            return totalCap;
        }
        for (XveLun lun : xveLuns) {
            totalCap += lun.getTotalCapacity().doubleValue();
        }
        return totalCap;
    }
}

