/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.commons;

import com.huawei.ism.cbb.discover.commons.OperationLock;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashMap;
import java.util.Map;

public final class DeviceOperationLock {
    private static Log logger = LogFactory.getInstance(DeviceOperationLock.class);
    private static final Map<String, OperationLock> LOCKMAP = new HashMap<String, OperationLock>();
    private static final long TIME_OUT = 1800000L;

    public static synchronized void clearLock(String deviceId) {
        LOCKMAP.remove(deviceId);
    }

    public static synchronized OperationLock getLock(String deviceId) {
        if (deviceId == null || deviceId.length() < 1) {
            throw new IllegalArgumentException();
        }
        OperationLock lock = LOCKMAP.get(deviceId);
        if (lock == null || DeviceOperationLock.isTimeOut(lock)) {
            lock = new OperationLock();
            LOCKMAP.put(deviceId, lock);
        }
        return lock;
    }

    private static boolean isTimeOut(OperationLock lock) {
        if (lock.getHoldTime() > 0L && System.currentTimeMillis() - lock.getHoldTime() > 1800000L) {
            logger.info((Object)("The operation lock : " + lock + " expired !"), 90160777658391L);
            return true;
        }
        return false;
    }
}

