/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.commons.process;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.cbb.discover.util.DiscoverUtil;
import com.huawei.ism.cbb.discover.util.IpUtil;
import com.huawei.ism.cbb.mediation.status.DefaultOnlineToOfflineStatus;
import com.huawei.ism.cbb.mediation.status.GlobalDeviceStatus;
import com.huawei.ism.cbb.mediation.status.Istatus;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractPingProcessor
implements IProcessor {
    private Log logger = LogFactory.getInstance(AbstractPingProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(AbstractContext context) {
        this.checkPara(context);
        NetworkEntity ne = (NetworkEntity)context.getAttribute("StorageDevice");
        NeMgrProtocolExtend ext = (NeMgrProtocolExtend)context.getAttribute("NeMgrProtocolExtend");
        String sn = ne.getSn();
        String connectedIp = null;
        try {
            connectedIp = this.getCurrentIp(sn);
        }
        catch (Exception ex) {
            this.logger.error((Object)("check current connection status failed, sn=" + sn), (Throwable)ex);
        }
        try {
            if (VerifyUtil.isEmpty((String)connectedIp)) {
                connectedIp = this.reconnect(ne, ext);
            }
        }
        finally {
            if (VerifyUtil.isEmpty((String)connectedIp)) {
                this.processStatus(ne, -1);
            } else {
                this.processStatus(ne, 0);
                this.updateContext(context, ne, connectedIp);
            }
        }
        return true;
    }

    private void updateContext(AbstractContext context, NetworkEntity ne, String connectedIp) {
        ArrayList<String> availableIps = new ArrayList<String>();
        availableIps.add(connectedIp);
        context.setAttribute("AvailableIps", availableIps);
        context.setAttribute("DiscoveryTime", ne.getDiscoveredTime());
    }

    private void checkPara(AbstractContext context) {
        if (null == context) {
            this.logger.error((Object)"context is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        NetworkEntity ne = (NetworkEntity)context.getAttribute("StorageDevice");
        if (null == ne) {
            this.logger.error((Object)"networkEntity is null.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    protected abstract String getCurrentIp(String var1);

    private String reconnect(NetworkEntity ne, NeMgrProtocolExtend info) {
        List<String> ips = IpUtil.getMgrIps(ne);
        this.logger.debug((Object)("management ip info, sn=" + ne.getSn() + ", mgmtIps=" + ips));
        if (VerifyUtil.isEmpty(ips)) {
            this.logger.error((Object)"management ip list is empty.");
            throw new LegoCheckedException(104401L);
        }
        LegoCheckedException resultEx = null;
        for (String ip : ips) {
            try {
                this.logger.debug((Object)("reconnect to ne failed. sn=" + ne.getSn() + ", ip=" + ip));
                this.connect(ne.getSn(), ip, info);
                return ip;
            }
            catch (LegoCheckedException ex) {
                this.logger.error((Object)("reconnect to ne failed. sn=" + ne.getSn() + ", ip=" + ip), (Throwable)ex);
                resultEx = ex;
            }
            catch (Exception ex) {
                this.logger.error((Object)("reconnect to ne failed. sn=" + ne.getSn() + ", ip=" + ip + ExceptionUtil.getErrorMessage((Throwable)ex)));
                resultEx = new LegoCheckedException(104401L, (Throwable)ex);
            }
        }
        if (resultEx != null) {
            throw resultEx;
        }
        throw new LegoCheckedException(2117645L);
    }

    protected abstract void connect(String var1, String var2, NeMgrProtocolExtend var3);

    private void processStatus(NetworkEntity ne, int status) {
        Integer oldStatus = ne.getStatus();
        this.logger.debug((Object)("process status, ne=" + ne + ", oldStaus=" + oldStatus + ", newStatus=" + status));
        if (null != oldStatus && oldStatus == status) {
            return;
        }
        Istatus devStatus = GlobalDeviceStatus.getStatus(ne.getUuid(), DefaultOnlineToOfflineStatus.class);
        devStatus.doAction((ManagedObject)ne, status);
        DiscoverUtil.updateNetworkEntityStatus(ne, status);
    }

    @Override
    public void postProcess(AbstractContext context) {
    }

    @Override
    public void clean(AbstractContext context) {
    }
}

