/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.commons.process;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.DeviceOperationLock;
import com.huawei.ism.cbb.discover.commons.OperationLock;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.FilterChain;
import com.huawei.ism.cbb.discover.framework.IFilter;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.discover.sdk.service.IDiscoveryService;

public class DeviceOperationLockFilter
implements IFilter {
    private Log logger = LogFactory.getInstance((Object)this);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(AbstractContext context, FilterChain chain) {
        NetworkEntity mo;
        this.logger.info((Object)"into DeviceOperationLockFilter doFilter", 90160777658372L);
        NetworkEntity networkEntity = (NetworkEntity)context.getAttribute("StorageDevice");
        if (networkEntity == null) {
            this.logger.error((Object)"Can not get available storage array ! ", 90160777658373L);
            throw new LegoCheckedException(0x200909L);
        }
        Long moid = networkEntity.getMoId();
        String sn = networkEntity.getSn();
        this.logger.info((Object)("into DeviceOperationLockFilter moid=" + moid + "; sn=" + sn), 90160777658372L);
        if (!this.lockLego(moid)) {
            throw new LegoCheckedException(102401L);
        }
        if (!"icommand:action:discovery".equals(context.getAttribute("icommand:action")) && (mo = (NetworkEntity)CommonDAOLocator.getMoDao().getMo(NetworkEntity.class, "sn", (Object)sn)) == null) {
            this.logger.info((Object)"This device is removed ?? ", 90160777658372L);
            this.unLockLego(moid);
            throw new LegoCheckedException(2117645L);
        }
        OperationLock lock = DeviceOperationLock.getLock(sn);
        if (!lock.tryLock()) {
            this.logger.warn((Object)("Someone[" + lock.getOwnerName() + "] is refreshing array : " + networkEntity.getSn()), 90160777658372L);
            this.unLockLego(moid);
            throw new LegoCheckedException(102401L);
        }
        try {
            this.logger.info((Object)("Get array operation lock ... device id :" + networkEntity.getSn()), 90160777658372L);
            chain.doFilter(context);
        }
        finally {
            lock.unTryLock();
            this.logger.info((Object)("Release array operation lock ... device id :" + networkEntity.getSn()), 90160777658373L);
            this.unLockLego(moid);
        }
        this.logger.info((Object)"out DeviceOperationLockFilter doFilter", 90160777658372L);
    }

    private boolean lockLego(Long moid) {
        if (moid == null) {
            return true;
        }
        IDiscoveryService legoService = (IDiscoveryService)ServiceLocator.getInstance().getService(IDiscoveryService.class);
        boolean legoCheck = legoService.isDeviceCanRefresh(moid);
        if (legoCheck) {
            legoService.lockDeviceBeforeRefresh(moid);
            this.logger.info((Object)"Lock lego platform for device refreshing success ", 90160777658372L);
            return true;
        }
        this.logger.info((Object)"Can NOT get lego lock !!!", 90160777658372L);
        return false;
    }

    private void unLockLego(Long moid) {
        if (moid == null) {
            return;
        }
        IDiscoveryService legoService = (IDiscoveryService)ServiceLocator.getInstance().getService(IDiscoveryService.class);
        try {
            legoService.unlockDeviceAfterRefresh(moid);
            this.logger.info((Object)"Released lego device lock", 90160777658372L);
        }
        catch (Exception e) {
            this.logger.error((Object)("Release lego device lock failed " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160777658373L);
        }
    }
}

