/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.commons.process;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.cbb.discover.framework.IProcessorEx;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DiscoverExtendProcessor
implements IProcessor {
    private Map<String, List<IProcessor>> deviceTypeAndProcessorMap = new HashMap<String, List<IProcessor>>();
    private final Log logger = LogFactory.getInstance((Object)this, (String)"UBase/ubase_mediation");

    @Override
    public void clean(AbstractContext context) {
        NetworkEntity networkEntity = (NetworkEntity)context.getAttribute("StorageArray");
        if (null == networkEntity) {
            this.logger.error((Object)"The StorageArray attribute in the context is empty.", 90160777658373L);
            return;
        }
        List<IProcessor> processors = this.getProcessorsByManagementProtocol(networkEntity);
        if (!VerifyUtil.isEmpty(processors)) {
            this.cleanProcess(processors.size() - 1, context, processors);
        }
    }

    @Override
    public String getName() {
        return DiscoverExtendProcessor.class.getName();
    }

    @Override
    public void postProcess(AbstractContext context) {
        NetworkEntity networkEntity = (NetworkEntity)context.getAttribute("StorageArray");
        if (networkEntity == null) {
            this.logger.error((Object)"The StorageArray attribute in the context is empty.", 90160777658373L);
            return;
        }
        List<IProcessor> processors = this.getProcessorsByManagementProtocol(networkEntity);
        if (!VerifyUtil.isEmpty(processors)) {
            this.doPostProcess(processors.size() - 1, context, processors);
        }
    }

    @Override
    public boolean process(AbstractContext context) {
        boolean processResult = true;
        NetworkEntity networkEntity = (NetworkEntity)context.getAttribute("StorageArray");
        this.logger.info((Object)"Enter DiscoverExtendProcessor", 90160777658372L);
        if (networkEntity == null) {
            this.logger.error((Object)"The StorageArray attribute in the context is empty.", 90160777658373L);
            return false;
        }
        List<IProcessor> processors = this.getProcessorsByManagementProtocol(networkEntity);
        if (!VerifyUtil.isEmpty(processors)) {
            processResult = this.callProcessors(context, processors);
        }
        return processResult;
    }

    protected boolean callProcessors(AbstractContext context, List<IProcessor> processors) {
        IProcessor processor = null;
        boolean isNormal = true;
        try {
            int size = processors.size();
            for (int i = 0; i < size; ++i) {
                processor = processors.get(i);
                this.logger.debug((Object)("Processor<" + this.getProcessorInfo(processor) + "> start."));
                if (!processor.process(context)) {
                    this.logger.error((Object)("Processor<" + this.getProcessorInfo(processor) + "> breaks the process ..."));
                    isNormal = false;
                    break;
                }
                this.logger.debug((Object)("Processor<" + this.getProcessorInfo(processor) + "> end."));
            }
        }
        catch (LegoCheckedException ex) {
            this.logger.error((Object)("Exception raised when processing Processor<" + this.getProcessorInfo(processor) + "> "), (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            ExceptionUtil.rethrowException((Throwable)ex, (String)("Exception raised when processing Processor<" + this.getProcessorInfo(processor) + "> "), (long)0x200909L, null, (Log)this.logger);
        }
        return isNormal;
    }

    private String getProcessorInfo(IProcessor processor) {
        if (null == processor) {
            return null;
        }
        return processor.getName();
    }

    protected void cleanProcess(int index, AbstractContext context, List<IProcessor> processors) {
        IProcessor processor = null;
        while (index >= 0) {
            try {
                processor = processors.get(index);
                processor.clean(context);
            }
            catch (Exception e) {
                this.logger.error((Object)("Exception raised when cleaning Processor<" + this.getProcessorInfo(processor) + "> " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160777658373L);
            }
            --index;
        }
    }

    protected boolean doPostProcess(int index, AbstractContext context, List<IProcessor> processors) {
        IProcessor processor = null;
        try {
            if (index == processors.size()) {
                --index;
            }
            while (index >= 0) {
                processor = processors.get(index);
                processor.postProcess(context);
                --index;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Exception raised when post Processor<" + this.getProcessorInfo(processor) + "> " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160777658373L);
            return false;
        }
        return true;
    }

    public void onBind(IProcessorEx processEx, Map<String, String> map) {
        Set<String> protocolTypes = processEx.getSupportedManagementProtocolTypes();
        if (protocolTypes != null) {
            for (String protocolType : protocolTypes) {
                List<IProcessor> processors = this.deviceTypeAndProcessorMap.get(protocolType);
                if (processors == null) {
                    processors = new ArrayList<IProcessor>();
                    this.deviceTypeAndProcessorMap.put(protocolType, processors);
                }
                if (processors.contains(processEx)) continue;
                processors.add(processEx);
            }
        }
    }

    public void onUnbind(IProcessorEx processEx, Map<String, String> map) {
        Set<String> protocolTypes = processEx.getSupportedManagementProtocolTypes();
        if (protocolTypes != null) {
            for (String protocolType : protocolTypes) {
                List<IProcessor> processors = this.deviceTypeAndProcessorMap.get(protocolType);
                if (processors == null) continue;
                processors.remove(processEx);
            }
        }
    }

    protected List<IProcessor> getProcessorsByManagementProtocol(NetworkEntity networkEntity) {
        String managementProtocol = networkEntity.getManagementProtocol();
        if (null == managementProtocol) {
            return null;
        }
        return this.deviceTypeAndProcessorMap.get(managementProtocol);
    }
}

