/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.commons.process;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.poll.IPoller;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.CommonTemplate;
import com.huawei.ism.cbb.discover.framework.CommonTemplateManager;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.cbb.discover.poll.DevicePoller;
import com.huawei.ism.cbb.discover.poll.PingPoller;
import com.huawei.ism.cbb.discover.poll.PollControllerLocator;
import com.huawei.ism.cbb.mediation.status.DefaultOnlineToOfflineStatus;
import com.huawei.ism.cbb.mediation.status.GlobalDeviceStatus;
import com.huawei.ism.cbb.mediation.status.Istatus;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class MiscellaneousArrayProcessor
implements IProcessor {
    private static final int INIT_POLL_DELAY_TIME = 21600;
    private Log logger = LogFactory.getInstance((Object)this);

    @Override
    public void clean(AbstractContext context) {
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void postProcess(AbstractContext context) {
    }

    @Override
    public boolean process(AbstractContext context) {
        CommonTemplate pingTemplate;
        NetworkEntity entity = (NetworkEntity)context.getAttribute("StorageArray");
        if (null == entity) {
            this.logger.error((Object)"StorageArray is not in the context.");
            throw new LegoCheckedException(1073947393L);
        }
        this.logger.info((Object)("Status change, devSn=" + entity.getSn()), 90160777658372L);
        try {
            Istatus devStatus = GlobalDeviceStatus.getStatus(entity.getUuid(), DefaultOnlineToOfflineStatus.class);
            devStatus.doAction((ManagedObject)entity, 0);
        }
        catch (Exception e) {
            this.logger.error((Object)("Status change failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160777658373L);
        }
        String protocol = entity.getManagementProtocol();
        CommonTemplate template = CommonTemplateManager.getInstance().getTemplateByManagementProtocol(protocol, 3);
        if (template != null) {
            PollControllerLocator.getInstance().getPollController().addPoller((IPoller)new DevicePoller(entity.getUuid(), protocol, template), 21600);
        }
        if ((pingTemplate = CommonTemplateManager.getInstance().getTemplateByManagementProtocol(protocol, 4)) != null) {
            PollControllerLocator.getInstance().getPingController().addPoller((IPoller)new PingPoller(entity.getUuid(), protocol, pingTemplate));
        }
        return true;
    }
}

