/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.event.clear;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.proxy.util.OIDUtil;
import com.huawei.ism.cbb.proxy.util.SnmpCommandUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import java.util.LinkedHashMap;
import java.util.Map;

public class EventClearServiceSnmpImpl {
    private static final Log LOGGER = LogFactory.getInstance(EventClearServiceSnmpImpl.class);
    private static final String CLEARENT_USERNAME = "hwIsmEventParameter";
    private static final String CLEARENT_SQUENCE = "hwIsmEventSequence";
    private static final String CLEARENT_ROWSTATUS = "hwIsmEventRowStatus";
    private static final String DELETE_TOWSTATUS = "6";

    public boolean clearAlarm(LegoAlarm legoAlarm, String userName, NetworkEntity netWork, StorageUnit unit) {
        LinkedHashMap<String, Map<String, String>> allConfigDatas = new LinkedHashMap<String, Map<String, String>>();
        allConfigDatas.put(CLEARENT_SQUENCE, OIDUtil.generateOneOIDInfo(CLEARENT_SQUENCE, String.valueOf(legoAlarm.getAlarmSequence())));
        allConfigDatas.put(CLEARENT_USERNAME, OIDUtil.generateOneOIDInfo(CLEARENT_USERNAME, userName));
        allConfigDatas.put(CLEARENT_ROWSTATUS, OIDUtil.generateOneOIDInfo(CLEARENT_ROWSTATUS, DELETE_TOWSTATUS));
        try {
            SnmpCommandUtil.executeSnmpSetCommand("deleteEvent", netWork, allConfigDatas);
        }
        catch (LegoCheckedException e) {
            if (83887401L == e.getErrorCode() || 83887402L == e.getErrorCode() || 83887404L == e.getErrorCode()) {
                return true;
            }
            LOGGER.error((Object)("LegoCheckedException when delete event: " + legoAlarm.getAlarmSequence() + " source: " + legoAlarm.getMoIP()), (Throwable)e, 90160758784533L);
            return false;
        }
        catch (Exception e) {
            LOGGER.error((Object)("delete event fail: " + legoAlarm.getAlarmSequence() + " source: " + legoAlarm.getMoIP()), 90160758784534L);
            return false;
        }
        return true;
    }
}

