/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.framework;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.discover.framework.CommonTemplate;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CommonTemplateManager {
    public static final int DISCOVER_TEMPLATE = 1;
    public static final int REFRESH_TEMPLATE = 2;
    public static final int POLL_TEMPLATE = 3;
    public static final int PING_TEMPLATE = 4;
    private static final CommonTemplateManager INSTANCE = new CommonTemplateManager();
    private static Log logger = LogFactory.getInstance(CommonTemplateManager.class);
    private Map<String, CommonTemplate> deviceTypeAndDiscoverCommonTemplateMap = new HashMap<String, CommonTemplate>();
    private Map<String, CommonTemplate> deviceTypeAndRefreshCommonTemplateMap = new HashMap<String, CommonTemplate>();
    private Map<String, CommonTemplate> deviceTypeAndPollCommonTemplateMap = new HashMap<String, CommonTemplate>();
    private Map<String, CommonTemplate> deviceTypeAndPingCommonTemplateMap = new HashMap<String, CommonTemplate>();

    public static CommonTemplateManager getInstance() {
        return INSTANCE;
    }

    public void setDiscoverCommonTemplates(Set<CommonTemplate> commonTemplates) {
        this.buildCommonTemplatesMap(this.deviceTypeAndDiscoverCommonTemplateMap, commonTemplates);
    }

    public void setRefreshCommonTemplates(Set<CommonTemplate> commonTemplates) {
        this.buildCommonTemplatesMap(this.deviceTypeAndRefreshCommonTemplateMap, commonTemplates);
    }

    public void setPollCommonTemplates(Set<CommonTemplate> commonTemplates) {
        this.buildCommonTemplatesMap(this.deviceTypeAndPollCommonTemplateMap, commonTemplates);
    }

    public void setPingCommonTemplates(Set<CommonTemplate> commonTemplates) {
        this.buildCommonTemplatesMap(this.deviceTypeAndPingCommonTemplateMap, commonTemplates);
    }

    public CommonTemplate getDiscoverTemplateByDeviceType(String deviceType) {
        return this.deviceTypeAndDiscoverCommonTemplateMap.get(deviceType);
    }

    public CommonTemplate getRefreshTemplateByDeviceType(String deviceType) {
        return this.deviceTypeAndRefreshCommonTemplateMap.get(deviceType);
    }

    public CommonTemplate getPollTemplateByDeviceType(String deviceType) {
        return this.deviceTypeAndPollCommonTemplateMap.get(deviceType);
    }

    public CommonTemplate getPingTemplateByDeviceType(String deviceType) {
        return this.deviceTypeAndPingCommonTemplateMap.get(deviceType);
    }

    private void buildCommonTemplatesMap(Map<String, CommonTemplate> deviceTypeAndTemplateMap, Set<CommonTemplate> commonTemplates) {
        if (VerifyUtil.isEmpty(commonTemplates)) {
            return;
        }
        for (CommonTemplate template : commonTemplates) {
            Set<String> deviceTypes = template.getDeviceTypes();
            if (null == deviceTypes) continue;
            for (String deviceType : deviceTypes) {
                deviceTypeAndTemplateMap.put(deviceType, template);
            }
        }
    }

    public CommonTemplate getTemplateByDeviceType(String deviceType, int templateType) {
        CommonTemplate template = null;
        switch (templateType) {
            case 1: {
                template = this.getDiscoverTemplateByDeviceType(deviceType);
                break;
            }
            case 2: {
                template = this.getRefreshTemplateByDeviceType(deviceType);
                break;
            }
            case 3: {
                template = this.getPollTemplateByDeviceType(deviceType);
                break;
            }
            case 4: {
                template = this.getPingTemplateByDeviceType(deviceType);
                break;
            }
        }
        return template;
    }

    public CommonTemplate getTemplateByManagementProtocol(String managementProtocol, int templateType) {
        CommonTemplate template = null;
        switch (templateType) {
            case 1: {
                template = this.getDiscoverTemplateByDeviceType(managementProtocol);
                break;
            }
            case 2: {
                template = this.getRefreshTemplateByDeviceType(managementProtocol);
                break;
            }
            case 3: {
                template = this.getPollTemplateByDeviceType(managementProtocol);
                break;
            }
            case 4: {
                template = this.getPingTemplateByDeviceType(managementProtocol);
                break;
            }
        }
        return template;
    }

    public CommonTemplate getTemplate(NetworkEntity networkEntity, int templateType) {
        if (null == networkEntity) {
            logger.error((Object)"ne is null.", 90160758784000L);
            return null;
        }
        String productModel = networkEntity.getProductModel();
        String protocol = networkEntity.getManagementProtocol();
        logger.info((Object)("into getTemplate, name=" + networkEntity.getName() + ", moid=" + networkEntity.getMoId() + ", sn=" + networkEntity.getSn() + ", productModel=" + productModel + ", protocol=" + protocol), 90160758784000L);
        if (VerifyUtil.isEmpty((String)productModel) && VerifyUtil.isEmpty((String)protocol)) {
            logger.error((Object)"model and protocol info is empty.", 90160758784000L);
            return null;
        }
        CommonTemplate template = this.getTemplateByDeviceType(productModel, templateType);
        if (null == template) {
            logger.info((Object)("query template by protocol: " + protocol), 90160758784000L);
            template = this.getTemplateByManagementProtocol(protocol, templateType);
        }
        logger.info((Object)("out getTemplate, name=" + (null != template ? template.getName() : null)), 90160758784000L);
        return template;
    }
}

