/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.framework;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IFilter;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.backtask.sdk.service.IBackTaskService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import java.util.ArrayList;
import java.util.List;

public final class FilterChain {
    private Log logger = LogFactory.getInstance((Object)this, (String)"UBase/ubase_mediation");
    private List<IFilter> filters = new ArrayList<IFilter>();
    private List<IProcessor> processors = new ArrayList<IProcessor>();
    private int index = 0;
    private boolean result;
    private BackTask backTask;

    FilterChain(List<IFilter> filters, List<IProcessor> processors) {
        if (filters != null) {
            this.filters.addAll(filters);
        }
        if (processors != null) {
            this.processors.addAll(processors);
        }
    }

    public void doFilter(AbstractContext context) {
        this.initTask(context);
        if (this.index < this.filters.size()) {
            IFilter filter = this.filters.get(this.index++);
            this.logger.debug((Object)("Filter<" + filter.getName() + "> begin ..."));
            filter.doFilter(context, this);
            this.logger.debug((Object)("Filter<" + filter.getName() + "> end ..."));
        } else {
            this.result = this.callProcessors(context);
        }
    }

    boolean isResult() {
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean callProcessors(AbstractContext context) {
        int i;
        IProcessor processor = null;
        boolean isNormal = true;
        try {
            int size = this.processors.size();
            for (i = 0; i < size; ++i) {
                processor = this.processors.get(i);
                this.logger.debug((Object)("Processor<" + this.getProcessorInfo(processor) + "> start ..."));
                if (!processor.process(context)) {
                    this.logger.error((Object)("Processor<" + this.getProcessorInfo(processor) + "> breaks the process ..."));
                    isNormal = false;
                    break;
                }
                this.logger.debug((Object)("Processor<" + this.getProcessorInfo(processor) + "> end ..."));
                this.updateTaskProgress((i + 1) * 90 / size);
            }
        }
        catch (LegoCheckedException ex) {
            this.logger.error((Object)("Exception raised when processing Processor<" + this.getProcessorInfo(processor) + "> "), (Throwable)ex);
            this.cleanProcess(i, context);
            throw ex;
        }
        catch (Exception ex) {
            this.cleanProcess(i, context);
            ExceptionUtil.rethrowException((Throwable)ex, (String)("Exception raised when processing Processor<" + this.getProcessorInfo(processor) + "> "), (long)0x200909L, null, (Log)this.logger);
        }
        finally {
            if (!this.doPostProcess(i, context)) {
                isNormal = false;
            }
        }
        return isNormal;
    }

    private String getProcessorInfo(IProcessor processor) {
        if (null == processor) {
            return null;
        }
        return processor.getName();
    }

    private void cleanProcess(int indexValue, AbstractContext cmd) {
        while (indexValue >= 0) {
            IProcessor processor = this.processors.get(indexValue);
            try {
                processor.clean(cmd);
            }
            catch (Exception e) {
                this.logger.error((Object)("Exception raised when cleaning Processor<" + this.getProcessorInfo(processor) + "> " + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
            --indexValue;
        }
    }

    private boolean doPostProcess(int indexValue, AbstractContext context) {
        IProcessor processor = null;
        try {
            if (indexValue == this.processors.size()) {
                --indexValue;
            }
            while (indexValue >= 0) {
                processor = this.processors.get(indexValue);
                processor.postProcess(context);
                --indexValue;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Exception raised when post Processor<" + this.getProcessorInfo(processor) + "> " + ExceptionUtil.getErrorMessage((Throwable)e)));
            return false;
        }
        return true;
    }

    private void initTask(AbstractContext context) {
        if (null != this.backTask) {
            return;
        }
        Boolean isNeedUpdateTask = context.getAttribute("isNeedUpdateTask", Boolean.class);
        this.logger.debug((Object)("isNeedUpdateTask=" + isNeedUpdateTask));
        if (null != isNeedUpdateTask && !isNeedUpdateTask.booleanValue()) {
            return;
        }
        DiscoveryPolicy policy = context.getAttribute("DiscoveryPolicy", DiscoveryPolicy.class);
        if (null != policy) {
            Object object = policy.getExtendAttributeMap().get("discoveryTask");
            if (!(object instanceof BackTask)) {
                this.logger.error((Object)"discoveryTask is not an instance of class BackTask.class.");
                throw new LegoCheckedException(1073947393L);
            }
            this.backTask = (BackTask)object;
            this.logger.info((Object)("Fetch discoveryTask, " + this.backTask.getTaskId()));
            return;
        }
        AbstractBackTask abstractBackTask = context.getAttribute("refreshTask", AbstractBackTask.class);
        if (null != abstractBackTask) {
            this.backTask = abstractBackTask.getBackTask();
            this.logger.info((Object)("Fetch refreshTask, " + this.backTask.getTaskId()));
            return;
        }
    }

    private void updateTaskProgress(int progress) {
        if (null != this.backTask && progress > this.backTask.getTaskProgress()) {
            IBackTaskService backTaskService = BackTaskHandler.getInstance().getBackTaskService();
            backTaskService.updateTask(this.backTask.getTaskId().longValue(), progress);
            this.logger.info((Object)("Update backTask progress, taskId=" + this.backTask.getTaskId() + ", progress=" + progress));
        }
    }
}

