/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.poll;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.poll.IPollInitializer;
import com.huawei.ism.cbb.base.poll.IPoller;
import com.huawei.ism.cbb.base.poll.PollController;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.framework.CommonTemplate;
import com.huawei.ism.cbb.discover.framework.CommonTemplateManager;
import com.huawei.ism.cbb.discover.poll.DevicePoller;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.base.persistance.HibernateUtil;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.nem.discover.sdk.service.IDiscoveryService;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;

public final class DevicePollInitializer
implements IPollInitializer,
SystemStatusChangedListener {
    private Log logger = LogFactory.getInstance((Object)this);
    private IMoDao moDao;
    private PollController pollController;

    public DevicePollInitializer(IMoDao moDao, PollController pc) {
        this.moDao = moDao;
        this.pollController = pc;
    }

    public void initPoller() {
        this.logger.info((Object)"Initialize device poller ...", 90160777658624L);
        List networkEntitys = this.moDao.getAllMo(NetworkEntity.class);
        for (NetworkEntity networkEntity : networkEntitys) {
            if (!networkEntity.getIsTopMo().booleanValue() || networkEntity.getProductModel() == null || null != networkEntity.getParentMo()) continue;
            String productModel = networkEntity.getProductModel();
            String managementProtocol = networkEntity.getManagementProtocol();
            if (VerifyUtil.isEmpty((String)productModel) && VerifyUtil.isEmpty((String)managementProtocol)) {
                this.logger.error((Object)"The required info is empty", 90160777658624L);
                continue;
            }
            CommonTemplate template = CommonTemplateManager.getInstance().getTemplate(networkEntity, 3);
            if (null == template) {
                this.logger.error((Object)("Can not find poll template, name=" + networkEntity.getName() + ", moid=" + networkEntity.getMoId() + ", sn=" + networkEntity.getSn() + ", productModel=" + productModel + ", protocol=" + managementProtocol), 90160777658624L);
                continue;
            }
            DevicePoller task = new DevicePoller(networkEntity.getUuid(), networkEntity.getProductModel(), template);
            this.logger.info((Object)("Add device(name:" + networkEntity.getName() + ") to poller ..."), 90160777658624L);
            this.pollController.addPoller((IPoller)task);
        }
        this.logger.info((Object)"Initialize device poller complete ...", 90160777658624L);
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (!Status.STATUS_STARTED.equals((Object)event.getStatus())) {
            return;
        }
        this.deleteUnusedNe();
        this.initPoller();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteUnusedNe() {
        List list;
        Session session;
        block7: {
            session = null;
            String sql = "select moid, sn, linkip from ti_networkentity where sn not in (select deviceSn from ti_dr_resource)";
            session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
            NativeQuery query = session.createSQLQuery(sql);
            list = query.list();
            if (!VerifyUtil.isEmpty((Collection)list)) break block7;
            HibernateUtil.closeSession((Session)session);
            return;
        }
        try {
            for (Object obj : list) {
                if (obj instanceof Object[]) {
                    Object[] values = (Object[])obj;
                    this.logger.info((Object)("Delete unused ne, info=" + StringUtil.arrayToString((Object[])values)), 90160758784000L);
                    this.deleteNe((BigInteger)values[0]);
                    continue;
                }
                this.logger.warn((Object)("data is abnormal, " + obj), 90160758784000L);
            }
        }
        catch (Exception e) {
            try {
                this.logger.error((Object)"Initialize remote server info failed.", 90160758784000L);
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
            HibernateUtil.closeSession((Session)session);
        }
        HibernateUtil.closeSession((Session)session);
    }

    private void deleteNe(BigInteger moid) {
        if (moid == null) {
            this.logger.warn((Object)"moid is null.", 90160758784001L);
            return;
        }
        try {
            IDiscoveryService service = (IDiscoveryService)ServiceLocator.getInstance().getService(IDiscoveryService.class);
            service.deleteNetworkEntity(Arrays.asList(moid.longValue()));
            this.logger.info((Object)("Delete networkentity success, moid=" + moid), 90160758784001L);
        }
        catch (Exception e) {
            this.logger.error((Object)("Delete networkentity failed, moid=" + moid), 90160758784001L);
        }
    }
}

