/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.poll;

import com.huawei.ism.cbb.base.manager.proxy.ManagedObjectManagerProxy;
import com.huawei.ism.cbb.base.poll.IPoller;
import com.huawei.ism.cbb.base.sdk.service.IManagedObjectManager;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.PollContext;
import com.huawei.ism.cbb.discover.framework.CommonTemplate;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class DevicePoller
implements IPoller {
    private static final Log logger = LogFactory.getInstance(DevicePoller.class);
    private String uuid;
    private String pollerType;
    private CommonTemplate template;

    public DevicePoller(String uuid, String pollerType, CommonTemplate template) {
        this.uuid = uuid;
        this.pollerType = pollerType;
        this.template = template;
    }

    private void createPollBackTask(final ManagedObject mo) {
        BackTask bt = BackTaskUtil.buildBackTask((String)mo.getName(), (String)"ism.discover.poll.operationName", (String)"System", (String)"", null);
        int timeOut = this.getTimeOut(mo);
        AbstractBackTask task = new AbstractBackTask(mo.getUuid(), bt, timeOut, false){

            protected void doWork() {
                PollContext context = new PollContext(mo);
                context.setAttribute("isNeedUpdateTask", false);
                context.setAttribute("refreshTask", (Object)this);
                DevicePoller.this.template.process(context);
            }
        };
        BackTaskHandler.getInstance().submitTask(task);
    }

    private int getTimeOut(ManagedObject mo) {
        IManagedObjectManager mgr = ManagedObjectManagerProxy.getInstance().getMgr(mo);
        return mgr.getTimeout();
    }

    public String getPollerID() {
        return this.uuid;
    }

    public String getPollerType() {
        return this.pollerType;
    }

    public void run() {
        try {
            logger.info((Object)("Begin to poll device UUID: " + this.uuid), 90160777658372L);
            ManagedObject mo = CommonDAOLocator.getMoDao().getMo(ManagedObject.class, "uuid", (Object)this.uuid);
            if (mo != null && mo.getIsTopMo().booleanValue()) {
                this.createPollBackTask(mo);
            }
            logger.info((Object)("End to poll device UUID: " + this.uuid), 90160777658372L);
        }
        catch (Exception t) {
            logger.error((Object)("Poll fail, the uuid is " + this.uuid + ExceptionUtil.getErrorMessage((Throwable)t)), 90160758784257L);
        }
    }
}

