/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.poll;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.poll.IPoller;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.PollContext;
import com.huawei.ism.cbb.discover.framework.CommonTemplate;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class PingPoller
implements IPoller {
    private Log logger = LogFactory.getInstance((Object)this);
    private String uuid;
    private String pollerType;
    private CommonTemplate template;

    public PingPoller(String uuid, String pollerType, CommonTemplate template) {
        this.uuid = uuid;
        this.pollerType = pollerType;
        this.template = template;
    }

    public String getPollerID() {
        return this.uuid;
    }

    public String getPollerType() {
        return this.pollerType;
    }

    public void run() {
        try {
            this.logger.debug((Object)("Begin to ping device UUID: " + this.uuid), 90160777658372L);
            NetworkEntity networkEntity = (NetworkEntity)CommonDAOLocator.getMoDao().getMo(NetworkEntity.class, "uuid", (Object)this.uuid);
            if (null != networkEntity && networkEntity.getIsTopMo().booleanValue()) {
                PollContext context = new PollContext((ManagedObject)networkEntity);
                this.template.process(context);
            }
            this.logger.debug((Object)("End to ping device UUID: " + this.uuid), 90160777658372L);
        }
        catch (Exception t) {
            this.logger.error((Object)("Ping fail, the uuid is " + this.uuid + ExceptionUtil.getErrorMessage((Throwable)t)));
        }
    }
}

