/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.poll;

import com.huawei.ism.cbb.base.poll.PollController;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.InitializingBean;

public final class PollControllerLocator
implements InitializingBean {
    private static PollControllerLocator instance = new PollControllerLocator();
    private PollController pollController;
    private PollController pingController;
    private Properties extensionPoints;

    public static PollControllerLocator getInstance() {
        return instance;
    }

    public PollController getPollController() {
        return this.pollController;
    }

    public PollController getPingController() {
        return this.pingController;
    }

    public void setPollController(PollController pollController) {
        this.pollController = pollController;
    }

    public void setPingController(PollController pingController) {
        this.pingController = pingController;
    }

    public void afterPropertiesSet() {
        Map<String, String> deviceTypeMap = this.getPollExtensions();
        this.pollController.addPollerConfig(deviceTypeMap);
    }

    private Map<String, String> getPollExtensions() {
        HashMap<String, String> deviceTypeMap = new HashMap<String, String>();
        deviceTypeMap.put("DRMSERVER", "30");
        deviceTypeMap.put("GLOBALSERVERPOLLER", "180");
        deviceTypeMap.put("Dr_Vrm", "1800");
        deviceTypeMap.put("Dr_Fm", "1800");
        deviceTypeMap.put("Dr_Vrg", "300");
        deviceTypeMap.put("Dr_Host", "43200");
        deviceTypeMap.put("Dr_Vsphere", "1800");
        deviceTypeMap.put("initDelay_Dr_Vsphere", "240");
        deviceTypeMap.put("initDelay_Dr_Vrm", "240");
        deviceTypeMap.put("initDelay_Dr_Fm", "240");
        return deviceTypeMap;
    }

    public Properties getExtensionPoints() {
        return this.extensionPoints;
    }

    public void setExtensionPoints(Properties extensionPoints) {
        this.extensionPoints = extensionPoints;
    }
}

