/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.service.impl;

import com.huawei.ism.array.sdk.model.ArrayHost;
import com.huawei.ism.array.sdk.model.Chassis;
import com.huawei.ism.array.sdk.model.Controller;
import com.huawei.ism.array.sdk.model.MappingView;
import com.huawei.ism.array.sdk.model.XveIntfModule;
import com.huawei.ism.array.sdk.model.XveLun;
import com.huawei.ism.array.sdk.model.XveStoragePool;
import com.huawei.ism.array.sdk.model.XveTier;
import com.huawei.ism.array.sdk.model.XveUnit;
import com.huawei.ism.base.port.sdk.model.FcHostPort;
import com.huawei.ism.base.port.sdk.model.IscsiHostPort;
import com.huawei.ism.base.port.sdk.model.ManagementPort;
import com.huawei.ism.base.port.sdk.model.SasHostPort;
import com.huawei.ism.base.sdk.model.Initiator;
import com.huawei.ism.cbb.base.sdk.constant.ProductModelType;
import com.huawei.ism.cbb.discover.array.ArrayDiscoverUtil;
import com.huawei.ism.cbb.discover.service.XveDeviceProxy;
import com.huawei.ism.cbb.discover.xve.V2TypeMapper;
import com.huawei.ism.cbb.discover.xve.XveTLVTransition;
import com.huawei.ism.cbb.proxy.protocol.tlv.connection.TLVConnection;
import com.huawei.ism.cbb.proxy.protocol.tlv.exception.TLVException;
import com.huawei.ism.cbb.proxy.protocol.tlv.msg.Param;
import com.huawei.ism.cbb.proxy.protocol.tlv.msg.Record;
import com.huawei.ism.cbb.proxy.xve.TLVParamUtil;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefine;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.proxy.xve.XveTLV;
import com.huawei.ism.cbb.proxy.xve.XveTLVPParent;
import com.huawei.ism.cbb.proxy.xve.XveTLVParent;
import com.huawei.ism.cbb.proxy.xve.XveUUID;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.cbb.util.unit.CapabilityUnitType;
import com.huawei.ism.cbb.util.unit.IUnitType;
import com.huawei.ism.cbb.util.unit.UnitConvert;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.ubase.adaptor.hvs.discovery.util.IScsiInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class XveDeviceProxyImpl
implements XveDeviceProxy {
    private static Log logger = LogFactory.getInstance(XveDeviceProxyImpl.class);
    private static final int LONG_TIME_OUT = 600;

    @Override
    public XveUnit getComputerSystem(TLVConnection connection) {
        try {
            Record record = connection.pmGet(XveMOType.SYSTEM.getValue(), "", 30);
            String deviceID = record.getParamStrValue(XveTLVPParent.System.ID.getParamIndex());
            int productModel = TLVParamUtil.getIntValue(record, XveTLVPParent.System.PRODUCTMODE);
            ProductModelType productModelType = ProductModelType.getProductModel((int)productModel);
            if (productModelType == null) {
                productModelType = ProductModelType.UNKNOW;
            }
            String deviceName = record.getParamStrValue(XveTLVPParent.System.NAME.getParamIndex());
            String location = record.getParamStrValue(XveTLVPParent.System.LOCATION.getParamIndex());
            String description = record.getParamStrValue(XveTLVPParent.System.DESCRIPTION.getParamIndex());
            String productVersion = record.getParamStrValue(XveTLVPParent.System.PRODUCTVERSION.getParamIndex());
            Integer healthStatus = V2TypeMapper.V2_ARRAY_HEALTH_STATE.get(TLVParamUtil.getEnumValue(record, XveTLVPParent.System.HEALTHSTATUS));
            if (null == healthStatus) {
                healthStatus = 0;
            }
            XveUnit xveUnit = new XveUnit();
            this.getTv2Capacity(record, xveUnit);
            xveUnit.setDevSn(deviceID);
            if (productModel == ProductModelType.HVS85T.getValue() || productModel == ProductModelType.HVS88T.getValue()) {
                xveUnit.setHasSvp(true);
            }
            xveUnit.setProductModel(productModelType.name());
            xveUnit.setSubType(productModelType.name());
            xveUnit.setUuid(new XveUUID(deviceID, XveMOType.SYSTEM, "").toString());
            xveUnit.setName(deviceName);
            xveUnit.setDescription(description);
            xveUnit.setProductVersion(productVersion);
            xveUnit.setPosition(location);
            xveUnit.setStatus(healthStatus);
            xveUnit.setLinkIp(connection.getUrl());
            xveUnit.setIpAddress(connection.getUrl());
            xveUnit.setMainType("ism.deviceType.storage.mainType");
            return xveUnit;
        }
        catch (TLVException tlve) {
            logger.error((Object)tlve.getMessage(), (Throwable)tlve, 90160777658373L);
            throw new LegoCheckedException(tlve.getErrorId(), (Throwable)tlve);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Get System info error.", (long)132427L, null, (Log)logger);
            return null;
        }
    }

    private void getTv2Capacity(Record record, XveUnit xveUnit) {
        Double memberDisksCapacity = TLVParamUtil.getDoubleValue(record, XveTLVPParent.System.MEMBERDISKSCAPACITY);
        logger.debug((Object)("memberDisksCapacity :" + memberDisksCapacity));
        Double freeDisksCapacity = TLVParamUtil.getDoubleValue(record, XveTLVPParent.System.FREEDISKSCAPACITY);
        Integer sectorSize = TLVParamUtil.getIntValue(record, XveTLVPParent.System.SECTORSIZE);
        if (null != memberDisksCapacity && null != freeDisksCapacity && null != sectorSize) {
            double totalCapacity = UnitConvert.convert((Double)((memberDisksCapacity + freeDisksCapacity) * (double)sectorSize.intValue()), (IUnitType)CapabilityUnitType.Byte, (IUnitType)CapabilityUnitType.GB);
            double usedCapacity = UnitConvert.convert((Double)(memberDisksCapacity * (double)sectorSize.intValue()), (IUnitType)CapabilityUnitType.Byte, (IUnitType)CapabilityUnitType.GB);
            xveUnit.setTotalCapacity(Double.valueOf(totalCapacity));
            xveUnit.setUsedCapacity(Double.valueOf(usedCapacity));
        }
        xveUnit.setTotalCapacityUnit(CapabilityUnitType.GB.name());
        xveUnit.setUsedCapacityUnit(CapabilityUnitType.GB.name());
    }

    @Override
    public List<XveStoragePool> getStoragePools(TLVConnection connection, XveUnit xveUnit) {
        ArrayList<XveStoragePool> storagePools = new ArrayList<XveStoragePool>();
        try {
            List<Record> records = connection.pmGetBacthNext(XveMOType.STORAGEPOOL.getValue(), new ArrayList<Param>(), 30);
            if (!VerifyUtil.isEmpty(records)) {
                this.getStorageInfo(records, xveUnit, storagePools);
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Get StoragePool Info error.", (long)132427L, null, (Log)logger);
        }
        this.getStorageTiers(connection, xveUnit.getDevSn(), storagePools);
        return storagePools;
    }

    private void getStorageInfo(List<Record> records, XveUnit xveUnit, List<XveStoragePool> storagePools) {
        logger.debug((Object)"getStorageInfo");
        for (Record record : records) {
            XveStoragePool storagePool = XveTLVTransition.transitionXveStoragePool(xveUnit.getDevSn(), record);
            storagePool.setParentMo((ManagedObject)xveUnit);
            xveUnit.addChildMo((ManagedObject)storagePool);
            storagePools.add(storagePool);
        }
    }

    @Override
    public List<XveLun> getLuns(TLVConnection connection, String deviceId, List<XveStoragePool> storagePools) {
        if (VerifyUtil.isEmpty(storagePools)) {
            return null;
        }
        ArrayList<XveLun> luns = null;
        try {
            List<Record> records = connection.pmGetBacthNext(XveMOType.LUN.getValue(), new ArrayList<Param>(), 600);
            if (!VerifyUtil.isEmpty(records)) {
                HashMap<String, XveStoragePool> storagePoolsIDMap = new HashMap<String, XveStoragePool>();
                for (XveStoragePool pool : storagePools) {
                    storagePoolsIDMap.put(pool.getPoolId(), pool);
                }
                luns = new ArrayList<XveLun>();
                this.getLunRecord(records, deviceId, storagePoolsIDMap, luns);
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Get Lun Info Error.", (long)132427L, null, (Log)logger);
        }
        return luns;
    }

    private void getLunRecord(List<Record> records, String devSn, Map<String, XveStoragePool> storagePoolsIDMap, List<XveLun> luns) {
        logger.debug((Object)"getLunRecord");
        for (Record record : records) {
            XveLun lun = XveDeviceProxyImpl.parseLun(devSn, record);
            String poolId = record.getParamStrValue(XveTLVParent.Lun.PARENTID.getParamIndex());
            XveStoragePool pool = storagePoolsIDMap.get(poolId);
            if (pool == null) continue;
            pool.addChildMo((ManagedObject)lun);
            lun.setParentMo((ManagedObject)pool);
            luns.add(lun);
        }
    }

    public static XveLun parseLun(String devSn, Record record) {
        Integer runningStatus;
        logger.debug((Object)"parseLun");
        String lunId = record.getParamStrValue(XveTLVParent.Lun.ID.getParamIndex());
        String poolId = record.getParamStrValue(XveTLVParent.Lun.PARENTID.getParamIndex());
        String name = record.getParamStrValue(XveTLVParent.Lun.NAME.getParamIndex());
        Double capacity = TLVParamUtil.getDoubleValue(record, XveTLVParent.Lun.CAPACITY);
        Double usedCapacity = TLVParamUtil.getDoubleValue(record, XveTLVParent.Lun.ALLOCCAPACITY);
        Integer sectorSize = TLVParamUtil.getIntValue(record, XveTLVParent.Lun.SECTORSIZE);
        Integer healthStatus = V2TypeMapper.V2_LUN_HEALTH_STATE.get(TLVParamUtil.getEnumValue(record, XveTLVParent.Lun.HEALTHSTATUS));
        if (null == healthStatus) {
            healthStatus = 0;
        }
        if (null == (runningStatus = V2TypeMapper.V2_LUN_RUNNING_STATE.get(TLVParamUtil.getEnumValue(record, XveTLVParent.Lun.RUNNINGSTATUS)))) {
            runningStatus = 0;
        }
        Integer dataTransferPolicy = TLVParamUtil.getEnumValue(record, XveTLVParent.Lun.DATATRANSFERPOLICY);
        String dataDistributing = record.getParamStrValue(XveTLVParent.Lun.DATADISTRIBUTING.getParamIndex());
        String wwn = record.getParamStrValue(XveTLVParent.Lun.WWN.getParamIndex());
        Integer lunType = TLVParamUtil.getEnumValue(record, XveTLVParent.Lun.ALLOCTYPE);
        String owningController = record.getParamStrValue(XveTLVParent.Lun.OWNINGCONTROLLER.getParamIndex());
        Boolean mapped = TLVParamUtil.getBooleanValue(record, XveTLVParent.Lun.EXPOSEDTOINITIATOR);
        Integer wormState = TLVParamUtil.getEnumValue(record, XveTLVParent.Lun.RETENTIONSTATE);
        if (null != wormState && 2 == wormState) {
            wormState = 0;
        }
        XveLun xveLun = new XveLun();
        xveLun.setLunId(lunId);
        xveLun.setStoragePoolId(poolId);
        xveLun.setDevSn(devSn);
        xveLun.setUuid(new XveUUID(devSn, XveMOType.LUN, lunId).toString());
        xveLun.setName(name);
        if (capacity != null) {
            xveLun.setTotalCapacity(Double.valueOf(UnitConvert.convert((Double)NumberUtil.convertToDouble((Object)(capacity * (double)sectorSize.intValue())), (IUnitType)CapabilityUnitType.Byte, (IUnitType)CapabilityUnitType.MB)));
            xveLun.setTotalCapacityUnit(CapabilityUnitType.MB.name());
        }
        if (usedCapacity != null) {
            xveLun.setUsedCapacity(Double.valueOf(UnitConvert.convert((Double)NumberUtil.convertToDouble((Object)(usedCapacity * (double)sectorSize.intValue())), (IUnitType)CapabilityUnitType.Byte, (IUnitType)CapabilityUnitType.MB)));
            xveLun.setUsedCapacityUnit(CapabilityUnitType.MB.name());
        }
        xveLun.setStatus(healthStatus);
        xveLun.setRunningStatus(String.valueOf(runningStatus));
        xveLun.setHealthStatus(String.valueOf(healthStatus));
        xveLun.setDataDistributing(dataDistributing);
        xveLun.setDataTransferPolicy(dataTransferPolicy);
        xveLun.setWwn(wwn);
        xveLun.setLunType(lunType);
        xveLun.setResourceType(V2TypeMapper.LUN_ALLOC_TYPE.get(lunType));
        xveLun.setMapped(mapped);
        xveLun.setControllerId(owningController);
        xveLun.setWormState(wormState);
        return xveLun;
    }

    @Override
    public List<Controller> getControllers(TLVConnection connection, XveUnit xveUnit) {
        ArrayList<Controller> controllers = null;
        try {
            List<Record> records = connection.pmGetBacthNext(XveMOType.CONTROLLER.getValue(), new ArrayList<Param>(), 30);
            if (!VerifyUtil.isEmpty(records)) {
                controllers = new ArrayList<Controller>();
                for (Record record : records) {
                    Controller controller = XveDeviceProxyImpl.parseController(xveUnit.getDevSn(), record);
                    controller.setParentMo((ManagedObject)xveUnit);
                    xveUnit.addChildMo((ManagedObject)controller);
                    controllers.add(controller);
                }
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Get Controller Info Error.", (long)132427L, null, (Log)logger);
        }
        return controllers;
    }

    public static Controller parseController(String devSn, Record record) {
        Integer runningStatus;
        logger.debug((Object)"parseController");
        String controllerId = record.getParamStrValue(XveTLVPParent.Controller.ID.getParamIndex());
        String location = record.getParamStrValue(XveTLVPParent.Controller.LOCATION.getParamIndex());
        String chassisId = record.getParamStrValue(XveTLVPParent.Controller.PARENTID.getParamIndex());
        String name = record.getParamStrValue(XveTLVPParent.Controller.NAME.getParamIndex());
        Integer healthStatus = V2TypeMapper.CONTROLLER_HEALTH_STUS.get(TLVParamUtil.getEnumValue(record, XveTLVPParent.Controller.HEALTHSTATUS));
        if (null == healthStatus) {
            healthStatus = 0;
        }
        if (null == (runningStatus = V2TypeMapper.CONTROLLER_RUNNING_STUS.get(TLVParamUtil.getEnumValue(record, XveTLVPParent.Controller.RUNNINGSTATUS)))) {
            runningStatus = 0;
        }
        Boolean isMaster = TLVParamUtil.getBooleanValue(record, XveTLVPParent.Controller.ISMASTER);
        Double cacheSize = TLVParamUtil.getDoubleValue(record, XveTLVPParent.Controller.MEMORYSIZE);
        String pcbVer = record.getParamStrValue(XveTLVPParent.Controller.PCBVER.getParamIndex());
        String softVer = record.getParamStrValue(XveTLVPParent.Controller.SOFTVER.getParamIndex());
        Controller controller = new Controller();
        controller.setUuid(new XveUUID(devSn, XveMOType.CONTROLLER, controllerId).toString());
        controller.setControllerId(controllerId);
        controller.setLocation(location);
        controller.setName(name);
        controller.setStatus(healthStatus);
        controller.setRunningStatus(runningStatus);
        controller.setHealthStatus(healthStatus);
        controller.setIsMaster(isMaster);
        controller.setCacheSize(cacheSize);
        controller.setCacheSizeUnit(CapabilityUnitType.MB.name());
        controller.setPcbVersion(pcbVer);
        controller.setSystemVersion(softVer);
        controller.setChassisId(chassisId);
        return controller;
    }

    @Override
    public List<FcHostPort> getHostFcPort(TLVConnection connection, XveUnit xveUnit, List<XveIntfModule> intfModules, List<Controller> controllers) {
        ArrayList<FcHostPort> fcPorts = null;
        try {
            List<Record> records = connection.pmGetBacthNext(XveMOType.FC_PORT.getValue(), new ArrayList<Param>(), 30);
            if (!VerifyUtil.isEmpty(records)) {
                HashMap<String, Controller> controllersIDMap = new HashMap<String, Controller>();
                for (Controller controller : controllers) {
                    controllersIDMap.put(controller.getControllerId(), controller);
                }
                HashMap<String, XveIntfModule> intfsIDMap = new HashMap<String, XveIntfModule>();
                this.putIDMaps(intfsIDMap, intfModules);
                fcPorts = new ArrayList<FcHostPort>();
                this.getHostFcPortRecord(records, xveUnit, fcPorts, controllersIDMap, intfsIDMap);
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Get HostPort Info Error.", (long)132427L, null, (Log)logger);
        }
        return fcPorts;
    }

    private void putIDMaps(Map<String, XveIntfModule> intfsIDMap, List<XveIntfModule> intfModules) {
        logger.debug((Object)"putIDMaps");
        if (intfModules != null) {
            for (XveIntfModule intfModule : intfModules) {
                intfsIDMap.put(intfModule.getIntfId(), intfModule);
            }
        }
    }

    private void getHostFcPortRecord(List<Record> records, XveUnit xveUnit, List<FcHostPort> fcPorts, Map<String, Controller> controllersIDMap, Map<String, XveIntfModule> intfsIDMap) {
        logger.debug((Object)"getHostFcPortRecord");
        for (Record record : records) {
            FcHostPort fcPort = XveDeviceProxyImpl.parseFcPort(xveUnit.getDevSn(), record);
            Integer parentType = TLVParamUtil.getEnumValue(record, XveTLVParent.FcPort.PARENTTYPE);
            String parentId = record.getParamStrValue(XveTLVParent.FcPort.PARENTID.getParamIndex());
            Integer logicType = TLVParamUtil.getEnumValue(record, XveTLVParent.FcPort.LOGICTYPE);
            if (null == parentType || null == logicType) continue;
            Integer[] type = new Integer[]{parentType, logicType};
            XveDeviceProxyImpl.getFcPortByType(type, fcPort, fcPorts, parentId, controllersIDMap, intfsIDMap);
        }
    }

    public static FcHostPort parseFcPort(String devSn, Record record) {
        Integer runningStatus;
        String fcPortId = record.getParamStrValue(XveTLVParent.FcPort.ID.getParamIndex());
        String name = record.getParamStrValue(XveTLVParent.FcPort.NAME.getParamIndex());
        String parentId = record.getParamStrValue(XveTLVParent.FcPort.PARENTID.getParamIndex());
        Integer healthStatus = V2TypeMapper.FC_PORT_HEALTH_STATE.get(TLVParamUtil.getEnumValue(record, XveTLVParent.FcPort.HEALTHSTATUS));
        if (null == healthStatus) {
            healthStatus = 0;
        }
        if (null == (runningStatus = V2TypeMapper.FC_PORT_RUNNING_STATE.get(TLVParamUtil.getEnumValue(record, XveTLVParent.FcPort.RUNNINGSTATUS)))) {
            runningStatus = 32;
        }
        Integer runSpeed = TLVParamUtil.getIntValue(record, XveTLVParent.FcPort.RUNSPEED);
        String wwn = record.getParamStrValue(XveTLVParent.FcPort.WWN.getParamIndex());
        String location = record.getParamStrValue(XveTLVParent.FcPort.LOCATION.getParamIndex());
        FcHostPort fcPort = new FcHostPort();
        fcPort.setUuid(new XveUUID(devSn, XveMOType.FC_PORT, fcPortId).toString());
        fcPort.setNeSN(devSn);
        fcPort.setWwn(wwn);
        fcPort.setHealthStatus(healthStatus);
        fcPort.setRunningStatus(runningStatus);
        fcPort.setStatus(healthStatus);
        fcPort.setIntfModuleId(parentId);
        fcPort.setLocation(location);
        if (null != runSpeed) {
            fcPort.setSpeed(Long.valueOf(runSpeed.longValue()));
        }
        fcPort.setName(name);
        try {
            fcPort.setPortId(Long.valueOf(fcPortId));
        }
        catch (NumberFormatException nfe) {
            logger.error((Object)nfe, 90160777658373L);
        }
        fcPort.setConnectStatus(runningStatus);
        return fcPort;
    }

    public static void getFcPortByType(Integer[] type, FcHostPort fcPort, List<FcHostPort> fcPorts, String parentId, Map<String, Controller> controllersIDMap, Map<String, XveIntfModule> intfsIDMap) {
        logger.debug((Object)"getFcPortByType");
        Integer parentType = type[0];
        Integer logicType = type[1];
        if (XveDeviceProxyImpl.isIntfHostPort(parentType, logicType, parentId, intfsIDMap)) {
            XveIntfModule intfModule = intfsIDMap.get(parentId);
            if (null == intfModule) {
                logger.error((Object)("can not find the intfModule, parentId=" + parentId));
                return;
            }
            fcPort.setControllerId(intfModule.getControllerId());
            fcPort.setBoardId(intfModule.getIntfId());
            Controller controller = controllersIDMap.get(intfModule.getControllerId());
            if (null != controller) {
                controller.addChildMo((ManagedObject)fcPort);
                fcPort.setParentMo((ManagedObject)controller);
                fcPorts.add(fcPort);
            }
        } else if (XveDeviceProxyImpl.isIntfControllerHostPort(parentType, logicType)) {
            fcPort.setControllerId(parentId);
            Controller controller = controllersIDMap.get(parentId);
            if (null != controller) {
                controller.addChildMo((ManagedObject)fcPort);
                fcPort.setParentMo((ManagedObject)controller);
                fcPorts.add(fcPort);
            }
        }
    }

    @Override
    public List<SasHostPort> getStorageSasPort(TLVConnection connection, XveUnit xveUnit, List<XveIntfModule> intfModules, List<Controller> controllers) {
        ArrayList<SasHostPort> sasPorts = null;
        try {
            List<Record> records = connection.pmGetBacthNext(XveMOType.SAS_PORT.getValue(), new ArrayList<Param>(), 30);
            if (!VerifyUtil.isEmpty(records)) {
                HashMap<String, Controller> controllersIDMap = new HashMap<String, Controller>();
                for (Controller controller : controllers) {
                    controllersIDMap.put(controller.getControllerId(), controller);
                }
                HashMap<String, XveIntfModule> intfsIDMap = new HashMap<String, XveIntfModule>();
                this.putSasIDMap(intfsIDMap, intfModules);
                sasPorts = new ArrayList<SasHostPort>();
                this.getStorageSasPortRecord(records, xveUnit.getDevSn(), sasPorts, controllersIDMap, intfsIDMap);
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Get Sas Port Info Error.", (long)132427L, null, (Log)logger);
        }
        return sasPorts;
    }

    private void putSasIDMap(Map<String, XveIntfModule> intfsIDMap, List<XveIntfModule> intfModules) {
        logger.debug((Object)"putSasIDMap");
        if (intfModules != null) {
            for (XveIntfModule intfModule : intfModules) {
                intfsIDMap.put(intfModule.getIntfId(), intfModule);
            }
        }
    }

    private void getStorageSasPortRecord(List<Record> records, String devSn, List<SasHostPort> sasPorts, Map<String, Controller> controllersIDMap, Map<String, XveIntfModule> intfsIDMap) {
        logger.debug((Object)"getStorageSasPortRecord");
        for (Record record : records) {
            SasHostPort sasPort = XveDeviceProxyImpl.parseSasPort(devSn, record);
            Integer parentType = TLVParamUtil.getEnumValue(record, XveTLVParent.SasPort.PARENTTYPE);
            String parentId = record.getParamStrValue(XveTLVParent.SasPort.PARENTID.getParamIndex());
            Integer logicType = TLVParamUtil.getEnumValue(record, XveTLVParent.SasPort.LOGICTYPE);
            if (null == parentType || null == logicType) continue;
            Integer[] type = new Integer[]{parentType, logicType};
            XveDeviceProxyImpl.getSasPortInfoByType(type, parentId, sasPort, sasPorts, controllersIDMap, intfsIDMap);
        }
    }

    public static SasHostPort parseSasPort(String devSn, Record record) {
        Integer runningStatus;
        String sasPortId = record.getParamStrValue(XveTLVParent.SasPort.ID.getParamIndex());
        String name = record.getParamStrValue(XveTLVParent.SasPort.NAME.getParamIndex());
        Integer healthStatus = V2TypeMapper.SAS_PORT_HEALTH_STATE.get(TLVParamUtil.getEnumValue(record, XveTLVParent.SasPort.HEALTHSTATUS));
        if (null == healthStatus) {
            healthStatus = 0;
        }
        if (null == (runningStatus = V2TypeMapper.SAS_PORT_RUNNING_STATE.get(TLVParamUtil.getEnumValue(record, XveTLVParent.SasPort.RUNNINGSTATUS)))) {
            runningStatus = 32;
        }
        Integer runSpeed = TLVParamUtil.getIntValue(record, XveTLVParent.SasPort.RUNSPEED);
        String wwn = record.getParamStrValue(XveTLVParent.SasPort.WWN.getParamIndex());
        String location = record.getParamStrValue(XveTLVParent.SasPort.LOCATION.getParamIndex());
        SasHostPort sasPort = new SasHostPort();
        sasPort.setUuid(new XveUUID(devSn, XveMOType.SAS_PORT, sasPortId).toString());
        sasPort.setNeSN(devSn);
        sasPort.setWwn(wwn);
        sasPort.setStatus(healthStatus);
        sasPort.setHealthStatus(healthStatus);
        sasPort.setRunningStatus(runningStatus);
        if (null != runSpeed) {
            sasPort.setSpeed(Long.valueOf(runSpeed.longValue()));
        }
        sasPort.setName(name);
        sasPort.setLocation(location);
        try {
            sasPort.setPortId(Long.valueOf(sasPortId));
        }
        catch (NumberFormatException nfe) {
            logger.error((Object)nfe.getMessage(), (Throwable)nfe, 90160777658373L);
        }
        sasPort.setConnectStatus(runningStatus);
        return sasPort;
    }

    public static void getSasPortInfoByType(Integer[] type, String parentId, SasHostPort sasPort, List<SasHostPort> sasPorts, Map<String, Controller> controllersIDMap, Map<String, XveIntfModule> intfsIDMap) {
        logger.debug((Object)"getSasPortInfoByType");
        Integer parentType = type[0];
        Integer logicType = type[1];
        if (XveMOType.INTF_MODULE.getValue() == parentType.intValue() && XveEnumDefine.PORT_LOGIC_TYPE_E.HOST.getValue() == logicType.intValue()) {
            XveIntfModule intfModule = intfsIDMap.get(parentId);
            if (intfModule != null) {
                sasPort.setControllerId(intfModule.getControllerId());
                sasPort.setBoardId(intfModule.getIntfId());
                Controller controller = controllersIDMap.get(intfModule.getControllerId());
                if (null != controller) {
                    controller.addChildMo((ManagedObject)sasPort);
                    sasPort.setParentMo((ManagedObject)controller);
                    sasPort.setIntfModuleId(parentId);
                    sasPorts.add(sasPort);
                }
            }
        } else if (XveDeviceProxyImpl.isIntfControllerHostPort(parentType, logicType)) {
            sasPort.setControllerId(parentId);
            Controller controller = controllersIDMap.get(parentId);
            if (null != controller) {
                controller.addChildMo((ManagedObject)sasPort);
                sasPort.setParentMo((ManagedObject)controller);
                sasPorts.add(sasPort);
            }
        }
    }

    private List<XveTier> getStorageTiers(TLVConnection connection, String deviceId, List<XveStoragePool> storagePools) {
        ArrayList<XveTier> xveTiers = null;
        try {
            List<Record> records = connection.pmGetBacthNext(XveMOType.STORAGETIER.getValue(), new ArrayList<Param>(), 30);
            if (!VerifyUtil.isEmpty(records)) {
                HashMap<String, XveStoragePool> storagePoolsIDMap = new HashMap<String, XveStoragePool>();
                for (XveStoragePool pool : storagePools) {
                    storagePoolsIDMap.put(pool.getPoolId(), pool);
                }
                xveTiers = new ArrayList<XveTier>();
                for (Record record : records) {
                    XveTier xveTier = XveTLVTransition.transitionXveTier(deviceId, record);
                    this.setPool(xveTier, storagePoolsIDMap);
                    xveTiers.add(xveTier);
                }
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Get StorageTiers Info Error.", (long)132427L, null, (Log)logger);
        }
        return xveTiers;
    }

    private void setPool(XveTier xveTier, Map<String, XveStoragePool> storagePoolsIDMap) {
        logger.debug((Object)"setPool");
        String poolId = xveTier.getPoolId();
        XveStoragePool pool = storagePoolsIDMap.get(poolId);
        if (null != pool) {
            String tierId = xveTier.getTierId();
            if (tierId.equals(poolId + ".0")) {
                pool.setTier0FreeCapacity(xveTier.getTierAvailableCapacity());
                pool.setTier0UsedCapacity(xveTier.getTierConsumedCapacity());
            }
            if (tierId.equals(poolId + ".1")) {
                pool.setTier1FreeCapacity(xveTier.getTierAvailableCapacity());
                pool.setTier1UsedCapacity(xveTier.getTierConsumedCapacity());
            }
            if (tierId.equals(poolId + ".2")) {
                pool.setTier2FreeCapacity(xveTier.getTierAvailableCapacity());
                pool.setTier2UsedCapacity(xveTier.getTierConsumedCapacity());
            }
        }
    }

    @Override
    public List<IscsiHostPort> getStorageEtherPort(TLVConnection connection, XveUnit xveUnit, List<XveIntfModule> intfModules, List<Controller> controllers) {
        ArrayList<IscsiHostPort> iscsiHostPorts = null;
        try {
            List<Record> records = connection.pmGetBacthNext(XveMOType.ETH_PORT.getValue(), new ArrayList<Param>(), 30);
            if (!VerifyUtil.isEmpty(records)) {
                HashMap<String, Controller> controllersIDMap = new HashMap<String, Controller>();
                for (Controller controller : controllers) {
                    controllersIDMap.put(controller.getControllerId(), controller);
                }
                HashMap<String, XveIntfModule> intfsIDMap = new HashMap<String, XveIntfModule>();
                this.putIntfsIDMap(intfsIDMap, intfModules);
                HashMap<String, List<ManagementPort>> managePortsMap = new HashMap<String, List<ManagementPort>>();
                iscsiHostPorts = new ArrayList<IscsiHostPort>();
                this.getStorageEtherPortRecord(records, xveUnit, iscsiHostPorts, intfsIDMap, controllersIDMap, managePortsMap);
                ArrayDiscoverUtil.setControllerIp(managePortsMap, controllersIDMap, true);
                ArrayDiscoverUtil.setControllerIp(managePortsMap, controllersIDMap, false);
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Get EtherPort Info Error.", (long)132427L, null, (Log)logger);
        }
        return iscsiHostPorts;
    }

    private void putIntfsIDMap(Map<String, XveIntfModule> intfsIDMap, List<XveIntfModule> intfModules) {
        logger.debug((Object)"putIntfsIDMap");
        if (intfModules != null) {
            for (XveIntfModule intfModule : intfModules) {
                intfsIDMap.put(intfModule.getIntfId(), intfModule);
            }
        }
    }

    private void getStorageEtherPortRecord(List<Record> records, XveUnit xveUnit, List<IscsiHostPort> iscsiHostPorts, Map<String, XveIntfModule> intfsIDMap, Map<String, Controller> controllersIDMap, Map<String, List<ManagementPort>> managePortsMap) {
        for (Record record : records) {
            Integer runningStatus;
            IscsiHostPort port = new IscsiHostPort();
            String sasPortId = record.getParamStrValue(XveTLVParent.EthPort.ID.getParamIndex());
            port.setUuid(new XveUUID(xveUnit.getDevSn(), XveMOType.ETH_PORT, sasPortId).toString());
            port.setName(record.getParamStrValue(XveTLVParent.EthPort.NAME.getParamIndex()));
            port.setNeSN(xveUnit.getDevSn());
            port.setIpAddress(record.getParamStrValue(XveTLVParent.EthPort.IPV4ADDR.getParamIndex()));
            port.setMask(record.getParamStrValue(XveTLVParent.EthPort.IPV4MASK.getParamIndex()));
            port.setGateway(record.getParamStrValue(XveTLVParent.EthPort.IPV4GATEWAY.getParamIndex()));
            port.setIpv4Gateway(record.getParamStrValue(XveTLVParent.EthPort.IPV4GATEWAY.getParamIndex()));
            port.setIpv4Mask(record.getParamStrValue(XveTLVParent.EthPort.IPV4MASK.getParamIndex()));
            port.setIpv6Gateway(record.getParamStrValue(XveTLVParent.EthPort.IPV6GATEWAY.getParamIndex()));
            port.setIpv6Mask(record.getParamStrValue(XveTLVParent.EthPort.IPV6MASK.getParamIndex()));
            port.setIpv6Address(record.getParamStrValue(XveTLVParent.EthPort.IPV6ADDR.getParamIndex()));
            port.setIpv6Profix(record.getParamStrValue(XveTLVParent.EthPort.IPV6MASK.getParamIndex()));
            port.setIscsiName(record.getParamStrValue(XveTLVParent.EthPort.ISCSINAME.getParamIndex()));
            port.setLocation(record.getParamStrValue(XveTLVParent.EthPort.LOCATION.getParamIndex()));
            String macAddress = record.getParamStrValue(XveTLVParent.EthPort.MACADDRESS.getParamIndex());
            if (null != macAddress) {
                macAddress = macAddress.replace(":", "").toLowerCase(Locale.US);
            }
            port.setMac(macAddress);
            port.setBondName(record.getParamStrValue(XveTLVParent.EthPort.BONDNAME.getParamIndex()));
            Integer healthStatus = V2TypeMapper.ETH_PORT_HEALTH_STATE.get(TLVParamUtil.getEnumValue(record, XveTLVParent.EthPort.HEALTHSTATUS));
            if (null == healthStatus) {
                healthStatus = 0;
            }
            if (null == (runningStatus = V2TypeMapper.ETH_PORT_RUNNING_STATE.get(TLVParamUtil.getEnumValue(record, XveTLVParent.EthPort.RUNNINGSTATUS)))) {
                runningStatus = 32;
            }
            port.setHealthStatus(healthStatus);
            port.setRunningStatus(runningStatus);
            port.setConnectStatus(runningStatus);
            port.setStatus(healthStatus);
            Integer speed = TLVParamUtil.getIntValue(record, XveTLVParent.EthPort.SPEED);
            if (speed != null) {
                port.setSpeed(Long.valueOf(speed.longValue()));
            }
            try {
                port.setPortId(Long.valueOf(sasPortId));
            }
            catch (NumberFormatException nfe) {
                logger.error((Object)nfe.getMessage(), (Throwable)nfe, 90160777658373L);
            }
            this.setIScsiInfo(iscsiHostPorts, intfsIDMap, controllersIDMap, managePortsMap, record, port);
        }
    }

    private void setIScsiInfo(List<IscsiHostPort> iscsiHostPorts, Map<String, XveIntfModule> intfsIDMap, Map<String, Controller> controllersIDMap, Map<String, List<ManagementPort>> managePortsMap, Record record, IscsiHostPort port) {
        Integer parentType = TLVParamUtil.getEnumValue(record, XveTLVParent.EthPort.PARENTTYPE);
        Integer logicType = TLVParamUtil.getEnumValue(record, XveTLVParent.EthPort.LOGICTYPE);
        if (null != parentType && null != logicType) {
            IScsiInfo info = new IScsiInfo();
            info.setIscsiPort(port);
            info.setParentId(record.getParamStrValue(XveTLVParent.EthPort.PARENTID.getParamIndex()));
            info.setControllersIDMap(controllersIDMap);
            info.setIscsiHostPorts(iscsiHostPorts);
            info.setManagePortsMap(managePortsMap);
            info.setIntfsIDMap(intfsIDMap);
            info.setParentType(parentType);
            info.setLogicType(logicType);
            XveDeviceProxyImpl.getIscPortInfoByType(info);
        }
    }

    public static void getIscPortInfoByType(IScsiInfo info) {
        Integer logicType;
        IscsiHostPort iscsiPort = info.getIscsiPort();
        String parentId = info.getParentId();
        Map<String, Controller> controllersIDMap = info.getControllersIDMap();
        List<IscsiHostPort> iscsiHostPorts = info.getIscsiHostPorts();
        Map<String, List<ManagementPort>> managePortsMap = info.getManagePortsMap();
        Map<String, XveIntfModule> intfsIDMap = info.getIntfsIDMap();
        Integer parentType = info.getParentType();
        if (XveDeviceProxyImpl.isIntfHostPort(parentType, logicType = info.getLogicType(), parentId, intfsIDMap)) {
            XveDeviceProxyImpl.dealIntfHostPort(iscsiPort, parentId, controllersIDMap, iscsiHostPorts, intfsIDMap);
        } else if (XveDeviceProxyImpl.isIntfManagePort(parentType, logicType, parentId, intfsIDMap)) {
            XveDeviceProxyImpl.dealIntfManagePort(iscsiPort, parentId, controllersIDMap, managePortsMap, intfsIDMap);
        } else if (XveDeviceProxyImpl.isIntfControllerHostPort(parentType, logicType)) {
            XveDeviceProxyImpl.dealIntfControllerHostPort(iscsiPort, parentId, controllersIDMap, iscsiHostPorts);
        } else if (XveDeviceProxyImpl.isaIntfControllerManagerPort(parentType, logicType)) {
            XveDeviceProxyImpl.dealIntfControllerManagePort(iscsiPort, parentId, controllersIDMap, managePortsMap);
        }
    }

    private static void dealIntfControllerHostPort(IscsiHostPort iscsiPort, String parentId, Map<String, Controller> controllersIDMap, List<IscsiHostPort> iscsiHostPorts) {
        iscsiPort.setControllerId(parentId);
        Controller controller = controllersIDMap.get(parentId);
        if (null != controller) {
            controller.addChildMo((ManagedObject)iscsiPort);
            iscsiPort.setParentMo((ManagedObject)controller);
            iscsiHostPorts.add(iscsiPort);
        }
    }

    private static void dealIntfControllerManagePort(IscsiHostPort iscsiPort, String parentId, Map<String, Controller> controllersIDMap, Map<String, List<ManagementPort>> managePortsMap) {
        iscsiPort.setControllerId(parentId);
        List<ManagementPort> managePorts = managePortsMap.get(parentId);
        if (managePorts == null) {
            managePorts = new ArrayList<ManagementPort>();
            managePortsMap.put(parentId, managePorts);
        }
        ManagementPort managePort = iscsiPort.toManagementPort();
        managePorts.add(managePort);
        Controller controller = controllersIDMap.get(parentId);
        if (null != controller) {
            controller.addChildMo((ManagedObject)managePort);
            managePort.setParentMo((ManagedObject)controller);
        }
    }

    private static void dealIntfManagePort(IscsiHostPort iscsiPort, String parentId, Map<String, Controller> controllersIDMap, Map<String, List<ManagementPort>> managePortsMap, Map<String, XveIntfModule> intfsIDMap) {
        XveIntfModule intfModule = intfsIDMap.get(parentId);
        if (null == intfModule) {
            logger.error((Object)("intfModule is null, parentId=" + parentId));
            return;
        }
        iscsiPort.setControllerId(intfModule.getControllerId());
        iscsiPort.setBoardId(intfModule.getIntfId());
        iscsiPort.setIntfModuleId(parentId);
        List<ManagementPort> managePorts = managePortsMap.get(intfModule.getControllerId());
        if (managePorts == null) {
            managePorts = new ArrayList<ManagementPort>();
            managePortsMap.put(intfModule.getControllerId(), managePorts);
        }
        ManagementPort managePort = iscsiPort.toManagementPort();
        managePorts.add(managePort);
        Controller controller = controllersIDMap.get(intfModule.getControllerId());
        if (null == controller) {
            logger.info((Object)("null is controller!intfModule.getControllerId() is " + intfModule.getControllerId()), 90160777658373L);
            return;
        }
        controller.addChildMo((ManagedObject)managePort);
        managePort.setParentMo((ManagedObject)controller);
    }

    private static void dealIntfHostPort(IscsiHostPort iscsiPort, String parentId, Map<String, Controller> controllersIDMap, List<IscsiHostPort> iscsiHostPorts, Map<String, XveIntfModule> intfsIDMap) {
        XveIntfModule intfModule = intfsIDMap.get(parentId);
        if (null == intfModule) {
            logger.error((Object)("intfModule is null, parentId=" + parentId));
            return;
        }
        iscsiPort.setControllerId(intfModule.getControllerId());
        iscsiPort.setBoardId(intfModule.getIntfId());
        Controller controller = controllersIDMap.get(intfModule.getControllerId());
        if (null == controller) {
            logger.info((Object)("null is controller!!intfModule.getControllerId() is " + intfModule.getControllerId()), 90160777658373L);
            return;
        }
        controller.addChildMo((ManagedObject)iscsiPort);
        iscsiPort.setParentMo((ManagedObject)controller);
        iscsiPort.setIntfModuleId(parentId);
        iscsiHostPorts.add(iscsiPort);
    }

    private static boolean isIntfControllerHostPort(Integer parentType, Integer logicType) {
        return XveMOType.CONTROLLER.getValue() == parentType.intValue() && XveEnumDefine.PORT_LOGIC_TYPE_E.HOST.getValue() == logicType.intValue();
    }

    private static boolean isaIntfControllerManagerPort(Integer parentType, Integer logicType) {
        return XveMOType.CONTROLLER.getValue() == parentType.intValue() && XveEnumDefine.PORT_LOGIC_TYPE_E.MNGT.getValue() == logicType.intValue();
    }

    private static boolean isIntfManagePort(Integer parentType, Integer logicType, String parentId, Map<String, XveIntfModule> intfsIDMap) {
        logger.debug((Object)"isIntfManagePort");
        return XveMOType.INTF_MODULE.getValue() == parentType.intValue() && XveEnumDefine.PORT_LOGIC_TYPE_E.MNGT.getValue() == logicType.intValue() && null != intfsIDMap.get(parentId);
    }

    private static boolean isIntfHostPort(Integer parentType, Integer logicType, String parentId, Map<String, XveIntfModule> intfsIDMap) {
        logger.debug((Object)"isIntfHostPort");
        return XveMOType.INTF_MODULE.getValue() == parentType.intValue() && XveEnumDefine.PORT_LOGIC_TYPE_E.HOST.getValue() == logicType.intValue() && null != intfsIDMap.get(parentId);
    }

    @Override
    public List<XveIntfModule> getIntfModules(TLVConnection connection, XveUnit xveUnit, List<Controller> controllers) {
        ArrayList<XveIntfModule> intfModules = null;
        try {
            List<Record> records = connection.pmGetBacthNext(XveMOType.INTF_MODULE.getValue(), new ArrayList<Param>(), 30);
            if (!VerifyUtil.isEmpty(records)) {
                intfModules = new ArrayList<XveIntfModule>();
                this.getIntfModulesInfo(records, xveUnit, intfModules);
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Get Modules Info Error.", (long)132427L, null, (Log)logger);
        }
        return intfModules;
    }

    private void getIntfModulesInfo(List<Record> records, XveUnit xveUnit, List<XveIntfModule> intfModules) {
        logger.debug((Object)"getIntfModulesInfo");
        for (Record record : records) {
            Integer runningStatus;
            XveIntfModule xveIntfModule = new XveIntfModule();
            String intfId = record.getParamStrValue(XveTLVParent.IntfModule.ID.getParamIndex());
            String location = record.getParamStrValue(XveTLVParent.IntfModule.LOCATION.getParamIndex());
            String controllerId = record.getParamStrValue(XveTLVParent.IntfModule.PARENTID.getParamIndex());
            Integer healthStatus = V2TypeMapper.MODULES_HEALTH_STATE.get(TLVParamUtil.getEnumValue(record, XveTLVParent.IntfModule.HEALTHSTATUS));
            if (null == healthStatus) {
                healthStatus = 0;
            }
            if (null == (runningStatus = V2TypeMapper.MODULES_RUNNING_STATE.get(TLVParamUtil.getEnumValue(record, XveTLVParent.IntfModule.RUNNINGSTATUS)))) {
                runningStatus = 0;
            }
            Integer model = TLVParamUtil.getEnumValue(record, XveTLVParent.IntfModule.MODEL);
            xveIntfModule.setUuid(new XveUUID(xveUnit.getDevSn(), XveMOType.INTF_MODULE, intfId).toString());
            xveIntfModule.setLocation(location);
            xveIntfModule.setStatus(healthStatus);
            xveIntfModule.setHealthStatus(healthStatus);
            xveIntfModule.setRunningStatus(runningStatus);
            xveIntfModule.setIntfId(intfId);
            xveIntfModule.setControllerId(controllerId);
            if (model != null) {
                xveIntfModule.setModel(model.toString());
            }
            intfModules.add(xveIntfModule);
        }
    }

    @Override
    public List<ArrayHost> getHosts(TLVConnection connection, XveUnit xveUnit, List<MappingView> mappingViews) {
        ArrayList<ArrayHost> arrayHosts = null;
        try {
            List<Record> records = connection.pmGetBacthNext(XveMOType.HOST.getValue(), new ArrayList<Param>(), 30);
            if (!VerifyUtil.isEmpty(records)) {
                arrayHosts = new ArrayList<ArrayHost>();
                this.getHostInfo(records, xveUnit, arrayHosts);
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Get Host Info Error.", (long)132427L, null, (Log)logger);
        }
        return arrayHosts;
    }

    private void getHostInfo(List<Record> records, XveUnit xveUnit, List<ArrayHost> arrayHosts) {
        logger.debug((Object)"getHostInfo");
        for (Record record : records) {
            ArrayHost arrayHost = XveTLVTransition.transitionArrayHost(xveUnit.getDevSn(), record);
            arrayHost.setParentMo((ManagedObject)xveUnit);
            xveUnit.addChildMo((ManagedObject)arrayHost);
            arrayHosts.add(arrayHost);
        }
    }

    @Override
    public List<Initiator> getInitiators(TLVConnection connection, XveUnit xveUnit) {
        ArrayList<Initiator> initiators = new ArrayList<Initiator>();
        try {
            List<Record> records = connection.pmGetBacthNext(XveMOType.ISCSI_INITIATOR.getValue(), new ArrayList<Param>(), 30);
            if (!VerifyUtil.isEmpty(records)) {
                this.getIscsiInitiators(records, xveUnit, initiators);
            }
            if (!VerifyUtil.isEmpty(records = connection.pmGetBacthNext(XveMOType.FC_INITIATOR.getValue(), new ArrayList<Param>(), 30))) {
                this.getFcInitiatorInfo(records, xveUnit, initiators);
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Get Ubutuators Info Error.", (long)132427L, null, (Log)logger);
        }
        return initiators;
    }

    private void getIscsiInitiators(List<Record> records, XveUnit xveUnit, List<Initiator> initiators) {
        for (Record record : records) {
            Initiator iscsiInit = XveDeviceProxyImpl.getIscsiInitiatorInfo(record, xveUnit.getDevSn());
            iscsiInit.setParentMo((ManagedObject)xveUnit);
            xveUnit.addChildMo((ManagedObject)iscsiInit);
            initiators.add(iscsiInit);
        }
    }

    public static Initiator getIscsiInitiatorInfo(Record record, String devSn) {
        Integer healthStatus;
        String initiatorId = record.getParamStrValue(XveTLV.IscsiInitiator.ID.getParamIndex());
        if (VerifyUtil.isEmpty((String)initiatorId)) {
            logger.error((Object)("initiatorId is empty, sn=" + devSn + ", id=" + initiatorId));
            throw new LegoCheckedException(1073947393L);
        }
        String aliasName = record.getParamStrValue(XveTLV.IscsiInitiator.NAME.getParamIndex());
        String hostId = record.getParamStrValue(XveTLV.IscsiInitiator.PARENTID.getParamIndex());
        Integer runningStatus = V2TypeMapper.ISC_INITIATO_RUNNING_STATE.get(TLVParamUtil.getEnumValue(record, XveTLV.IscsiInitiator.RUNNINGSTATUS));
        if (null == runningStatus) {
            runningStatus = 0;
        }
        if (null == (healthStatus = V2TypeMapper.ISC_INITIATO_HEALTH_STATE.get(TLVParamUtil.getEnumValue(record, XveTLV.IscsiInitiator.HEALTHSTATUS)))) {
            healthStatus = 0;
        }
        Initiator initiator = new Initiator();
        String uuid = new XveUUID(devSn, XveMOType.ISCSI_INITIATOR, String.valueOf(initiatorId.hashCode())).toString();
        initiator.setUuid(uuid);
        initiator.setAlias(aliasName);
        initiator.setHbaType("ISCSI");
        initiator.setIdentity(initiatorId);
        initiator.setName(initiatorId);
        initiator.setStatus(healthStatus);
        initiator.setHealthStatus(healthStatus);
        initiator.setRunningStatus(runningStatus);
        if (!VerifyUtil.isEmpty((String)hostId)) {
            initiator.setHostUUID(new XveUUID(devSn, XveMOType.HOST, hostId).toString());
        }
        return initiator;
    }

    private void getFcInitiatorInfo(List<Record> records, XveUnit xveUnit, List<Initiator> initiators) {
        logger.debug((Object)"getFcInitiatorInfo");
        for (Record record : records) {
            Initiator initiator = XveDeviceProxyImpl.getFcInitiatorInfo(record, xveUnit.getDevSn());
            initiator.setParentMo((ManagedObject)xveUnit);
            xveUnit.addChildMo((ManagedObject)initiator);
            initiators.add(initiator);
        }
    }

    public static Initiator getFcInitiatorInfo(Record record, String devSn) {
        Integer healthStatus;
        String initiatorId = record.getParamStrValue(XveTLV.FcInitiator.ID.getParamIndex());
        if (VerifyUtil.isEmpty((String)initiatorId)) {
            logger.error((Object)("initiatorId is empty, sn=" + devSn + ", id=" + initiatorId));
            throw new LegoCheckedException(1073947393L);
        }
        String aliasName = record.getParamStrValue(XveTLV.FcInitiator.NAME.getParamIndex());
        String hostId = record.getParamStrValue(XveTLV.FcInitiator.PARENTID.getParamIndex());
        Integer runningStatus = V2TypeMapper.FC_INITIATO_RUNNING_STATE.get(TLVParamUtil.getEnumValue(record, XveTLV.FcInitiator.RUNNINGSTATUS));
        if (null == runningStatus) {
            runningStatus = 0;
        }
        if (null == (healthStatus = V2TypeMapper.FC_INITIATO_HEALTH_STATE.get(TLVParamUtil.getEnumValue(record, XveTLV.FcInitiator.HEALTHSTATUS)))) {
            healthStatus = 0;
        }
        Initiator initiator = new Initiator();
        String uuid = new XveUUID(devSn, XveMOType.FC_INITIATOR, String.valueOf(initiatorId.hashCode())).toString();
        initiator.setUuid(uuid);
        initiator.setAlias(aliasName);
        initiator.setHbaType("FC");
        initiator.setIdentity(initiatorId);
        initiator.setName(initiatorId);
        initiator.setStatus(healthStatus);
        initiator.setHealthStatus(healthStatus);
        initiator.setRunningStatus(runningStatus);
        if (!VerifyUtil.isEmpty((String)hostId)) {
            initiator.setHostUUID(new XveUUID(devSn, XveMOType.HOST, hostId).toString());
        }
        return initiator;
    }

    @Override
    public List<Chassis> getChassises(TLVConnection connection, XveUnit xveUnit) {
        ArrayList<Chassis> chassises = null;
        try {
            List<Record> records = connection.pmGetBacthNext(XveMOType.ENCLOSURE.getValue(), new ArrayList<Param>(), 30);
            if (!VerifyUtil.isEmpty(records)) {
                chassises = new ArrayList<Chassis>();
                for (Record record : records) {
                    Integer runningStatus;
                    Chassis chassis = new Chassis();
                    String chassisId = record.getParamStrValue(XveTLVPParent.Enclosure.ID.getParamIndex());
                    String name = record.getParamStrValue(XveTLVPParent.Enclosure.NAME.getParamIndex());
                    Integer temperature = TLVParamUtil.getIntValue(record, XveTLVPParent.Enclosure.TEMPERATURE);
                    Integer height = TLVParamUtil.getIntValue(record, XveTLVPParent.Enclosure.HEIGHT);
                    String serialNum = record.getParamStrValue(XveTLVPParent.Enclosure.SERIALNUM.getParamIndex());
                    String location = record.getParamStrValue(XveTLVPParent.Enclosure.LOCATION.getParamIndex());
                    Integer logicType = TLVParamUtil.getEnumValue(record, XveTLVPParent.Enclosure.LOGICTYPE);
                    Integer model = TLVParamUtil.getEnumValue(record, XveTLVPParent.Enclosure.MODEL);
                    Integer healthStatus = V2TypeMapper.CHASSISES_HEALTH_STATE.get(TLVParamUtil.getEnumValue(record, XveTLVPParent.Enclosure.HEALTHSTATUS));
                    if (null == healthStatus) {
                        healthStatus = 0;
                    }
                    if (null == (runningStatus = V2TypeMapper.CHASSISES_RUNNING_STATE.get(TLVParamUtil.getEnumValue(record, XveTLVPParent.Enclosure.RUNNINGSTATUS)))) {
                        runningStatus = 0;
                    }
                    chassis.setUuid(new XveUUID(xveUnit.getDevSn(), XveMOType.ENCLOSURE, chassisId).toString());
                    chassis.setName(name);
                    chassis.setStatus(healthStatus);
                    chassis.setHealthState(String.valueOf(healthStatus));
                    chassis.setRunningState(String.valueOf(runningStatus));
                    chassis.setTemperature(temperature);
                    chassis.setHeight(height);
                    chassis.setSerialNum(serialNum);
                    chassis.setLocation(location);
                    chassis.setChassisModel(V2TypeMapper.CHASSIS_MODEL.get(model));
                    chassis.setLogicType(V2TypeMapper.CHASSIS_LOGIC_TYPE.get(logicType));
                    chassis.setChassisId(name);
                    xveUnit.addChildMo((ManagedObject)chassis);
                    chassis.setParentMo((ManagedObject)xveUnit);
                    chassises.add(chassis);
                }
            }
        }
        catch (TLVException e) {
            logger.error((Object)"getChassises error.", (Throwable)e);
            throw new LegoCheckedException(e.getErrorId(), (Throwable)e);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Get Chassis Info Error.", (long)132427L, null, (Log)logger);
        }
        return chassises;
    }

    @Override
    public List<MappingView> getMappingViews(TLVConnection connection, XveUnit xveUnit) {
        ArrayList<MappingView> mappingViews = new ArrayList<MappingView>();
        try {
            List<Record> records = connection.pmGetBacthNext(XveMOType.MAPPINGVIEW.getValue(), new ArrayList<Param>(), 30);
            if (!VerifyUtil.isEmpty(records)) {
                for (Record record : records) {
                    MappingView mappingView = new MappingView();
                    String mappingViewId = record.getParamStrValue(XveTLV.MappingView.ID.getParamIndex());
                    String name = record.getParamStrValue(XveTLV.MappingView.NAME.getParamIndex());
                    String description = record.getParamStrValue(XveTLV.MappingView.DESCRIPTION.getParamIndex());
                    mappingView.setUuid(new XveUUID(xveUnit.getDevSn(), XveMOType.MAPPINGVIEW, mappingViewId).toString());
                    mappingView.setMappingViewId(mappingViewId);
                    mappingView.setName(name);
                    mappingView.setDescription(description);
                    xveUnit.addChildMo((ManagedObject)mappingView);
                    mappingView.setParentMo((ManagedObject)xveUnit);
                    mappingViews.add(mappingView);
                }
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Get MappingView Info Error.", (long)132427L, null, (Log)logger);
        }
        return mappingViews;
    }

    @Override
    public TimeZone getSystemTimeZoneInfo(TLVConnection connection) {
        try {
            Record record = connection.invoke(55847747651L, new ArrayList<Param>());
            String timeZoneName = record.getParamStrValue(XveTLVPParent.SystemTimeZone.CMO_SYS_TIME_ZONE_NAME.getParamIndex());
            return TimeZone.getTimeZone(timeZoneName);
        }
        catch (Exception e) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 90160777658373L);
            return null;
        }
    }

    @Override
    public List<ManagementPort> getManagementPorts(TLVConnection connection, XveUnit xveUnit) {
        ArrayList<ManagementPort> mgmtPorts = new ArrayList<ManagementPort>();
        try {
            List<Record> records = connection.pmGetBacthNext(XveMOType.ETH_PORT.getValue(), new ArrayList<Param>(), 30);
            for (Record record : records) {
                Integer logicType = TLVParamUtil.getEnumValue(record, XveTLVParent.EthPort.LOGICTYPE);
                if (null == logicType) {
                    logger.error((Object)"logicType is null");
                    throw new LegoCheckedException(1073947393L);
                }
                if (XveEnumDefine.PORT_LOGIC_TYPE_E.MNGT.getValue() != logicType.intValue()) continue;
                String ipv4Address = record.getParamStrValue(XveTLVParent.EthPort.IPV4ADDR.getParamIndex());
                ManagementPort temp = new ManagementPort();
                temp.setIpAddress(ipv4Address);
                mgmtPorts.add(temp);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.rethrowException((Throwable)ex, (String)"Get Management Ports fail.", (long)655384L, null, (Log)logger);
        }
        return mgmtPorts;
    }
}

