/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.util;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.manager.proxy.ManagedObjectManagerProxy;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.RefreshContext;
import com.huawei.ism.cbb.discover.framework.CommonTemplate;
import com.huawei.ism.cbb.discover.framework.CommonTemplateManager;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class DiscoverUtil {
    private static Log logger = LogFactory.getInstance((Object)new DiscoverUtil());

    public static boolean isS5600V1R1Unit(StorageUnit unit) {
        return null != unit && "S5600(V100R001)".equals(unit.getSubType());
    }

    private static Map<String, String> getExtendParams(Map<String, String> paramMap, int snmpVer) {
        HashMap<String, String> extendParams = new HashMap<String, String>();
        extendParams.put("sslFlag", paramMap.get("ssl"));
        extendParams.put("protocol", paramMap.get("protocol"));
        extendParams.put("snmpVer", String.valueOf(snmpVer));
        if (!VerifyUtil.isEmpty((String)paramMap.get("port"))) {
            extendParams.put("port", paramMap.get("port"));
        }
        if (null != paramMap.get("namespace")) {
            extendParams.put("namespace", paramMap.get("namespace"));
        }
        extendParams.put("isFirstBuildTlv", "isFirstBuild");
        return extendParams;
    }

    public static void refreshEntityBySystem(NetworkEntity networkEntity) {
        if (null == networkEntity) {
            logger.info((Object)"The device is NOT found ! ", 90160777658624L);
            return;
        }
        try {
            CommonTemplate template = CommonTemplateManager.getInstance().getTemplate(networkEntity, 2);
            DiscoverUtil.submitBackTask(networkEntity, template);
            logger.info((Object)("System refresh device " + networkEntity.getName() + " by ism msg trap finished."), 90160777658642L);
        }
        catch (Exception e) {
            logger.error((Object)("System refresh device " + networkEntity.getName() + " by ism msg trap failed."), 90160777658642L);
        }
    }

    public static void setMosOffline(NetworkEntity networkEntity) {
        DiscoverUtil.updateNetworkEntityStatus(networkEntity, -1);
    }

    private static void submitBackTask(final NetworkEntity networkEntity, final CommonTemplate template) {
        if (null == template) {
            logger.error((Object)"template is null.", 90160758784000L);
            return;
        }
        BackTask bt = BackTaskUtil.buildBackTask((String)networkEntity.getName(), (String)"ism.discover.refresh.operationName", (String)"System", (String)"", null);
        int timeout = ManagedObjectManagerProxy.getInstance().getMgr((ManagedObject)networkEntity).getTimeout();
        AbstractBackTask task = new AbstractBackTask(networkEntity.getUuid(), bt, timeout, true){

            protected void doWork() {
                RefreshContext refreshContext = new RefreshContext((ManagedObject)networkEntity);
                refreshContext.setAttribute("refreshTask", (Object)this);
                template.process(refreshContext);
            }
        };
        BackTaskHandler.getInstance().submitTask(task);
    }

    public static void updateNetworkEntityStatus(NetworkEntity networkEntity, int status) {
        if (null == networkEntity) {
            logger.error((Object)"the NetworkEntity object is null.");
            throw new LegoCheckedException(1073947393L);
        }
        logger.debug((Object)("update ne status, mainType=" + networkEntity.getMainType() + ", sn=" + networkEntity.getSn() + ", ip=" + networkEntity.getIpAddress() + ", status=" + status));
        IMoDao moDao = CommonDAOLocator.getMoDao();
        HibernateTemplate template = moDao.getHibernateTemplate();
        template.execute(session -> {
            String hql = "update ManagedObject set status=? where uuid=?";
            Query query = session.createQuery(hql);
            query.setInteger(0, status);
            query.setParameter(1, (Object)networkEntity.getUuid());
            query.executeUpdate();
            return null;
        });
    }

    public static void grantUserNeAuthority(NetworkEntity entity, Long userId) {
        if (null == userId) {
            logger.info((Object)"This may be a refresh progress, userId is null.", 90160758784000L);
            return;
        }
        IUserMgr userMgr = (IUserMgr)ServiceLocator.getInstance().getService(IUserMgr.class);
        logger.info((Object)("Grant for user=" + userId + ", moId=" + entity.getMoId() + ", sn=" + entity.getSn()), 90160758784000L);
        if (userMgr.checkUserIsAdmin(userId.longValue()).booleanValue()) {
            return;
        }
        HashSet<Long> moIds = new HashSet<Long>();
        moIds.add(entity.getMoId());
        userMgr.grandObjectToUser(userId.longValue(), moIds);
    }
}

