/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.xve.handler;

import com.huawei.ism.array.sdk.model.ArrayHost;
import com.huawei.ism.array.sdk.model.MappingView;
import com.huawei.ism.array.sdk.model.XveDisk;
import com.huawei.ism.array.sdk.model.XveLun;
import com.huawei.ism.array.sdk.model.XveStorage;
import com.huawei.ism.array.sdk.model.XveStoragePool;
import com.huawei.ism.array.sdk.model.XveTier;
import com.huawei.ism.array.sdk.model.XveUnit;
import com.huawei.ism.base.sdk.model.Initiator;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.service.impl.XveDeviceProxyImpl;
import com.huawei.ism.cbb.discover.xve.XveTLVTransition;
import com.huawei.ism.cbb.proxy.indication.Notification;
import com.huawei.ism.cbb.proxy.protocol.tlv.connection.TLVConnection;
import com.huawei.ism.cbb.proxy.protocol.tlv.msg.Param;
import com.huawei.ism.cbb.proxy.protocol.tlv.msg.Record;
import com.huawei.ism.cbb.proxy.xve.TLVParamUtil;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.proxy.xve.XveTLV;
import com.huawei.ism.cbb.proxy.xve.XveTLVPParent;
import com.huawei.ism.cbb.proxy.xve.XveUUID;
import com.huawei.ism.cbb.util.unit.CapabilityUnitType;
import com.huawei.ism.cbb.util.unit.IUnitType;
import com.huawei.ism.cbb.util.unit.UnitConvert;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hibernate.query.NativeQuery;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class XveHandlerComm {
    private static Log logger = LogFactory.getInstance(XveHandlerComm.class, (String)"UBase/Xve_Discover");
    private static XveHandlerComm instance;

    public static synchronized XveHandlerComm getInstance() {
        if (instance == null) {
            logger.info((Object)"Initialize XveHandlerComm");
            instance = new XveHandlerComm();
        }
        return instance;
    }

    private String getUuId(Notification msg, String type) {
        String uuId;
        String deviceID = (String)msg.getAttribute("deviceID");
        Integer typeValue = (Integer)msg.getAttribute("typeValue");
        String idValue = (String)msg.getAttribute("idValue");
        if ("storageArray".equals(type)) {
            uuId = "XveStorage" + new XveUUID(deviceID, XveMOType.SYSTEM.getValue(), "").toString();
        } else if ("xveUnit".equals(type)) {
            uuId = new XveUUID(deviceID, XveMOType.SYSTEM.getValue(), "").toString();
        } else if ("initiator".equals(type)) {
            if (null == idValue) {
                logger.error((Object)"idValue is null.");
                throw new LegoCheckedException(1073947393L);
            }
            uuId = new XveUUID(deviceID, typeValue, String.valueOf(idValue.hashCode())).toString();
        } else {
            uuId = new XveUUID(deviceID, typeValue, idValue).toString();
        }
        return uuId;
    }

    public ManagedObject getOldInfo(Notification msg, String type) {
        ManagedObject oldInfo;
        if (msg == null || type == null) {
            logger.debug((Object)("type:" + type));
            return null;
        }
        IMoDao moDao = CommonDAOLocator.getMoDao();
        try {
            oldInfo = moDao.getMoByUuid(this.getUuId(msg, type), Boolean.valueOf(true));
        }
        catch (Exception ex) {
            logger.error((Object)("Get device info from db by UUID error.Error info" + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160777658373L);
            oldInfo = null;
        }
        return oldInfo;
    }

    protected XveUnit getNewXveUnit(Notification msg) {
        XveUnit xveUnitNew;
        if (msg == null) {
            return null;
        }
        XveDeviceProxyImpl xveDeviceProxy = new XveDeviceProxyImpl();
        TLVConnection connection = (TLVConnection)msg.getAttribute("conn");
        try {
            xveUnitNew = xveDeviceProxy.getComputerSystem(connection);
        }
        catch (Exception ex) {
            logger.error((Object)("Get storage info error.Error info" + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160777658373L);
            xveUnitNew = null;
        }
        return xveUnitNew;
    }

    protected XveDisk getNewDisks(Notification msg) {
        XveDisk xveDisk;
        if (msg == null) {
            return null;
        }
        TLVConnection connection = (TLVConnection)msg.getAttribute("conn");
        if (connection == null) {
            logger.error((Object)"connection is null.");
            return null;
        }
        Integer typeValue = (Integer)msg.getAttribute("typeValue");
        String idValue = (String)msg.getAttribute("idValue");
        String deviceID = (String)msg.getAttribute("deviceID");
        if (typeValue == null) {
            logger.error((Object)"typeValue is null.");
            return null;
        }
        try {
            Record record = connection.pmGet(typeValue, idValue, 30);
            xveDisk = XveTLVTransition.transitionXveDisk(deviceID, record);
        }
        catch (Exception ex) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)ex));
            xveDisk = null;
        }
        return xveDisk;
    }

    protected XveStoragePool getNewStoragePool(Notification msg) {
        XveStoragePool xveStoragePool;
        if (msg == null) {
            return null;
        }
        TLVConnection connection = (TLVConnection)msg.getAttribute("conn");
        if (connection == null) {
            logger.error((Object)"connection is null.");
            return null;
        }
        Integer typeValue = (Integer)msg.getAttribute("typeValue");
        if (typeValue == null) {
            logger.error((Object)"typeValue is null.");
            return null;
        }
        String idValue = (String)msg.getAttribute("idValue");
        String deviceID = (String)msg.getAttribute("deviceID");
        try {
            Record record = connection.pmGet(typeValue, idValue, 30);
            xveStoragePool = XveTLVTransition.transitionXveStoragePool(deviceID, record);
            TimeUnit.SECONDS.sleep(1L);
            ArrayList<Param> params = new ArrayList<Param>();
            params.add(new Param(XveTLV.StorageTier.PARENTID.getParamIndex(), XveTLV.StorageTier.PARENTID.getParamType(), xveStoragePool.getPoolId()));
            List<Record> tierRecords = connection.pmGetBacthNext(XveMOType.STORAGETIER.getValue(), params, 30);
            for (Record tierRecord : tierRecords) {
                XveTier xveTier = XveTLVTransition.transitionXveTier(deviceID, tierRecord);
                String poolId = xveTier.getPoolId();
                String tierId = xveTier.getTierId();
                if (tierId.equals(poolId + ".0")) {
                    xveStoragePool.setTier0FreeCapacity(xveTier.getTierAvailableCapacity());
                    xveStoragePool.setTier0UsedCapacity(xveTier.getTierConsumedCapacity());
                }
                if (tierId.equals(poolId + ".1")) {
                    xveStoragePool.setTier1FreeCapacity(xveTier.getTierAvailableCapacity());
                    xveStoragePool.setTier1UsedCapacity(xveTier.getTierConsumedCapacity());
                }
                if (!tierId.equals(poolId + ".2")) continue;
                xveStoragePool.setTier2FreeCapacity(xveTier.getTierAvailableCapacity());
                xveStoragePool.setTier2UsedCapacity(xveTier.getTierConsumedCapacity());
            }
        }
        catch (Exception ex) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)ex));
            xveStoragePool = null;
        }
        return xveStoragePool;
    }

    protected XveLun getNewLuns(Notification msg) {
        XveLun lun;
        if (msg == null) {
            return null;
        }
        TLVConnection connection = (TLVConnection)msg.getAttribute("conn");
        if (connection == null) {
            logger.error((Object)"connection is null.");
            return null;
        }
        Integer typeValue = (Integer)msg.getAttribute("typeValue");
        if (typeValue == null) {
            logger.error((Object)"typeValue is null.");
            return null;
        }
        String idValue = (String)msg.getAttribute("idValue");
        String devSn = (String)msg.getAttribute("deviceID");
        try {
            Record record = connection.pmGet(typeValue, idValue, 30);
            lun = XveDeviceProxyImpl.parseLun(devSn, record);
        }
        catch (Exception ex) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)ex));
            lun = null;
        }
        return lun;
    }

    private boolean checkPara(Notification msg) {
        if (msg == null) {
            logger.error((Object)"msg is null.");
            return false;
        }
        TLVConnection connection = (TLVConnection)msg.getAttribute("conn");
        if (connection == null) {
            logger.error((Object)"connection is null.");
            return false;
        }
        Integer typeValue = (Integer)msg.getAttribute("typeValue");
        if (typeValue == null) {
            logger.error((Object)"typeValue is null.");
            return false;
        }
        return true;
    }

    protected MappingView getNewMappingView(Notification msg) {
        MappingView mappingView;
        if (!this.checkPara(msg)) {
            return null;
        }
        TLVConnection connection = (TLVConnection)msg.getAttribute("conn");
        Integer typeValue = (Integer)msg.getAttribute("typeValue");
        String idValue = (String)msg.getAttribute("idValue");
        String deviceID = (String)msg.getAttribute("deviceID");
        try {
            Record record = connection.pmGet(typeValue, idValue, 30);
            if (null == record) {
                logger.error((Object)"record is null.");
                return null;
            }
            String mappingViewId = record.getParamStrValue(XveTLV.MappingView.ID.getParamIndex());
            String name = record.getParamStrValue(XveTLV.MappingView.NAME.getParamIndex());
            String description = record.getParamStrValue(XveTLV.MappingView.DESCRIPTION.getParamIndex());
            mappingView = new MappingView();
            mappingView.setUuid(new XveUUID(deviceID, XveMOType.MAPPINGVIEW, mappingViewId).toString());
            mappingView.setMappingViewId(mappingViewId);
            mappingView.setName(name);
            mappingView.setDescription(description);
        }
        catch (Exception ex) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)ex));
            mappingView = null;
        }
        return mappingView;
    }

    protected ArrayHost getNewArrayHost(Notification msg) {
        ArrayHost arrayHost;
        if (!this.checkPara(msg)) {
            return null;
        }
        TLVConnection connection = (TLVConnection)msg.getAttribute("conn");
        Integer typeValue = (Integer)msg.getAttribute("typeValue");
        String idValue = (String)msg.getAttribute("idValue");
        String deviceID = (String)msg.getAttribute("deviceID");
        try {
            Record record = connection.pmGet(typeValue, idValue, 30);
            arrayHost = XveTLVTransition.transitionArrayHost(deviceID, record);
        }
        catch (Exception ex) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)ex));
            arrayHost = null;
        }
        return arrayHost;
    }

    protected Initiator getNewInitiator(Notification msg) {
        if (!this.checkPara(msg)) {
            return null;
        }
        Initiator initiator = null;
        TLVConnection connection = (TLVConnection)msg.getAttribute("conn");
        Integer typeValue = (Integer)msg.getAttribute("typeValue");
        String idValue = (String)msg.getAttribute("idValue");
        String deviceID = (String)msg.getAttribute("deviceID");
        try {
            Record record = connection.pmGet(typeValue, idValue, 30);
            if (typeValue.intValue() == XveMOType.FC_INITIATOR.getValue()) {
                initiator = XveDeviceProxyImpl.getFcInitiatorInfo(record, deviceID);
            } else if (typeValue.intValue() == XveMOType.ISCSI_INITIATOR.getValue()) {
                initiator = XveDeviceProxyImpl.getIscsiInitiatorInfo(record, deviceID);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)ex));
        }
        return initiator;
    }

    protected void setOwnTieAndSave(ManagedObject son, Notification msg) {
        if (msg == null || son == null) {
            return;
        }
        try {
            XveUnit father;
            IMoDao moDao = CommonDAOLocator.getMoDao();
            if (son instanceof XveLun) {
                XveUUID uuId = new XveUUID((String)msg.getAttribute("deviceID"), XveMOType.STORAGEPOOL.getValue(), ((XveLun)son).getStoragePoolId());
                father = (XveStoragePool)moDao.getMoByUuid(uuId.toString(), Boolean.valueOf(true));
            } else {
                father = (XveUnit)this.getOldInfo(msg, "xveUnit");
            }
            if (father != null) {
                this.setManager((ManagedObject)father, son);
                son.setParentMo((ManagedObject)father);
                son.setTopMoUuid(father.getTopMoUuid());
                moDao.save((Object)son);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Save the create report error ..." + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160777658373L);
        }
    }

    private void setManager(ManagedObject father, ManagedObject son) {
        if (son instanceof XveStoragePool) {
            ((XveStoragePool)son).setNeSN(((XveUnit)father).getDevSn());
        }
    }

    protected void setLunCapacity(Notification msg) {
        if (msg == null) {
            return;
        }
        String deviceID = (String)msg.getAttribute("deviceID");
        IMoDao moDao = CommonDAOLocator.getMoDao();
        XveUnit xveUnit = (XveUnit)moDao.getMo(XveUnit.class, "devSn", (Object)deviceID);
        if (xveUnit == null) {
            logger.error((Object)"Can NOT find the top array of given LUN  !!! ", 90160777658373L);
        }
    }

    protected void getTv2Capacity(Notification msg) {
        if (msg == null) {
            return;
        }
        TLVConnection connection = (TLVConnection)msg.getAttribute("conn");
        if (connection == null) {
            return;
        }
        try {
            Record record = connection.pmGet(XveMOType.SYSTEM.getValue(), "", 30);
            XveUnit xveUnit = (XveUnit)this.getOldInfo(msg, "xveUnit");
            if (xveUnit == null) {
                return;
            }
            Double memberDisksCapacity = TLVParamUtil.getDoubleValue(record, XveTLVPParent.System.MEMBERDISKSCAPACITY);
            Double freeDisksCapacity = TLVParamUtil.getDoubleValue(record, XveTLVPParent.System.FREEDISKSCAPACITY);
            Integer sectorSize = TLVParamUtil.getIntValue(record, XveTLVPParent.System.SECTORSIZE);
            if (memberDisksCapacity != null && freeDisksCapacity != null && sectorSize != null) {
                double totalCapacity = UnitConvert.convert((Double)((memberDisksCapacity + freeDisksCapacity) * (double)sectorSize.intValue()), (IUnitType)CapabilityUnitType.Byte, (IUnitType)CapabilityUnitType.GB);
                double usedCapacity = UnitConvert.convert((Double)(memberDisksCapacity * (double)sectorSize.intValue()), (IUnitType)CapabilityUnitType.Byte, (IUnitType)CapabilityUnitType.GB);
                IMoDao moDao = CommonDAOLocator.getMoDao();
                HibernateTemplate template = moDao.getHibernateTemplate();
                template.execute(session -> {
                    String hql = "update ti_storageunit t set t.TOTALCAPACITY=?, t.USEDCAPACITY=? where t.MOID=?";
                    NativeQuery query = session.createSQLQuery(hql);
                    query.setDouble(0, totalCapacity);
                    query.setDouble(1, usedCapacity);
                    query.setLong(2, xveUnit.getMoId().longValue());
                    query.executeUpdate();
                    hql = "update ti_storagene t set t.TOTALCAPACITY=?, t.USEDCAPACITY=? where t.MOID=?";
                    query = session.createSQLQuery(hql);
                    query.setDouble(0, totalCapacity);
                    query.setDouble(1, usedCapacity);
                    query.setLong(2, xveUnit.getParentId().longValue());
                    query.executeUpdate();
                    return null;
                });
                XveStorage oldXveStorage = new XveStorage();
                oldXveStorage.setTotalCapacity(xveUnit.getTotalCapacity());
                XveStorage newXveStorage = (XveStorage)xveUnit.getParentMo();
                newXveStorage.setTotalCapacity(Double.valueOf(totalCapacity));
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Update Array Capacity info Error." + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160777658373L);
        }
    }
}

