/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.mediation.jms;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.jms.IMessageReceiver;
import com.huawei.ism.cbb.discover.poll.PollControllerLocator;
import com.huawei.ism.cbb.mediation.jms.IMessageReceiverExtender;
import com.huawei.ism.cbb.mediation.service.impl.NeMgrProtocolExtendServiceImpl;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.comm.internal.jms.MessageRegister;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class NetworkEntityDelMsgReceiver
implements IMessageReceiver {
    private static Log logger = LogFactory.getInstance(NetworkEntityDelMsgReceiver.class);
    private List<IMessageReceiverExtender> extenderList = new ArrayList<IMessageReceiverExtender>();

    public List<MessageRegister> getMessageRegister() {
        MessageRegister deleteMOReg = new MessageRegister();
        deleteMOReg.setMessageTopic(MessageTopic.DATA);
        deleteMOReg.addMessageCode(105L);
        ArrayList<MessageRegister> list = new ArrayList<MessageRegister>();
        list.add(deleteMOReg);
        return list;
    }

    public void onBind(IMessageReceiverExtender extender, Map<?, ?> properties) {
        this.extenderList.add(extender);
    }

    public void onUnbind(IMessageReceiverExtender extender, Map<?, ?> properties) {
        this.extenderList.remove(extender);
    }

    public void process(MessageUnit messageUnit) {
        Object obj = messageUnit.getObj();
        if (null == obj) {
            return;
        }
        NetworkEntity deleteNe = null;
        Map objs = (Map)obj;
        Collection mos = objs.values();
        for (ManagedObject mo : mos) {
            if (!(mo instanceof NetworkEntity)) continue;
            deleteNe = (NetworkEntity)mo;
            break;
        }
        if (null == deleteNe) {
            return;
        }
        this.stopPoller(deleteNe);
        this.postProcess(deleteNe);
        this.deleteNetMgrProtocol(deleteNe);
    }

    private void deleteNetMgrProtocol(NetworkEntity ne) {
        try {
            NeMgrProtocolExtendServiceImpl neService = new NeMgrProtocolExtendServiceImpl();
            NeMgrProtocolExtend neMgrExtend = neService.findByMoId(ne.getMoId());
            if (!VerifyUtil.isEmpty((Object)neMgrExtend)) {
                neService.delete(neMgrExtend);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Delete NeMgrProtocolExtend of the device(name:" + ne.getName() + ") error." + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }

    private void postProcess(NetworkEntity ne) {
        for (IMessageReceiverExtender extender : this.extenderList) {
            extender.postProcess(ne);
        }
    }

    private void stopPoller(NetworkEntity ne) {
        try {
            PollControllerLocator.getInstance().getPollController().stopPoller(ne.getUuid(), true);
            PollControllerLocator.getInstance().getPingController().stopPoller(ne.getUuid(), true);
        }
        catch (Exception e) {
            logger.error((Object)("Stop the device(name:" + ne.getName() + ") poll controller error." + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }
}

